/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.FifoHashListModel;
import java.awt.Color;
import java.awt.Point;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SortedValuesJList
extends JList {
    protected final FifoHashListModel sortedListModelObj = new FifoHashListModel();
    protected static final boolean SORT_DIR_FLAG = true;
    private boolean sortDirFlag;
    private int sortType;
    protected Object selectedKeyObject = null;
    protected final Object selectedKeySyncObj = new Object();
    protected ListSelKeyChangeCallBack listSelKeyChangeCallBackObj = null;

    public SortedValuesJList(ListCellRenderer cellRendererObj, Map tableMapObj, boolean sortDirFlag, int sortType) {
        this.sortDirFlag = sortDirFlag;
        this.sortType = sortType;
        if (cellRendererObj != null) {
            this.setCellRenderer(cellRendererObj);
        }
        if (tableMapObj != null) {
            this.sortedListModelObj.putSortByValueAll(tableMapObj, sortDirFlag, sortType);
        }
        this.setModel(this.sortedListModelObj);
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evtObj) {
                if (!evtObj.getValueIsAdjusting()) {
                    SortedValuesJList.this.processListSelectionChange();
                }
            }
        });
    }

    public SortedValuesJList(ListCellRenderer cellRendererObj, Map tableMapObj, boolean sortDirFlag) {
        this(cellRendererObj, tableMapObj, sortDirFlag, 0);
    }

    public SortedValuesJList(ListCellRenderer cellRendererObj, Map tableMapObj) {
        this(cellRendererObj, tableMapObj, true);
    }

    public SortedValuesJList(ListCellRenderer cellRendererObj) {
        this(cellRendererObj, null);
    }

    public SortedValuesJList(Map tableMapObj) {
        this(null, tableMapObj);
    }

    public SortedValuesJList() {
        this(null, null);
    }

    public boolean getSortFlag() {
        return this.sortDirFlag;
    }

    public int getSortType() {
        return this.sortType;
    }

    public void reSortList(final boolean sortDirFlag, final int sortType) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doReSortList(sortDirFlag, sortType);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SortedValuesJList.this.doReSortList(sortDirFlag, sortType);
                }
            });
        }
    }

    private void doReSortList(boolean sortDirFlag, int sortType) {
        this.sortDirFlag = sortDirFlag;
        this.sortType = sortType;
        this.sortedListModelObj.reSortList(sortDirFlag, sortType);
        this.resyncSelectedItem();
    }

    public void put(Object key, Object value) {
        this.put(key, value, value instanceof Comparable);
    }

    public void put(final Object key, final Object value, final boolean sortFlag) {
        if (SwingUtilities.isEventDispatchThread()) {
            boolean selVisFlag = this.isSelectionVisible();
            if (sortFlag) {
                this.sortedListModelObj.putSortByValue(key, value, this.sortDirFlag, this.sortType);
            } else {
                this.sortedListModelObj.put(key, value);
            }
            this.resyncSelectedItem();
            if (selVisFlag) {
                this.ensureSelectionVisible();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean selVisFlag = SortedValuesJList.this.isSelectionVisible();
                    if (sortFlag) {
                        SortedValuesJList.this.sortedListModelObj.putSortByValue(key, value, SortedValuesJList.this.sortDirFlag, SortedValuesJList.this.sortType);
                    } else {
                        SortedValuesJList.this.sortedListModelObj.put(key, value);
                    }
                    SortedValuesJList.this.resyncSelectedItem();
                    if (selVisFlag) {
                        SortedValuesJList.this.ensureSelectionVisible();
                    }
                }
            });
        }
    }

    public void putAll(Map mapObj) {
        this.putAll(mapObj, true);
    }

    public void putAll(final Map mapObj, final boolean sortFlag) {
        if (SwingUtilities.isEventDispatchThread()) {
            boolean selVisFlag = this.isSelectionVisible();
            if (sortFlag) {
                this.sortedListModelObj.putSortByValueAll(mapObj, this.sortDirFlag, this.sortType);
            } else {
                this.sortedListModelObj.putAll(mapObj);
            }
            this.resyncSelectedItem();
            if (selVisFlag) {
                this.ensureSelectionVisible();
            }
        } else if (mapObj.size() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean selVisFlag = SortedValuesJList.this.isSelectionVisible();
                    if (sortFlag) {
                        SortedValuesJList.this.sortedListModelObj.putSortByValueAll(mapObj, SortedValuesJList.this.sortDirFlag, SortedValuesJList.this.sortType);
                    } else {
                        SortedValuesJList.this.sortedListModelObj.putAll(mapObj);
                    }
                    SortedValuesJList.this.resyncSelectedItem();
                    if (selVisFlag) {
                        SortedValuesJList.this.ensureSelectionVisible();
                    }
                }
            });
        }
    }

    public void removeKey(final Object key) {
        if (SwingUtilities.isEventDispatchThread()) {
            boolean selVisFlag = this.isSelectionVisible();
            this.sortedListModelObj.removeKey(key);
            this.resyncSelectedItem();
            if (selVisFlag) {
                this.ensureSelectionVisible();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean selVisFlag = SortedValuesJList.this.isSelectionVisible();
                    SortedValuesJList.this.sortedListModelObj.removeKey(key);
                    SortedValuesJList.this.resyncSelectedItem();
                    if (selVisFlag) {
                        SortedValuesJList.this.ensureSelectionVisible();
                    }
                }
            });
        }
    }

    public void setListData(final Map tableMapObj) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.clearSelection();
            this.sortedListModelObj.clear();
            if (tableMapObj != null) {
                this.sortedListModelObj.putSortByValueAll(tableMapObj, this.sortDirFlag, this.sortType);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SortedValuesJList.super.clearSelection();
                    SortedValuesJList.this.sortedListModelObj.clear();
                    if (tableMapObj != null) {
                        SortedValuesJList.this.sortedListModelObj.putSortByValueAll(tableMapObj, SortedValuesJList.this.sortDirFlag, SortedValuesJList.this.sortType);
                    }
                }
            });
        }
    }

    public void repaint() {
        if (SwingUtilities.isEventDispatchThread()) {
            super.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SortedValuesJList.super.repaint();
                }
            });
        }
    }

    public void requestFocus() {
        if (SwingUtilities.isEventDispatchThread()) {
            super.requestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SortedValuesJList.super.requestFocus();
                }
            });
        }
    }

    public void setSelectedKey(final Object keyObj, final boolean ensureVisibleFlag) {
        if (SwingUtilities.isEventDispatchThread()) {
            int indexVal = this.sortedListModelObj.indexOfKey(keyObj);
            if (indexVal >= 0) {
                this.doSetSelectedIndex(indexVal, ensureVisibleFlag);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int indexVal = SortedValuesJList.this.sortedListModelObj.indexOfKey(keyObj);
                    if (indexVal >= 0) {
                        SortedValuesJList.this.doSetSelectedIndex(indexVal, ensureVisibleFlag);
                    }
                }
            });
        }
    }

    public void setSelectedKey(Object keyObj) {
        this.setSelectedKey(keyObj, false);
    }

    public void setSelectedIndex(final int val, final boolean ensureVisibleFlag) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetSelectedIndex(val, ensureVisibleFlag);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SortedValuesJList.this.doSetSelectedIndex(val, ensureVisibleFlag);
                }
            });
        }
    }

    public void setSelectedIndex(int val) {
        this.setSelectedIndex(val, false);
    }

    protected void doSetSelectedIndex(int val, boolean ensureVisibleFlag) {
        super.setSelectedIndex(val);
        if (ensureVisibleFlag) {
            super.ensureIndexIsVisible(val);
            super.repaint();
        }
    }

    public void selectLastItemInList(final boolean ensureVisibleFlag, boolean alwaysQueueFlag) {
        if (!alwaysQueueFlag && SwingUtilities.isEventDispatchThread()) {
            this.doSelectLastItemInList(ensureVisibleFlag);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SortedValuesJList.this.doSelectLastItemInList(ensureVisibleFlag);
                }
            });
        }
    }

    public void selectLastItemInList(boolean ensureVisibleFlag) {
        this.selectLastItemInList(ensureVisibleFlag, false);
    }

    protected void doSelectLastItemInList(boolean ensureVisibleFlag) {
        try {
            int idx = this.sortedListModelObj.getSize();
            if (idx > 0) {
                super.setSelectedIndex(--idx);
                if (ensureVisibleFlag) {
                    super.ensureIndexIsVisible(idx);
                    super.repaint();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ensureSelectionVisible() {
        if (SwingUtilities.isEventDispatchThread()) {
            int selIdx = this.getSelectedIndex();
            if (selIdx >= 0) {
                super.ensureIndexIsVisible(selIdx);
                super.repaint();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int selIdx = SortedValuesJList.this.getSelectedIndex();
                    if (selIdx >= 0) {
                        SortedValuesJList.super.ensureIndexIsVisible(selIdx);
                        SortedValuesJList.super.repaint();
                    }
                }
            });
        }
    }

    public void clearSelection() {
        if (SwingUtilities.isEventDispatchThread()) {
            super.clearSelection();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SortedValuesJList.super.clearSelection();
                }
            });
        }
    }

    public Object getCellAt(int indexVal) {
        try {
            return this.sortedListModelObj.getElementAt(indexVal);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Object locationToValue(Point pointObj) {
        int idx = super.locationToIndex(pointObj);
        return idx >= 0 ? this.getCellAt(idx) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSelectedKeyObj() {
        Object object = this.selectedKeySyncObj;
        synchronized (object) {
            return this.selectedKeyObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelectedKeyString() {
        Object object = this.selectedKeySyncObj;
        synchronized (object) {
            return this.selectedKeyObject instanceof String ? (String)this.selectedKeyObject : null;
        }
    }

    public boolean isSelectionVisible() {
        int selIdx = this.getSelectedIndex();
        return selIdx >= 0 && selIdx >= this.getFirstVisibleIndex() && selIdx <= this.getLastVisibleIndex();
    }

    public void setListenersEnabled(boolean flgVal) {
        this.sortedListModelObj.setListenersEnabled(flgVal);
    }

    public void fireContentsChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.sortedListModelObj.fireContentsChanged();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SortedValuesJList.this.sortedListModelObj.fireContentsChanged();
                }
            });
        }
    }

    public void setColors(final Color foregroundColor, final Color backgroundColor, final Color selForegroundColor, final Color selBackgroundColor, boolean directFlag) {
        if (directFlag || SwingUtilities.isEventDispatchThread()) {
            this.doSetColors(foregroundColor, backgroundColor, selForegroundColor, selBackgroundColor);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SortedValuesJList.this.doSetColors(foregroundColor, backgroundColor, selForegroundColor, selBackgroundColor);
                }
            });
        }
    }

    public void setColors(Color foregroundColor, Color backgroundColor, Color selForegroundColor, Color selBackgroundColor) {
        this.setColors(foregroundColor, backgroundColor, selForegroundColor, selBackgroundColor, false);
    }

    protected void doSetColors(Color foregroundColor, Color backgroundColor, Color selForegroundColor, Color selBackgroundColor) {
        if (foregroundColor != null) {
            this.setForeground(foregroundColor);
        }
        if (backgroundColor != null) {
            this.setBackground(backgroundColor);
        }
        if (selForegroundColor != null) {
            this.setSelectionForeground(selForegroundColor);
        }
        if (selBackgroundColor != null) {
            this.setSelectionBackground(selBackgroundColor);
        }
        this.repaint();
    }

    protected void resyncSelectedItem() {
        this.setSelectedKey(this.getSelectedKeyObj());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processListSelectionChange() {
        boolean changedFlag;
        Object keyObj;
        try {
            int selIdx = super.getSelectedIndex();
            keyObj = selIdx >= 0 ? this.sortedListModelObj.keyAt(selIdx) : null;
        }
        catch (Exception ex) {
            keyObj = null;
        }
        Object object = this.selectedKeySyncObj;
        synchronized (object) {
            changedFlag = keyObj != this.selectedKeyObject;
            if (changedFlag) {
                this.selectedKeyObject = keyObj;
            }
        }
        if (changedFlag && this.listSelKeyChangeCallBackObj != null) {
            this.listSelKeyChangeCallBackObj.newSelectedKeyObj(keyObj);
        }
    }

    public void setListSelKeyChangeCallBack(ListSelKeyChangeCallBack cbObj) {
        this.listSelKeyChangeCallBackObj = cbObj;
    }

    public static interface ListSelKeyChangeCallBack {
        public void newSelectedKeyObj(Object var1);
    }
}

