/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SimpleDialog
extends JDialog
implements ActionListener {
    private JPanel topPanel = new JPanel(new BorderLayout());
    private Component message;
    private JButton closeButton;
    private JComponent initialFocusComponent;

    public static Frame getFrameForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Frame) {
            return (Frame)parentComponent;
        }
        return SimpleDialog.getFrameForComponent(parentComponent.getParent());
    }

    public SimpleDialog(Component owner, String title, boolean modal, Component message, JButton button) {
        this(SimpleDialog.getFrameForComponent(owner), title, modal, message, button, true);
    }

    public SimpleDialog(Component owner, String title, boolean modal, Component message, JButton button, boolean centerFlag) {
        this(SimpleDialog.getFrameForComponent(owner), title, modal, message, button, centerFlag);
    }

    public SimpleDialog(Frame owner, String title, boolean modal, Component message, JButton button) {
        this(owner, title, modal, message, button, true);
    }

    public SimpleDialog(Frame owner, String title, boolean modal, Component message, JButton button, boolean centerFlag) {
        super(owner, title, modal);
        this.message = message;
        this.closeButton = button;
        this.initialFocusComponent = button;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (centerFlag && owner != null) {
            this.setLocationRelativeTo(owner);
        }
    }

    private void jbInit() throws Exception {
        this.enableEvents(64L);
        this.setBackground(this.topPanel.getBackground());
        this.setDefaultCloseOperation(2);
        this.setForeground(this.topPanel.getForeground());
        this.topPanel.setBackground(null);
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.topPanel.setForeground(null);
        if (this.closeButton != null) {
            if (this.closeButton.getText().length() <= 0) {
                this.closeButton.setText("OK");
            }
            if (this.closeButton.getParent() == null) {
                JPanel buttonPanel = new JPanel(new FlowLayout());
                buttonPanel.setBackground(null);
                buttonPanel.setForeground(null);
                this.closeButton.setBackground(null);
                this.closeButton.setForeground(null);
                buttonPanel.add((Component)this.closeButton, null);
                this.topPanel.add((Component)buttonPanel, "South");
            }
        }
        if (this.message != null) {
            this.topPanel.add(this.message, "Center");
        }
        this.getContentPane().add((Component)this.topPanel, null);
        if (this.closeButton != null) {
            this.closeButton.addActionListener(this);
        }
        this.pack();
        this.addWindowListener(new WindowAdapter(){
            private boolean gotFocus = false;

            public void windowClosing(WindowEvent we) {
                this.gotFocus = false;
            }

            public void windowActivated(WindowEvent we) {
                if (!this.gotFocus) {
                    SimpleDialog.this.setInitialFocus();
                    this.gotFocus = true;
                }
            }
        });
    }

    public void setInitialFocus() {
        if (this.initialFocusComponent != null) {
            if (this.closeButton != this.initialFocusComponent && this.closeButton != null) {
                this.closeButton.setRequestFocusEnabled(false);
            }
            this.initialFocusComponent.requestFocus();
        }
    }

    public void setInitialFocusComponent(JComponent component) {
        this.initialFocusComponent = component;
        this.setInitialFocus();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.closeButton != null && e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.getContentPane().setBackground(c);
    }

    public void setBorder(Border border) {
        if (this.topPanel != null) {
            this.topPanel.setBorder(border);
        }
    }

    public Border getBorder() {
        if (this.topPanel != null) {
            return this.topPanel.getBorder();
        }
        return null;
    }
}

