/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.LaunchBrowser;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class LaunchBrowserListener
implements MouseListener {
    private static final Cursor handCursor = new Cursor(12);
    private final LaunchBrowser launchBrowserObj;
    private Component compObj = null;
    private Cursor compDefaultCursor = null;
    private String linkStr = null;

    public LaunchBrowserListener(LaunchBrowser launchBrowserObj) {
        this(launchBrowserObj, null);
    }

    public LaunchBrowserListener(LaunchBrowser launchBrowserObj, Component compObj) {
        this(launchBrowserObj, compObj, null);
    }

    public LaunchBrowserListener(LaunchBrowser launchBrowserObj, Component compObj, String linkStr) {
        this.launchBrowserObj = launchBrowserObj;
        this.setLinkStr(linkStr);
        this.setComponent(compObj);
    }

    public Component getComponent() {
        return this.compObj;
    }

    public LaunchBrowser getLaunchBrowser() {
        return this.launchBrowserObj;
    }

    public String getLinkStr() {
        return this.linkStr;
    }

    public synchronized void setComponent(Component compObj) {
        if (this.compObj != null) {
            compObj.setCursor(this.compDefaultCursor);
            compObj.removeMouseListener(this);
            this.compObj = null;
            this.compDefaultCursor = null;
        }
        if (compObj != null) {
            this.compDefaultCursor = compObj.getCursor();
            this.compObj = compObj;
            compObj.addMouseListener(this);
            if (compObj instanceof JComponent) {
                JComponent jCompObj = (JComponent)compObj;
                jCompObj.setRequestFocusEnabled(false);
            }
            if (compObj instanceof AbstractButton) {
                AbstractButton buttonObj = (AbstractButton)compObj;
                buttonObj.setBorderPainted(false);
                buttonObj.setFocusPainted(false);
            }
        }
        this.setupCursor();
    }

    public synchronized void setLinkStr(String linkStr) {
        this.linkStr = linkStr;
        this.setupCursor();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        String urlStr = this.linkStr;
        if (urlStr != null && urlStr.length() > 0) {
            this.launchBrowserObj.showURL(urlStr, "Browser");
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    protected void setupCursor() {
        if (this.compObj != null) {
            if (this.linkStr == null) {
                this.compObj.setCursor(this.compDefaultCursor);
            } else {
                this.compObj.setCursor(handCursor);
            }
        }
    }
}

