/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.IstiCalendarPanel;
import com.isti.util.gui.TimeJTextField;
import com.isti.util.gui.TransferFocusListener;
import com.isti.util.gui.UpdateHandler;
import com.isti.util.gui.UpdateListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.EventListenerList;

public class IstiTimePanel
extends JPanel
implements UpdateListener {
    private final TitledBorder borderObj = new TitledBorder(BorderFactory.createEtchedBorder(), "Time");
    private final JLabel dayOfMonthLabel = new JLabel();
    private final JLabel monthLabel = new JLabel();
    private final JLabel yearLabel = new JLabel();
    private final Calendar calObj;
    private final JComboBox monthComboBox = new JComboBox<String>(IstiCalendarPanel.MONTH_TEXT);
    private final JComboBox dayComboBox = new JComboBox();
    private final IstiCalendarPanel.YearJComboBox yearComboBox = new IstiCalendarPanel.YearJComboBox();
    private final JLabel timeLabel = new JLabel();
    private final TimeJTextField timeTextField;
    private final JButton calendarButton = new JButton();
    protected static boolean debugFlag = false;
    private int displayMaxDays = 0;
    private Object timeUpdateLockObj = new Object();
    private boolean timeUpdateFlag = false;
    private EventListenerList listenerList = new EventListenerList();
    protected final String monthTipText;
    protected final String dayOfMonthTextTip;
    protected final String yearTextTip;
    protected final String timeTipText;
    protected final String calendarTipText;
    static /* synthetic */ Class class$com$isti$util$gui$UpdateListener;

    public IstiTimePanel() {
        this((String)null);
    }

    public IstiTimePanel(String title) {
        this(title, true);
    }

    public IstiTimePanel(String title, boolean showZeroTextFlag) {
        this(title, showZeroTextFlag, null);
    }

    public IstiTimePanel(String title, boolean showZeroTextFlag, Calendar calObj) {
        if (calObj == null) {
            calObj = Calendar.getInstance();
        }
        this.calObj = calObj;
        this.timeTextField = new TimeJTextField(8, showZeroTextFlag, calObj);
        this.monthTipText = "Month-of-the-year";
        this.dayOfMonthTextTip = "Day-of-the-month";
        this.yearTextTip = "Year";
        this.timeTipText = "Time-of-day value (" + this.timeTextField.timeFormatterObj.toPattern() + ")";
        this.calendarTipText = "Show calendar";
        this.borderObj.setTitleColor(Color.black);
        if (title != null) {
            this.setName(title);
            this.setTitle(title);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Date getMaxTime() {
        return this.timeTextField.getMaxTime();
    }

    public Date getMinTime() {
        return this.timeTextField.getMinTime();
    }

    public Date getTime() {
        return this.getCalendar().getTime();
    }

    public TimeZone getTimeZone() {
        return this.calObj.getTimeZone();
    }

    public String getTitle() {
        return this.borderObj.getTitle();
    }

    public boolean isEnabled() {
        return this.timeTextField.isEnabled();
    }

    public boolean isShowLabels() {
        return this.dayOfMonthLabel.isVisible();
    }

    public void setEnabled(boolean b) {
        this.timeTextField.setEnabled(b);
        this.dayComboBox.setEnabled(b);
        this.monthComboBox.setEnabled(b);
        this.yearComboBox.setEnabled(b);
        this.calendarButton.setEnabled(b);
    }

    public void setShowLabels(boolean b) {
        this.dayOfMonthLabel.setVisible(b);
        this.monthLabel.setVisible(b);
        this.yearLabel.setVisible(b);
        this.timeLabel.setVisible(b);
    }

    public boolean setMaxTime(Date date) {
        boolean updateFlag = this.timeTextField.setMaxTime(date);
        if (updateFlag) {
            this.yearComboBox.setMaxTime(this.timeTextField.getMaxTime(), true);
        }
        return updateFlag;
    }

    public boolean setMinTime(Date date) {
        boolean updateFlag = this.timeTextField.setMinTime(date);
        if (updateFlag) {
            this.yearComboBox.setMinTime(this.timeTextField.getMinTime(), true);
        }
        return updateFlag;
    }

    public boolean setTime(Date date) {
        this.setTimeUpdateFlag(true);
        boolean updatedFlag = this.timeTextField.setTime(date);
        if (updatedFlag) {
            this.updateDays();
            this.updateDateFields();
        }
        this.setTimeUpdateFlag(false);
        if (updatedFlag) {
            this.fireUpdate(this, new EventObject(this));
        }
        return updatedFlag;
    }

    public void setTimeZone(TimeZone value) {
        this.calObj.setTimeZone(value);
        this.timeTextField.setTimeZone(value);
        this.yearComboBox.setTimeZone(value);
        this.yearComboBox.updateYears();
    }

    public void setTitle(String title) {
        this.borderObj.setTitle(title);
    }

    public String toString() {
        return this.getTime().toString();
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createCompoundBorder(this.borderObj, BorderFactory.createEmptyBorder(4, 0, 0, 0)));
        this.setLayout(new FlowLayout());
        this.yearComboBox.setTimeZone(this.getTimeZone());
        this.yearComboBox.updateYears();
        this.updateDays();
        this.updateDateFields();
        this.monthComboBox.addActionListener(new UpdateHandler(this.monthComboBox, this));
        this.dayComboBox.addActionListener(new UpdateHandler(this.dayComboBox, this));
        this.yearComboBox.addActionListener(new UpdateHandler(this.yearComboBox, this));
        this.timeTextField.addFocusListener(new UpdateHandler(this.timeTextField, this));
        this.timeTextField.addActionListener(TransferFocusListener.LISTENER);
        this.monthLabel.setForeground(Color.black);
        this.monthLabel.setHorizontalAlignment(0);
        this.monthLabel.setHorizontalTextPosition(0);
        this.monthLabel.setText("Month: ");
        this.monthLabel.setToolTipText(this.monthTipText);
        this.monthComboBox.setToolTipText(this.monthTipText);
        JPanel monthPanel = new JPanel();
        monthPanel.setLayout(new FlowLayout());
        monthPanel.add(this.monthLabel);
        monthPanel.add((Component)this.monthComboBox, null);
        this.add(monthPanel);
        this.dayOfMonthLabel.setForeground(Color.black);
        this.dayOfMonthLabel.setHorizontalAlignment(0);
        this.dayOfMonthLabel.setHorizontalTextPosition(0);
        this.dayOfMonthLabel.setText("Day: ");
        this.dayOfMonthLabel.setToolTipText(this.dayOfMonthTextTip);
        this.dayComboBox.setToolTipText(this.dayOfMonthTextTip);
        JPanel dayPanel = new JPanel();
        dayPanel.setLayout(new FlowLayout());
        dayPanel.add(this.dayOfMonthLabel);
        dayPanel.add((Component)this.dayComboBox, null);
        this.add(dayPanel);
        this.yearLabel.setForeground(Color.black);
        this.yearLabel.setHorizontalAlignment(0);
        this.yearLabel.setHorizontalTextPosition(0);
        this.yearLabel.setText("Year: ");
        this.yearLabel.setToolTipText(this.yearTextTip);
        this.yearComboBox.setToolTipText(this.yearTextTip);
        this.calendarButton.setText("Calendar");
        this.calendarButton.setToolTipText(this.calendarTipText);
        this.calendarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IstiTimePanel.this.calendarButton_actionPerformed(e);
            }
        });
        JPanel yearPanel = new JPanel();
        yearPanel.setLayout(new FlowLayout());
        yearPanel.add(this.yearLabel);
        yearPanel.add((Component)this.yearComboBox, null);
        yearPanel.add((Component)this.calendarButton, null);
        this.add(yearPanel);
        this.timeLabel.setForeground(Color.black);
        this.timeLabel.setHorizontalAlignment(0);
        this.timeLabel.setHorizontalTextPosition(0);
        this.timeLabel.setText("Time: ");
        this.timeLabel.setToolTipText(this.timeTipText);
        this.timeTextField.setToolTipText(this.timeTipText);
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new FlowLayout());
        timePanel.add(this.timeLabel);
        timePanel.add(this.timeTextField);
        this.add(timePanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTimeUpdate() {
        Object object = this.timeUpdateLockObj;
        synchronized (object) {
            return this.timeUpdateFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTimeUpdateFlag(boolean b) {
        Object object = this.timeUpdateLockObj;
        synchronized (object) {
            this.timeUpdateFlag = b;
        }
    }

    protected void updateDateFields() {
        this.monthComboBox.setSelectedIndex(this.getMonth());
        this.dayComboBox.setSelectedItem(String.valueOf(this.getDayOfMonth()));
        this.yearComboBox.setYear(this.getYear());
    }

    protected void updateDays() {
        int maxDay = this.calObj.getActualMaximum(5);
        if (this.displayMaxDays != maxDay) {
            if (maxDay > this.displayMaxDays) {
                for (int dayOfMonth = this.displayMaxDays + 1; dayOfMonth <= maxDay; ++dayOfMonth) {
                    this.dayComboBox.addItem(String.valueOf(dayOfMonth));
                }
            } else {
                for (int dayOfMonth = maxDay + 1; dayOfMonth <= this.displayMaxDays; ++dayOfMonth) {
                    this.dayComboBox.removeItem(String.valueOf(dayOfMonth));
                }
            }
            this.displayMaxDays = maxDay;
        }
    }

    void calendarButton_actionPerformed(ActionEvent e) {
        IstiCalendarPanel.createDialog(this, this.calObj, this.borderObj.getTitle() + " Calendar", this.getMinTime(), this.getMaxTime());
        int month = this.getMonth();
        int date = this.getDayOfMonth();
        int year = this.getYear();
        this.monthComboBox.setSelectedIndex(month);
        this.dayComboBox.setSelectedItem(String.valueOf(date));
        this.yearComboBox.setYear(year);
    }

    public int getMonth() {
        return this.calObj.get(2);
    }

    public int getDayOfMonth() {
        return this.calObj.get(5);
    }

    public int getYear() {
        return this.calObj.get(1);
    }

    public Calendar getCalendar() {
        int month = this.getMonth();
        int date = this.getDayOfMonth();
        int year = this.getYear();
        this.calObj.set(year, month, date);
        this.timeTextField.updateTime();
        return this.calObj;
    }

    public void addUpdateListener(UpdateListener l) {
        this.listenerList.add(class$com$isti$util$gui$UpdateListener == null ? (class$com$isti$util$gui$UpdateListener = IstiTimePanel.class$("com.isti.util.gui.UpdateListener")) : class$com$isti$util$gui$UpdateListener, l);
    }

    public void removeUpdateListener(UpdateListener l) {
        this.listenerList.remove(class$com$isti$util$gui$UpdateListener == null ? (class$com$isti$util$gui$UpdateListener = IstiTimePanel.class$("com.isti.util.gui.UpdateListener")) : class$com$isti$util$gui$UpdateListener, l);
    }

    protected void fireUpdate(Component component, Object e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$com$isti$util$gui$UpdateListener == null ? IstiTimePanel.class$("com.isti.util.gui.UpdateListener") : class$com$isti$util$gui$UpdateListener)) continue;
            ((UpdateListener)listeners[i + 1]).processUpdate(component, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdate(Component component, Object e) {
        boolean inValidFlag;
        Object object = this.timeUpdateLockObj;
        synchronized (object) {
            if (this.isTimeUpdate()) {
                return;
            }
        }
        int year = this.yearComboBox.getYear();
        int month = this.monthComboBox.getSelectedIndex();
        int date = Integer.parseInt(this.dayComboBox.getSelectedItem().toString());
        this.calObj.set(year, month, date);
        boolean updateYearFlag = false;
        Date updateTime = null;
        do {
            inValidFlag = false;
            Date newTime = this.calObj.getTime();
            if (this.getMinTime() != null && newTime.before(this.getMinTime())) {
                if (component == this.yearComboBox || updateYearFlag) {
                    updateTime = this.getMinTime();
                } else {
                    inValidFlag = true;
                    this.calObj.set(1, ++year);
                    updateYearFlag = true;
                }
            }
            if (this.getMaxTime() == null || !newTime.after(this.getMaxTime())) continue;
            if (component == this.yearComboBox || updateYearFlag) {
                updateTime = this.getMaxTime();
                continue;
            }
            inValidFlag = true;
            this.calObj.set(1, --year);
            updateYearFlag = true;
        } while (inValidFlag);
        if (updateTime != null) {
            this.setTime(updateTime);
            return;
        }
        if (updateYearFlag) {
            this.yearComboBox.setYear(year);
        }
        this.updateDays();
        this.fireUpdate(this, e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

