/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.FilteredJTextField;
import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.MultiLineJLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class IstiPasswordPanel
extends JPanel {
    protected final JLabel usernameLabel = new JLabel("Username: ");
    protected final JTextField usernameField;
    protected final JLabel passwordLabel = new JLabel("Password: ");
    protected final JPasswordField passwordField = new JPasswordField();
    protected final MultiLineJLabel panelPromptTextObj;
    protected final Vector listenerList = new Vector();
    public static String LOGIN_DIALOG_DEFAULT_TITLE_STRING = "Login";
    public static String LOGIN_DIALOG_DEFAULT_OPTION_STRING = "OK";
    public static String LOGIN_DIALOG_CANCEL_OPTION_STRING = "Cancel";
    public static final int USERNAME_COLUMNS = 16;
    public static final String USERNAME_NOT_ALLOWED_CHARS = ", ";

    public IstiPasswordPanel() {
        this(null, new JTextField(16));
    }

    public IstiPasswordPanel(String panelPromptStr) {
        this(panelPromptStr, new JTextField(16));
    }

    public IstiPasswordPanel(int columns) {
        this(null, new JTextField(columns));
    }

    public IstiPasswordPanel(String panelPromptStr, int columns) {
        this(panelPromptStr, new JTextField(columns));
    }

    public IstiPasswordPanel(int columns, String notAllowedChars) {
        this(null, new FilteredJTextField(null, columns, notAllowedChars, false, 0, false));
    }

    public IstiPasswordPanel(String panelPromptStr, int columns, String notAllowedChars) {
        this(panelPromptStr, new FilteredJTextField(null, columns, notAllowedChars, false, 0, false));
    }

    protected IstiPasswordPanel(JTextField usernameField) {
        this(null, usernameField);
    }

    protected IstiPasswordPanel(String panelPromptStr, JTextField usernameField) {
        this.usernameField = usernameField;
        usernameField.requestFocus();
        this.panelPromptTextObj = new MultiLineJLabel(panelPromptStr, 25);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInitialFocus() {
        this.usernameField.requestFocus();
    }

    public String getPassword() {
        char[] charArr = this.passwordField.getPassword();
        String retStr = new String(charArr);
        Arrays.fill(charArr, '\u0000');
        return retStr;
    }

    public void setPassword(String passwordText) {
        ((JTextComponent)this.passwordField).setText(passwordText);
    }

    public String getUsername() {
        return this.usernameField.getText();
    }

    public void setUsername(String usernameText) {
        this.usernameField.setText(usernameText);
    }

    public JTextField getUsernameFieldObj() {
        return this.usernameField;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        GridBagConstraints constraintsObj = new GridBagConstraints();
        constraintsObj.gridy = 0;
        constraintsObj.gridx = 0;
        constraintsObj.gridheight = 1;
        constraintsObj.weighty = 0.0;
        constraintsObj.weightx = 0.0;
        String str = this.panelPromptTextObj.getText();
        if (str != null && str.length() > 0) {
            constraintsObj.gridwidth = 2;
            constraintsObj.insets = new Insets(0, 0, 15, 0);
            this.add((Component)this.panelPromptTextObj, constraintsObj);
            constraintsObj.insets = new Insets(0, 0, 0, 0);
            ++constraintsObj.gridy;
        }
        constraintsObj.gridwidth = 1;
        constraintsObj.fill = 0;
        this.add((Component)this.usernameLabel, constraintsObj);
        ++constraintsObj.gridx;
        constraintsObj.weighty = 1.0;
        constraintsObj.weightx = 1.0;
        constraintsObj.fill = 2;
        this.add((Component)this.usernameField, constraintsObj);
        --constraintsObj.gridx;
        ++constraintsObj.gridy;
        constraintsObj.weighty = 0.0;
        constraintsObj.weightx = 0.0;
        constraintsObj.fill = 0;
        this.add((Component)this.passwordLabel, constraintsObj);
        ++constraintsObj.gridx;
        constraintsObj.weighty = 1.0;
        constraintsObj.weightx = 1.0;
        constraintsObj.fill = 2;
        this.add((Component)this.passwordField, constraintsObj);
        UpdateListener updateListener = new UpdateListener();
        this.usernameField.getDocument().addDocumentListener(updateListener);
        this.passwordField.getDocument().addDocumentListener(updateListener);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.toArray();
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((ActionListener)listeners[i]).actionPerformed(event);
        }
    }

    public static IstiPasswordPanel createPasswordPanel() {
        return new IstiPasswordPanel();
    }

    public static IstiPasswordPanel createPasswordPanel(String panelPromptStr) {
        return new IstiPasswordPanel(panelPromptStr);
    }

    public static IstiPasswordPanel createRestrictedPasswordPanel() {
        return new IstiPasswordPanel(16, USERNAME_NOT_ALLOWED_CHARS);
    }

    public static IstiPasswordPanel createRestrictedPasswordPanel(String panelPromptStr) {
        return new IstiPasswordPanel(panelPromptStr, 16, USERNAME_NOT_ALLOWED_CHARS);
    }

    public static IstiDialogPopup createLoginDialog(Component parentComp) {
        return IstiPasswordPanel.createLoginDialog(parentComp, IstiPasswordPanel.createPasswordPanel(), LOGIN_DIALOG_DEFAULT_TITLE_STRING, LOGIN_DIALOG_DEFAULT_OPTION_STRING);
    }

    public static IstiDialogPopup createLoginDialog(Component parentComp, Object msgObj) {
        return IstiPasswordPanel.createLoginDialog(parentComp, msgObj, LOGIN_DIALOG_DEFAULT_TITLE_STRING, LOGIN_DIALOG_DEFAULT_OPTION_STRING);
    }

    public static IstiDialogPopup createLoginDialog(Component parentComp, Object msgObj, String titleStr) {
        return IstiPasswordPanel.createLoginDialog(parentComp, msgObj, titleStr, LOGIN_DIALOG_DEFAULT_OPTION_STRING);
    }

    public static IstiDialogPopup createLoginDialog(Component parentComp, Object msgObj, String titleStr, Object optionObj) {
        IstiDialogPopup popup = new IstiDialogPopup(parentComp, msgObj, titleStr, optionObj);
        return popup;
    }

    protected class UpdateListener
    implements DocumentListener {
        protected UpdateListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            IstiPasswordPanel.this.fireActionPerformed(new ActionEvent(this, 0, e.getType().toString()));
        }
    }
}

