/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.IstiPasswordPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class IstiPasswordDialog
extends IstiDialogPopup {
    public static String LOGIN_DIALOG_DEFAULT_TITLE_STRING = IstiPasswordPanel.LOGIN_DIALOG_DEFAULT_TITLE_STRING;
    public static String LOGIN_DIALOG_DEFAULT_OPTION_STRING = IstiPasswordPanel.LOGIN_DIALOG_DEFAULT_OPTION_STRING;
    public static String LOGIN_DIALOG_CANCEL_OPTION_STRING = IstiPasswordPanel.LOGIN_DIALOG_CANCEL_OPTION_STRING;
    private String usernameText = "";
    private String passwordText = "";
    private final IstiPasswordPanel passwordPanel;
    private final JButton okButton;
    private final JButton cancelButton;

    public IstiPasswordDialog(Component parentComp) {
        this(parentComp, LOGIN_DIALOG_DEFAULT_TITLE_STRING);
    }

    public IstiPasswordDialog(Component parentComp, String titleStr) {
        this(parentComp, titleStr, IstiPasswordPanel.createRestrictedPasswordPanel());
    }

    public IstiPasswordDialog(Component parentComp, String titleStr, String panelPromptStr) {
        this(parentComp, titleStr, IstiPasswordPanel.createRestrictedPasswordPanel(panelPromptStr));
    }

    public IstiPasswordDialog(Component parentComp, String titleStr, IstiPasswordPanel passwordPanel) {
        this(parentComp, titleStr, passwordPanel, new JButton(LOGIN_DIALOG_DEFAULT_OPTION_STRING), new JButton(LOGIN_DIALOG_CANCEL_OPTION_STRING));
    }

    protected IstiPasswordDialog(Component parentComp, String titleStr, final IstiPasswordPanel passwordPanel, JButton okButton, JButton cancelButton) {
        super(parentComp, (Object)passwordPanel, titleStr, new Object[]{okButton, cancelButton}, 0);
        this.passwordPanel = passwordPanel;
        this.okButton = okButton;
        this.cancelButton = cancelButton;
        this.setRepackNeededFlag(true);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IstiPasswordDialog.this.usernameText = passwordPanel.getUsername();
                IstiPasswordDialog.this.passwordText = passwordPanel.getPassword();
                IstiPasswordDialog.this.setOptionPaneValue(LOGIN_DIALOG_DEFAULT_OPTION_STRING);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IstiPasswordDialog.this.setOptionPaneValue(LOGIN_DIALOG_CANCEL_OPTION_STRING);
            }
        });
        this.addCloseListener(new IstiDialogPopup.CloseListener(){

            public void dialogClosed(Object evtObj) {
                if (IstiPasswordDialog.this.getValue() != LOGIN_DIALOG_DEFAULT_OPTION_STRING) {
                    passwordPanel.setPassword(IstiPasswordDialog.this.passwordText);
                    passwordPanel.setUsername(IstiPasswordDialog.this.usernameText);
                }
            }
        });
    }

    public IstiPasswordPanel getPasswordPanel() {
        return this.passwordPanel;
    }

    public String getPasswordText() {
        return this.passwordText;
    }

    public String getUsernameText() {
        return this.usernameText;
    }

    public void setPasswordText(String passwordText) {
        this.passwordText = passwordText;
        this.passwordPanel.setPassword(passwordText);
    }

    public void setUsernameText(String usernameText) {
        this.usernameText = usernameText;
        this.passwordPanel.setUsername(usernameText);
    }

    public void setUsernameAsInitalFocus() {
        this.setInitialFocusComponent(this.passwordPanel.getUsernameFieldObj());
    }
}

