/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.LogFile;
import com.isti.util.UtilFns;
import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.MultiLineJLabel;
import java.awt.Component;
import javax.swing.JLabel;

public class IstiDialogUtil {
    protected static final int DEF_MAX_JLABEL_LEN = 160;
    protected static final int DEF_USE_JLABEL_LEN = 80;
    protected static final String ERROR_STR = "Error";
    protected final Component parentComponent;
    protected final int popupLengthValue;
    protected final boolean useJLabelFlag;
    protected final int useJLabelLength;
    protected boolean sizeViaNewlinesFlag = false;
    protected Object popupMessageSyncObj = new Object();

    public IstiDialogUtil(Component parentComp, int popupLength, boolean useJLabelFlag, int useJLabelLength) {
        this.parentComponent = parentComp;
        this.useJLabelFlag = useJLabelFlag;
        this.useJLabelLength = useJLabelLength;
        this.popupLengthValue = !useJLabelFlag || popupLength > 0 ? popupLength : 160;
    }

    public IstiDialogUtil(Component parentComp, int popupLength, boolean useJLabelFlag) {
        this(parentComp, popupLength, false, 80);
    }

    public IstiDialogUtil(Component parentComp, int popupLength) {
        this(parentComp, popupLength, false, 80);
    }

    public IstiDialogUtil(Component parentComp, boolean useJLabelFlag) {
        this(parentComp, 0, useJLabelFlag, 80);
    }

    public IstiDialogUtil(Component parentComp) {
        this(parentComp, 0, false, 80);
    }

    public void setSizeViaNewlinesFlag(boolean flgVal) {
        this.sizeViaNewlinesFlag = flgVal;
    }

    public boolean getSizeViaNewlinesFlag() {
        return this.sizeViaNewlinesFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popupMessage(String msgStr, String titleStr, int messageType, boolean modalFlag, boolean waitFlag) {
        if (msgStr != null) {
            Object object = this.popupMessageSyncObj;
            synchronized (object) {
                IstiDialogPopup popupObj = new IstiDialogPopup(this.parentComponent, this.createMsgObj(msgStr), titleStr, messageType, modalFlag, -1);
                popupObj.setRepackNeededFlag(true);
                if (waitFlag) {
                    popupObj.showAndWait();
                } else {
                    popupObj.show();
                }
            }
        }
    }

    public void popupMessage(String msgStr, String titleStr, int messageType, boolean modalFlag) {
        this.popupMessage(msgStr, titleStr, messageType, modalFlag, false);
    }

    public void popupErrorMessage(LogFile logObj, String msgStr, String titleStr, boolean modalFlag, boolean normalizeFlag) {
        if (logObj != null) {
            logObj.warning(msgStr);
        }
        this.popupMessage(normalizeFlag ? UtilFns.normalizeString(msgStr) : msgStr, titleStr, 0, modalFlag);
    }

    public void popupErrorMessage(LogFile logObj, String msgStr, String titleStr, boolean modalFlag) {
        this.popupErrorMessage(logObj, msgStr, titleStr, modalFlag, false);
    }

    public void popupErrorMessage(String msgStr, String titleStr, boolean modalFlag, boolean normalizeFlag) {
        this.popupErrorMessage(null, msgStr, titleStr, modalFlag, normalizeFlag);
    }

    public void popupErrorMessage(String msgStr, String titleStr, boolean modalFlag) {
        this.popupErrorMessage(null, msgStr, titleStr, modalFlag, false);
    }

    public void popupErrorMessage(LogFile logObj, String msgStr, String titleStr) {
        this.popupErrorMessage(logObj, msgStr, titleStr, true, false);
    }

    public void popupErrorMessage(String msgStr, String titleStr) {
        this.popupErrorMessage(null, msgStr, titleStr, true, false);
    }

    public void popupErrorMessage(LogFile logObj, String msgStr, boolean modalFlag, boolean normalizeFlag) {
        this.popupErrorMessage(logObj, msgStr, ERROR_STR, modalFlag, normalizeFlag);
    }

    public void popupErrorMessage(LogFile logObj, String msgStr, boolean modalFlag) {
        this.popupErrorMessage(logObj, msgStr, ERROR_STR, modalFlag, false);
    }

    public void popupErrorMessage(String msgStr, boolean modalFlag, boolean normalizeFlag) {
        this.popupErrorMessage(null, msgStr, ERROR_STR, modalFlag, normalizeFlag);
    }

    public void popupErrorMessage(String msgStr, boolean modalFlag) {
        this.popupErrorMessage(null, msgStr, ERROR_STR, modalFlag, false);
    }

    public void popupErrorMessage(LogFile logObj, String msgStr) {
        this.popupErrorMessage(logObj, msgStr, ERROR_STR, true, false);
    }

    public void popupErrorMessage(String msgStr) {
        this.popupErrorMessage(null, msgStr, ERROR_STR, true, false);
    }

    public void popupInfoMessage(String msgStr, boolean modalFlag) {
        this.popupMessage(msgStr, "Information", 1, modalFlag);
    }

    public void popupInfoMessage(String msgStr) {
        this.popupMessage(msgStr, "Information", 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int popupOKConfirmMessage(String msgStr, String titleStr, int messageType, boolean modalFlag) {
        if (msgStr != null) {
            Object object = this.popupMessageSyncObj;
            synchronized (object) {
                IstiDialogPopup popupObj = new IstiDialogPopup(this.parentComponent, this.createMsgObj(msgStr), titleStr, messageType, modalFlag, 2);
                popupObj.setRepackNeededFlag(true);
                return popupObj.showAndReturnIndex();
            }
        }
        return -1;
    }

    public int popupOKConfirmMessage(String msgStr, String titleStr, boolean modalFlag) {
        return this.popupOKConfirmMessage(msgStr, titleStr, -1, modalFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int popupYesNoConfirmMessage(String msgStr, String titleStr, int messageType, boolean modalFlag) {
        if (msgStr != null) {
            Object object = this.popupMessageSyncObj;
            synchronized (object) {
                IstiDialogPopup popupObj = new IstiDialogPopup(this.parentComponent, this.createMsgObj(msgStr), titleStr, messageType, modalFlag, 0);
                popupObj.setRepackNeededFlag(true);
                return popupObj.showAndReturnIndex();
            }
        }
        return -1;
    }

    public int popupYesNoConfirmMessage(String msgStr, String titleStr, boolean modalFlag) {
        return this.popupYesNoConfirmMessage(msgStr, titleStr, -1, modalFlag);
    }

    public Object createMsgObj(String msgStr) {
        if (msgStr != null) {
            Object msgObj;
            if (this.useJLabelFlag || msgStr.length() <= this.useJLabelLength) {
                if (this.popupLengthValue > 0 && msgStr.length() > this.popupLengthValue) {
                    msgStr = msgStr.substring(0, this.popupLengthValue).trim() + "...";
                }
                msgObj = new JLabel(msgStr);
            } else {
                msgObj = this.sizeViaNewlinesFlag && msgStr.indexOf(10) >= 0 ? msgStr : new MultiLineJLabel(msgStr, this.popupLengthValue);
            }
            return msgObj;
        }
        return new JLabel();
    }
}

