/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.HtmlUtilFns;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.MenuElement;
import javax.swing.table.JTableHeader;

public class HintManager
implements FocusListener,
MouseListener {
    public static final int MOUSE_EVENT_TYPE = 1;
    public static final int FOCUS_EVENT_TYPE = 2;
    protected static final String hintClearText = " ";
    private boolean useToolTipTextFlag = true;
    private final Map hintMap = new WeakHashMap();
    private final Object hintComponent;
    private final Method setTextMethodObj;
    private Color additionalHintTextColor = null;
    private boolean additionalHintTextBoldFlag = false;
    static /* synthetic */ Class class$java$lang$String;

    public HintManager(Object hintComponent) throws Exception {
        this.hintComponent = hintComponent;
        this.setTextMethodObj = hintComponent.getClass().getMethod("setText", class$java$lang$String == null ? (class$java$lang$String = HintManager.class$("java.lang.String")) : class$java$lang$String);
    }

    public void addHintFor(Component comp, String hintText) {
        this.hintMap.put(comp, hintText);
    }

    public void disableHints(Component comp) {
        int i;
        comp.removeMouseListener(this);
        comp.removeFocusListener(this);
        if (comp instanceof Container) {
            Component[] components = ((Container)comp).getComponents();
            for (i = 0; i < components.length; ++i) {
                this.disableHints(components[i]);
            }
        }
        if (comp instanceof MenuElement) {
            MenuElement[] elements = ((MenuElement)((Object)comp)).getSubElements();
            for (i = 0; i > elements.length; ++i) {
                this.disableHints(elements[i].getComponent());
            }
        }
    }

    public void enableHints(Component comp, int type) {
        int i;
        String hintText = this.getHintFor(comp);
        if ((type & 1) != 0 && hintText != null) {
            comp.addMouseListener(this);
        }
        if ((type & 2) != 0 && hintText != null) {
            comp.addFocusListener(this);
        }
        if (comp instanceof Container) {
            Component[] components = ((Container)comp).getComponents();
            for (i = 0; i < components.length; ++i) {
                this.enableHints(components[i], type);
            }
        }
        if (comp instanceof MenuElement) {
            MenuElement[] elements = ((MenuElement)((Object)comp)).getSubElements();
            for (i = 0; i > elements.length; ++i) {
                this.enableHints(elements[i].getComponent(), type);
            }
        }
    }

    public boolean isUseToolTipText() {
        return this.useToolTipTextFlag;
    }

    public void setAddtionalHintTextColor(Color color, boolean boldFlag) {
        this.additionalHintTextColor = color;
        this.additionalHintTextBoldFlag = boldFlag;
    }

    public void setUseToolTipText(boolean b) {
        this.useToolTipTextFlag = b;
    }

    private String getHintFor(Component comp) {
        String hint = (String)this.hintMap.get(comp);
        if (hint == null) {
            if (comp instanceof JLabel) {
                hint = (String)this.hintMap.get(((JLabel)comp).getLabelFor());
            } else if (comp instanceof JTableHeader) {
                hint = (String)this.hintMap.get(((JTableHeader)comp).getTable());
            }
        }
        if (hint == null && this.useToolTipTextFlag && comp instanceof JComponent) {
            hint = ((JComponent)comp).getToolTipText();
            hint = this.addComponentHintText(hint, comp);
        }
        return hint;
    }

    protected String addComponentHintText(String hint, Component comp) {
        if (hint == null) {
            return hint;
        }
        String additionalHintText = null;
        if ((comp instanceof JComboBox || (comp = comp.getParent()) instanceof JComboBox) && ((JComboBox)comp).isEditable()) {
            additionalHintText = "to enter a new value press Tab to continue";
        }
        return this.getHintText(hint, additionalHintText);
    }

    protected String getFullHintText(String hint, String additionalHintText) {
        return hint + ", " + additionalHintText;
    }

    protected String getHintText(String hint, String additionalHintText) {
        if (additionalHintText != null) {
            boolean htmlFlag = false;
            if (this.additionalHintTextBoldFlag) {
                additionalHintText = HtmlUtilFns.getText(additionalHintText, "B");
                htmlFlag = true;
            }
            if (this.additionalHintTextColor != null) {
                additionalHintText = HtmlUtilFns.getFontText(additionalHintText, this.additionalHintTextColor);
                htmlFlag = true;
            }
            return this.getHintText(hint, additionalHintText, htmlFlag);
        }
        return hint;
    }

    protected String getHintText(String hint, String additionalHintText, boolean htmlFlag) {
        String s = this.getFullHintText(hint, additionalHintText);
        if (htmlFlag) {
            s = HtmlUtilFns.getHtmlText(s);
        }
        return s;
    }

    protected String getHintClearText() {
        return hintClearText;
    }

    protected void setHint(String hint) {
        if (hint == null || hint.length() == 0) {
            hint = this.getHintClearText();
        }
        try {
            this.setTextMethodObj.invoke(this.hintComponent, hint);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent e) {
        String hint;
        Component comp = (Component)e.getSource();
        while ((hint = this.getHintFor(comp)) == null && (comp = comp.getParent()) != null) {
        }
        if (hint != null) {
            this.setHint(hint);
        }
    }

    public void focusLost(FocusEvent e) {
        this.setHint(null);
    }

    public void mouseEntered(MouseEvent e) {
        String hint;
        Component comp = (Component)e.getSource();
        while ((hint = this.getHintFor(comp)) == null && (comp = comp.getParent()) != null) {
        }
        if (hint != null) {
            this.setHint(hint);
        }
    }

    public void mouseExited(MouseEvent e) {
        this.setHint(null);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

