/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.UtilFns;
import com.isti.util.gui.FilteredJTextField;

public class FloatJTextField
extends FilteredJTextField {
    public static final int DEFAULT_DIGITS = 6;
    public static final int DEFAULT_COLUMNS = 8;
    private final int columns;
    private final int digits;
    private double value;
    private String valueText;

    public FloatJTextField() {
        this(0.0);
    }

    public FloatJTextField(double value) {
        this(value, 8);
    }

    public FloatJTextField(double value, int columns) {
        this(value, columns, 6);
    }

    public FloatJTextField(double value, int columns, int digits) {
        super(null, columns, "0123456789.", true, columns);
        this.columns = columns;
        this.digits = digits;
        this.setValue(value);
    }

    public FloatJTextField(String text) {
        this(text, 8);
    }

    public FloatJTextField(String text, int columns) {
        this(text, columns, 6);
    }

    public FloatJTextField(String text, int columns, int digits) {
        super(text, columns, "0123456789.", true, columns);
        this.columns = columns;
        this.digits = digits;
        this.getValue();
    }

    public double getValue() {
        String currentText = super.getText();
        if (!currentText.equals(this.valueText)) {
            try {
                this.valueText = currentText;
                this.value = Double.parseDouble(this.valueText);
            }
            catch (NumberFormatException ex) {
                this.value = 0.0;
            }
        }
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.valueText = UtilFns.floatNumberToString(value, this.digits, this.columns, this.getMaxValueObj());
        super.setText(this.valueText);
    }
}

