/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.UnsyncFifoHashtable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class FifoHashListModel
extends AbstractListModel {
    protected final UnsyncFifoHashtable hashtableObj = new UnsyncFifoHashtable();
    protected boolean listenersEnabledFlag = true;

    public int getSize() {
        return this.hashtableObj.size();
    }

    public Object getElementAt(int indexVal) {
        return this.hashtableObj.elementAt(indexVal);
    }

    public Object put(Object key, Object value) {
        int preIdx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.put(key, value);
        this.fireItemPut(preIdx, key);
        return retObj;
    }

    public void putAll(Map mapObj) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.hashtableObj.put(e.getKey(), e.getValue());
        }
        if (this.listenersEnabledFlag) {
            this.fireContentsChanged();
        }
    }

    public Object putSort(Object key, Object value, boolean sortDirFlag) {
        return this.putSort(key, value, sortDirFlag, 0);
    }

    public Object putSort(Object key, Object value, boolean sortDirFlag, int sortType) {
        int preIdx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.putSort(key, value, sortDirFlag, sortType);
        this.fireItemPut(preIdx, key);
        return retObj;
    }

    public Object putSort(Object key, Object value, boolean sortDirFlag, Comparator compObj) {
        int preIdx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.putSort(key, value, sortDirFlag, compObj);
        this.fireItemPut(preIdx, key);
        return retObj;
    }

    public void putSortAll(Map mapObj, boolean sortDirFlag) {
        this.putSortAll(mapObj, sortDirFlag, 0);
    }

    public void putSortAll(Map mapObj, boolean sortDirFlag, int sortType) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.hashtableObj.putSort(e.getKey(), e.getValue(), sortDirFlag, sortType);
        }
        if (this.listenersEnabledFlag) {
            this.fireContentsChanged();
        }
    }

    public void putSortAll(Map mapObj, boolean sortDirFlag, Comparator compObj) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.hashtableObj.putSort(e.getKey(), e.getValue(), sortDirFlag, compObj);
        }
        if (this.listenersEnabledFlag) {
            this.fireContentsChanged();
        }
    }

    public Object putSortByValue(Object key, Object value, boolean sortDirFlag) {
        return this.putSortByValue(key, value, sortDirFlag, 0);
    }

    public Object putSortByValue(Object key, Object value, boolean sortDirFlag, int sortType) {
        int preIdx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.putSortByValue(key, value, sortDirFlag, sortType);
        this.fireItemPut(preIdx, key);
        return retObj;
    }

    public Object putSortByValue(Object key, Object value, boolean sortDirFlag, Comparator compObj) {
        int preIdx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.putSortByValue(key, value, sortDirFlag, compObj);
        this.fireItemPut(preIdx, key);
        return retObj;
    }

    public void putSortByValueAll(Map mapObj, boolean sortDirFlag) {
        this.putSortByValueAll(mapObj, sortDirFlag, 0);
    }

    public void putSortByValueAll(Map mapObj, boolean sortDirFlag, int sortType) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.hashtableObj.putSortByValue(e.getKey(), e.getValue(), sortDirFlag, sortType);
        }
        if (this.listenersEnabledFlag) {
            this.fireContentsChanged();
        }
    }

    public void putSortByValueAll(Map mapObj, boolean sortDirFlag, Comparator compObj) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.hashtableObj.putSortByValue(e.getKey(), e.getValue(), sortDirFlag, compObj);
        }
        if (this.listenersEnabledFlag) {
            this.fireContentsChanged();
        }
    }

    public Object get(Object key) {
        return this.hashtableObj.get(key);
    }

    public Object removeKey(Object key) {
        int idx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.remove(key);
        if (this.listenersEnabledFlag && idx >= 0) {
            this.fireIntervalRemoved(this, idx, idx);
        }
        return retObj;
    }

    public Object removeValue(Object obj) {
        int idx = this.hashtableObj.indexOf(obj);
        Object retObj = this.hashtableObj.removeValue(obj);
        if (this.listenersEnabledFlag && idx >= 0) {
            this.fireIntervalRemoved(this, idx, idx);
        }
        return retObj;
    }

    public void removeElementAt(int indexVal) {
        this.hashtableObj.removeElementAt(indexVal);
        if (this.listenersEnabledFlag) {
            this.fireIntervalRemoved(this, indexVal, indexVal);
        }
    }

    public void reSortList(boolean sortDirFlag, int sortType) {
        HashMap tableMapObj = new HashMap(this.hashtableObj);
        this.hashtableObj.clear();
        this.putSortByValueAll(tableMapObj, sortDirFlag, sortType);
    }

    public boolean containsKey(Object key) {
        return this.hashtableObj.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.hashtableObj.containsValue(value);
    }

    public boolean contains(Object value) {
        return this.hashtableObj.containsValue(value);
    }

    public int indexOf(Object obj) {
        return this.hashtableObj.indexOf(obj);
    }

    public int lastIndexOf(Object obj) {
        return this.hashtableObj.lastIndexOf(obj);
    }

    public int indexOfKey(Object obj) {
        return this.hashtableObj.indexOfKey(obj);
    }

    public int lastIndexOfKey(Object obj) {
        return this.hashtableObj.lastIndexOfKey(obj);
    }

    public Object keyAt(int idx) {
        return this.hashtableObj.keyAt(idx);
    }

    public void clear() {
        int sizeVal = this.hashtableObj.size();
        if (sizeVal > 0) {
            this.hashtableObj.clear();
            if (this.listenersEnabledFlag) {
                this.fireIntervalRemoved(this, 0, sizeVal - 1);
            }
        }
    }

    public Enumeration elements() {
        return this.hashtableObj.elements();
    }

    public Vector getValuesVector() {
        return this.hashtableObj.getValuesVector();
    }

    public Collection values() {
        return this.hashtableObj.values();
    }

    public void setListenersEnabled(boolean flgVal) {
        this.listenersEnabledFlag = flgVal;
    }

    public void fireContentsChanged() {
        int len = this.hashtableObj.size();
        super.fireContentsChanged(this, 0, len > 0 ? len : 0);
    }

    protected void fireItemPut(int preIdx, Object key) {
        int idx;
        if (this.listenersEnabledFlag && (idx = this.hashtableObj.indexOfKey(key)) >= 0) {
            if (preIdx >= 0) {
                if (idx == preIdx) {
                    this.fireContentsChanged(this, idx, idx);
                    return;
                }
                this.fireIntervalRemoved(this, preIdx, preIdx);
            }
            this.fireIntervalAdded(this, idx, idx);
        }
    }
}

