/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.ColorDisplayPanel;
import com.isti.util.gui.FilteredJTextField;
import com.isti.util.gui.IstiColorChooser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ChooserPreviewPanel
extends JPanel
implements ActionListener,
ChangeListener,
Serializable {
    final IstiColorChooser chooser;
    final ColorDisplayPanel displayPanel;
    final JSlider alphaSlider;
    final FilteredJTextField alphaField;
    Color color = null;
    int alpha;

    public ChooserPreviewPanel(IstiColorChooser c, Color initialColor) {
        this.chooser = c;
        Box sliderBox = Box.createHorizontalBox();
        this.displayPanel = new ColorDisplayPanel();
        AlphaNumberListener alphaNumberChange = new AlphaNumberListener();
        JLabel alphaLabel = new JLabel("Alpha");
        alphaLabel.setDisplayedMnemonic(alphaLabel.getText().charAt(0));
        this.alphaSlider = new JSlider(0, 255);
        this.alphaSlider.setMajorTickSpacing(85);
        this.alphaSlider.setMinorTickSpacing(17);
        this.alphaSlider.setPaintLabels(true);
        this.alphaSlider.setPaintTicks(true);
        this.alphaSlider.addChangeListener(alphaNumberChange);
        this.alphaField = new FilteredJTextField("Alpha", 4, "0123456789", true, 3);
        this.alphaField.setMaxValue(255);
        JPanel alphaFieldHolder = new JPanel();
        alphaFieldHolder.add(this.alphaField);
        this.alphaField.getDocument().addDocumentListener(alphaNumberChange);
        String alphaToolTipText = "Alpha value from 0 (completely transparent) to 255 (completely opaque)";
        alphaLabel.setToolTipText("Alpha value from 0 (completely transparent) to 255 (completely opaque)");
        this.alphaSlider.setToolTipText("Alpha value from 0 (completely transparent) to 255 (completely opaque)");
        this.alphaSlider.setToolTipText("Alpha value from 0 (completely transparent) to 255 (completely opaque)");
        this.setColor(initialColor);
        this.displayPanel.setPreferredSize(new Dimension(80, 40));
        sliderBox.add(this.displayPanel);
        sliderBox.add(Box.createGlue());
        sliderBox.add(Box.createHorizontalStrut(10));
        sliderBox.add(alphaLabel);
        sliderBox.add(Box.createGlue());
        sliderBox.add(this.alphaSlider);
        sliderBox.add(Box.createGlue());
        sliderBox.add(alphaFieldHolder);
        sliderBox.add(Box.createGlue());
        this.add(sliderBox);
    }

    public void actionPerformed(ActionEvent e) {
        this.color = this.chooser.getColor();
        this.setDisplayPanelColor(this.color);
    }

    public void stateChanged(ChangeEvent e) {
        if (!(e.getSource() instanceof ColorSelectionModel)) {
            return;
        }
        Color c = ((ColorSelectionModel)e.getSource()).getSelectedColor();
        this.setDisplayPanelColor(c);
    }

    private void setDisplayPanelColor(Color c) {
        this.setDisplayPanelColor(c, false);
    }

    private void setDisplayPanelColor(int a) {
        this.setDisplayPanelColor(this.displayPanel.getColor(), a);
    }

    private void setDisplayPanelColor(Color c, int a) {
        this.setDisplayPanelColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), a), true);
    }

    private void setDisplayPanelColor(Color c, boolean hasalpha) {
        if (!hasalpha) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        }
        this.displayPanel.setColor(c);
        this.displayPanel.repaint();
        this.displayPanel.setToolTipText(c.getRed() + ", " + c.getGreen() + ", " + c.getBlue());
    }

    public void setColor(Color c) {
        this.alpha = c.getAlpha();
        this.setDisplayPanelColor(c, true);
        String alphaText = new Integer(this.alpha).toString();
        this.alphaField.setText(alphaText);
    }

    public Color getColor() {
        if (this.color != null) {
            this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.alpha);
        }
        return this.color;
    }

    class AlphaNumberListener
    implements ChangeListener,
    DocumentListener,
    Serializable {
        AlphaNumberListener() {
        }

        public void stateChanged(ChangeEvent ce) {
            int newAlpha = ChooserPreviewPanel.this.alphaSlider.getValue();
            if (ChooserPreviewPanel.this.alphaField.getIntegerValue() != newAlpha) {
                String alphaText = new Integer(newAlpha).toString();
                ChooserPreviewPanel.this.alphaField.setText(alphaText);
            } else {
                ChooserPreviewPanel.this.alpha = newAlpha;
                ChooserPreviewPanel.this.setDisplayPanelColor(ChooserPreviewPanel.this.alpha);
            }
        }

        public void insertUpdate(DocumentEvent de) {
            this.updatePanel(de);
        }

        public void removeUpdate(DocumentEvent de) {
            this.updatePanel(de);
        }

        public void changedUpdate(DocumentEvent de) {
        }

        private void updatePanel(DocumentEvent de) {
            int newAlpha = ChooserPreviewPanel.this.alphaField.getIntegerValue();
            if (ChooserPreviewPanel.this.alphaSlider.getValue() != newAlpha) {
                ChooserPreviewPanel.this.alphaSlider.setValue(newAlpha);
            } else {
                ChooserPreviewPanel.this.alpha = newAlpha;
                ChooserPreviewPanel.this.setDisplayPanelColor(ChooserPreviewPanel.this.alpha);
            }
        }
    }
}

