/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gis;

import com.isti.util.LogFile;
import com.isti.util.UtilFns;
import com.isti.util.gis.LocationDistance;
import com.isti.util.gis.LocationDistanceInformation;
import com.isti.util.gis.LocationPlacesInterface;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LocationPlaces
implements LocationPlacesInterface {
    public static final String DEF_PLACEFILES_DIR_NAME = "res/places";
    protected final LogFile logObj;
    protected final LocationDistHolder[] locationDistHolderArr;
    protected final List shortMsgLocDistListObj;
    protected final List shortQuarryMsgLocDistListObj;
    protected String loadLocNoteErrMsgStr;

    public LocationPlaces() {
        this(DEF_PLACEFILES_DIR_NAME, LogFile.getGlobalLogObj(true));
    }

    public LocationPlaces(String placesDirName, LogFile logFileObj) {
        this(new File(placesDirName), logFileObj);
    }

    public LocationPlaces(File placesDirectoryObj, LogFile logFileObj) {
        block8: {
            LocationDistHolder[] arrObj;
            this.shortMsgLocDistListObj = new Vector();
            this.shortQuarryMsgLocDistListObj = new Vector();
            this.loadLocNoteErrMsgStr = null;
            this.logObj = logFileObj != null ? logFileObj : LogFile.getNullLogObj();
            Vector<LocationDistHolder> hldrVec = new Vector<LocationDistHolder>();
            Vector<LocationDistHolder> shortMsgVec = new Vector<LocationDistHolder>();
            hldrVec.add(new LocationDistHolder(new File(placesDirectoryObj, "places"), 3, 500.0));
            hldrVec.add(new LocationDistHolder(new File(placesDirectoryObj, "bigplaces"), 1, 5000.0));
            shortMsgVec.addAll(hldrVec);
            hldrVec.add(new LocationDistHolder(new File(placesDirectoryObj, "familiarplaces"), 1, 5000.0));
            LocationDistHolder holderObj = new LocationDistHolder(new File(placesDirectoryObj, "quarryplaces"), 1, 20.0, true);
            hldrVec.add(holderObj);
            this.shortQuarryMsgLocDistListObj.add(holderObj.getLocDistObj());
            int vecSize = hldrVec.size();
            int i = 0;
            while (i < vecSize) {
                holderObj = (LocationDistHolder)hldrVec.elementAt(i);
                if (holderObj.getLocDistObj() == null) {
                    hldrVec.remove(holderObj);
                    --vecSize;
                    shortMsgVec.remove(holderObj);
                    this.loadLocNoteErrMsgStr = (this.loadLocNoteErrMsgStr != null ? this.loadLocNoteErrMsgStr + ", " : "") + "\"" + holderObj.fileNameStr + "\"";
                    continue;
                }
                ++i;
            }
            if (this.loadLocNoteErrMsgStr != null) {
                this.loadLocNoteErrMsgStr = "Unable to load 'locations' file(s):  " + this.loadLocNoteErrMsgStr;
            }
            try {
                arrObj = new LocationDistHolder[vecSize];
                hldrVec.toArray(arrObj);
            }
            catch (Exception ex) {
                arrObj = new LocationDistHolder[]{};
                this.loadLocNoteErrMsgStr = "Error processing location-distance list:  " + ex;
            }
            this.locationDistHolderArr = arrObj;
            try {
                vecSize = shortMsgVec.size();
                for (i = 0; i < vecSize; ++i) {
                    this.shortMsgLocDistListObj.add(((LocationDistHolder)shortMsgVec.get(i)).getLocDistObj());
                }
            }
            catch (Exception ex) {
                if (this.loadLocNoteErrMsgStr != null) break block8;
                this.loadLocNoteErrMsgStr = "Error processing loc-dist list for 'short' msgs:  " + ex;
            }
        }
    }

    public String getErrorMessageString() {
        return this.loadLocNoteErrMsgStr;
    }

    public static String getClosestLocationName(LocationDistanceInformation[] infoArr) {
        return LocationPlaces.getClosestLocationName(infoArr, "");
    }

    public static String getClosestLocationName(LocationDistanceInformation[] infoArr, String prefixStr) {
        return LocationPlaces.getClosestLocationName(infoArr, prefixStr, "");
    }

    public static String getClosestLocationName(LocationDistanceInformation[] infoArr, String prefixStr, String defaultStr) {
        String locName = defaultStr;
        if (infoArr != null && infoArr.length > 0) {
            locName = prefixStr + infoArr[0].getName();
        }
        return locName;
    }

    public LocationDistanceInformation[] getLocationDistInfo(double latVal, double lonVal, boolean quarryFlag) {
        try {
            LocationDistanceInformation infoObj;
            LocationDistanceInformation[] infoArr;
            LocationDistHolder holderObj;
            Vector<Object> vec = new Vector();
            for (int hdrIdx = 0; hdrIdx < this.locationDistHolderArr.length; ++hdrIdx) {
                holderObj = this.locationDistHolderArr[hdrIdx];
                if (holderObj.quarryFlag || (infoArr = holderObj.getNearestPoints(latVal, lonVal)) == null) continue;
                for (int infIdx = 0; infIdx < infoArr.length; ++infIdx) {
                    infoObj = infoArr[infIdx];
                    if (LocationPlaces.locInfocontainsSameName(vec, infoObj.getName())) continue;
                    vec.add(infoObj);
                }
            }
            infoArr = new LocationDistanceInformation[vec.size()];
            vec.toArray(infoArr);
            Arrays.sort(infoArr, new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    double val2;
                    double val1 = ((LocationDistanceInformation)obj1).getDistMeters();
                    if (val1 < (val2 = ((LocationDistanceInformation)obj2).getDistMeters())) {
                        return -1;
                    }
                    if (val1 > val2) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (quarryFlag) {
                vec = new Vector<LocationDistanceInformation>(Arrays.asList(infoArr));
                for (int hdrIdx = 0; hdrIdx < this.locationDistHolderArr.length; ++hdrIdx) {
                    holderObj = this.locationDistHolderArr[hdrIdx];
                    if (!holderObj.quarryFlag || (infoArr = holderObj.getNearestPoints(latVal, lonVal)) == null) continue;
                    for (int infIdx = 0; infIdx < infoArr.length; ++infIdx) {
                        infoObj = infoArr[infIdx];
                        LocationDistanceInformation matchedInfoObj = LocationPlaces.getSameNameLocationInfo(vec, infoObj.getName());
                        if (matchedInfoObj != null) {
                            vec.remove(matchedInfoObj);
                        }
                        vec.insertElementAt(infoObj, 0);
                    }
                }
                infoArr = new LocationDistanceInformation[vec.size()];
                vec.toArray(infoArr);
            }
            return infoArr;
        }
        catch (Exception ex) {
            this.logObj.warning("Error getting location-distance information:  " + ex);
            this.logObj.warning(UtilFns.getStackTraceString(ex));
            return null;
        }
    }

    public static boolean locInfocontainsSameName(List listObj, String nameStr) {
        return LocationPlaces.getSameNameLocationInfo(listObj, nameStr) != null;
    }

    public static LocationDistanceInformation getSameNameLocationInfo(List listObj, String nameStr) {
        if (listObj != null && nameStr != null) {
            nameStr = LocationDistance.getUnaccentedName(nameStr.trim());
            Iterator iterObj = listObj.iterator();
            while (iterObj.hasNext()) {
                String str;
                Object obj = iterObj.next();
                if (!(obj instanceof LocationDistanceInformation) || (str = ((LocationDistanceInformation)obj).getName()) == null || !nameStr.equalsIgnoreCase(LocationDistance.getUnaccentedName(str.trim()))) continue;
                return (LocationDistanceInformation)obj;
            }
        }
        return null;
    }

    public LocationDistanceInformation getShortMsgLocDistInfo(double latVal, double lonVal, boolean quarryFlag) {
        try {
            LocationDistanceInformation[] infoArr = LocationDistance.selectNearestPoints(latVal, lonVal, quarryFlag ? this.shortQuarryMsgLocDistListObj : this.shortMsgLocDistListObj, 1, 0.0);
            if (infoArr != null && infoArr.length > 0) {
                return infoArr[0];
            }
        }
        catch (Exception ex) {
            this.logObj.warning("Error getting loc-dist info for 'short' msg:  " + ex);
            this.logObj.warning(UtilFns.getStackTraceString(ex));
        }
        return null;
    }

    protected static class LocationDistHolder {
        private final String fileNameStr;
        private final int numPoints;
        private final double maxDistance;
        private final boolean quarryFlag;
        private final LocationDistance locDistObj;

        public LocationDistHolder(File locFileObj, int numPoints, double maxDistKm, boolean quarryFlag) {
            LocationDistance tempDistObj;
            this.fileNameStr = locFileObj.getPath();
            this.numPoints = numPoints;
            this.maxDistance = maxDistKm * 1000.0;
            this.quarryFlag = quarryFlag;
            try {
                tempDistObj = new LocationDistance(this.fileNameStr);
            }
            catch (Exception ex) {
                tempDistObj = null;
                System.err.println("Error loading 'locations' file \"" + this.fileNameStr + "\":  " + ex);
                ex.printStackTrace();
            }
            this.locDistObj = tempDistObj != null && tempDistObj.isDataValid() ? tempDistObj : null;
        }

        public LocationDistHolder(File locFileObj, int numPoints, double maxDistKm) {
            this(locFileObj, numPoints, maxDistKm, false);
        }

        public LocationDistance getLocDistObj() {
            return this.locDistObj;
        }

        public LocationDistanceInformation[] getNearestPoints(double latVal, double lonVal) {
            return this.locDistObj.getNearestPoints(latVal, lonVal, this.numPoints, this.maxDistance);
        }
    }
}

