/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gis;

import com.isti.util.FileUtils;
import com.isti.util.MeasurementUnits;
import com.isti.util.MeasurementUnitsInformation;
import com.isti.util.UnsyncFifoHashtable;
import com.isti.util.gis.GisUtils;
import com.isti.util.gis.LocationDistanceInformation;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LocationDistance
implements MeasurementUnitsInformation {
    public static final char[] ACCENT_CHARS = "\u00b7\u00c8\u00db\u00c1\u00cc\u00d2\u0152".toCharArray();
    public static final char[] UNACCENT_CHARS = "aeocinI".toCharArray();
    public static final int ACCENT_CHARS_LEN = ACCENT_CHARS.length;
    public static final double DEGTORAD = Math.PI / 180;
    public static final double RADTODEG = 57.29577951308232;
    protected final LocationInfoBlk[] locationInfoArray;
    protected final int locationInfoArrLen;
    private MeasurementUnits measurementUnits = new MeasurementUnits();

    public LocationDistance(String locationNoteDataFileName) {
        this.locationInfoArray = LocationDistance.loadLocationFile(locationNoteDataFileName);
        this.locationInfoArrLen = this.locationInfoArray != null ? this.locationInfoArray.length : 0;
    }

    public boolean isDataValid() {
        return this.locationInfoArray != null;
    }

    public LocationDistanceInformation[] getNearestPoints(double latVal, double lonVal, int maxNumPoints, double maxDistance) {
        try {
            return LocationDistance.selectNearestPoints(latVal, lonVal, this.findNearestPointObjs(latVal, lonVal, maxNumPoints, maxDistance), maxNumPoints, maxDistance, this.getMeasurementUnits());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public LocationDistanceInformation getNearestPoint(double latVal, double lonVal, double maxDistance) {
        LocationDistanceInformation[] infoArr = this.getNearestPoints(latVal, lonVal, 1, maxDistance);
        if (infoArr != null && infoArr.length > 0) {
            return infoArr[0];
        }
        return null;
    }

    public LocationDistanceInformation getNearestPoint(double latVal, double lonVal) {
        return this.getNearestPoint(latVal, lonVal, 0.0);
    }

    public String getNearestPointString(double latVal, double lonVal, double maxDistance) {
        LocationDistanceInformation infoObj = this.getNearestPoint(latVal, lonVal, maxDistance);
        return infoObj != null ? infoObj.toString() : null;
    }

    public String getNearestPointString(double latVal, double lonVal) {
        return this.getNearestPointString(latVal, lonVal, 0.0);
    }

    public int getMeasurementUnits() {
        return this.measurementUnits.getMeasurementUnits();
    }

    public void setMeasurementUnits(int mu) {
        this.measurementUnits.setMeasurementUnits(mu);
    }

    public UnsyncFifoHashtable findNearestPointObjs(double latVal, double lonVal, int maxNumPoints, double maxDistance) {
        if (maxNumPoints <= 0) {
            maxNumPoints = 1;
        }
        UnsyncFifoHashtable retTableObj = new UnsyncFifoHashtable();
        if (this.locationInfoArray != null) {
            int tblIdx;
            UnsyncFifoHashtable tableObj = new UnsyncFifoHashtable();
            int maxTableSize = maxNumPoints >= 5 ? maxNumPoints * 2 : 10;
            double maxDistVal = 0.0;
            int numTableEntries = 0;
            for (int arrIdx = 0; arrIdx < this.locationInfoArrLen; ++arrIdx) {
                String keyStr;
                LocationInfoBlk blkObj = this.locationInfoArray[arrIdx];
                double latDiff = (double)blkObj.latVal - latVal;
                double lonDiff = (double)blkObj.lonVal - lonVal;
                double distVal = latDiff * latDiff + lonDiff * lonDiff;
                if (numTableEntries < maxTableSize) {
                    keyStr = blkObj.getKeyString();
                    if (tableObj.containsKey(keyStr)) continue;
                    tableObj.putSortByValue(keyStr, new FoundLocationInfo(blkObj, distVal), true);
                    if (distVal > maxDistVal) {
                        maxDistVal = distVal;
                    }
                    ++numTableEntries;
                    continue;
                }
                if (!(distVal < maxDistVal) || tableObj.containsKey(keyStr = blkObj.getKeyString())) continue;
                tableObj.putSortByValue(keyStr, new FoundLocationInfo(blkObj, distVal), true);
                tableObj.removeElementAt(maxTableSize);
                maxDistVal = ((FoundLocationInfo)tableObj.elementAt((int)(maxTableSize - 1))).distanceValue;
            }
            int tableObjSize = tableObj.size();
            for (tblIdx = 0; tblIdx < tableObjSize; ++tblIdx) {
                FoundLocationInfo foundInfoObj = (FoundLocationInfo)tableObj.elementAt(tblIdx);
                foundInfoObj.distanceValue = GisUtils.sphereDist(foundInfoObj.locationInfoBlkObj.latVal, foundInfoObj.locationInfoBlkObj.lonVal, latVal, lonVal);
                if (!(maxDistance <= 0.0) && !(foundInfoObj.distanceValue <= maxDistance)) continue;
                retTableObj.putSortByValue(tableObj.keyAt(tblIdx), foundInfoObj, true);
            }
            tblIdx = retTableObj.size();
            while (tblIdx > maxNumPoints) {
                retTableObj.removeElementAt(--tblIdx);
            }
        }
        return retTableObj;
    }

    public static LocationDistanceInformation[] selectNearestPoints(double latVal, double lonVal, Object foundLocationsObj, int maxNumPoints, double maxDistance) throws ClassCastException {
        return LocationDistance.selectNearestPoints(latVal, lonVal, foundLocationsObj, maxNumPoints, maxDistance, -1);
    }

    public static LocationDistanceInformation[] selectNearestPoints(double latVal, double lonVal, Object foundLocationsObj, int maxNumPoints, double maxDistance, int measurementUnits) throws ClassCastException {
        ArrayList<LocationDistanceInformation> retListObj = new ArrayList<LocationDistanceInformation>();
        if (latVal <= 90.0 && latVal >= -90.0 && lonVal <= 180.0 && lonVal >= -180.0) {
            int numPointsVal;
            UnsyncFifoHashtable foundLocsTableObj;
            if (foundLocationsObj instanceof List) {
                Object obj;
                List givenListObj = foundLocationsObj;
                int givenListSize = givenListObj.size();
                if (givenListSize > 0 && (obj = givenListObj.get(0)) instanceof LocationDistance) {
                    LocationDistance locDistObj = (LocationDistance)obj;
                    foundLocationsObj = new ArrayList();
                    int i = 0;
                    while (true) {
                        ((List)foundLocationsObj).add(locDistObj.findNearestPointObjs(latVal, lonVal, maxNumPoints, maxDistance));
                        if (++i >= givenListSize) break;
                        locDistObj = (LocationDistance)givenListObj.get(i);
                    }
                }
                foundLocsTableObj = new UnsyncFifoHashtable();
                Iterator tablesIterObj = ((List)foundLocationsObj).iterator();
                while (tablesIterObj.hasNext()) {
                    Iterator iterObj = ((UnsyncFifoHashtable)tablesIterObj.next()).entrySet().iterator();
                    while (iterObj.hasNext()) {
                        Map.Entry e = (Map.Entry)iterObj.next();
                        Object keyObj = e.getKey();
                        if (foundLocsTableObj.containsKey(keyObj)) continue;
                        foundLocsTableObj.putSortByValue(keyObj, e.getValue(), true);
                    }
                }
            } else {
                foundLocsTableObj = (UnsyncFifoHashtable)((Object)foundLocationsObj);
            }
            double latValRad = latVal * (Math.PI / 180);
            double lonValRad = lonVal * (Math.PI / 180);
            if (maxNumPoints <= 0 || (numPointsVal = maxNumPoints) > foundLocsTableObj.size()) {
                numPointsVal = foundLocsTableObj.size();
            }
            for (int idx = 0; idx < numPointsVal; ++idx) {
                double azimVal;
                FoundLocationInfo foundLocInfoObj = (FoundLocationInfo)foundLocsTableObj.elementAt(idx);
                if (maxDistance > 0.0 && foundLocInfoObj.distanceValue > maxDistance) break;
                for (azimVal = GisUtils.sphereAzim((double)foundLocInfoObj.locationInfoBlkObj.latVal * (Math.PI / 180), (double)foundLocInfoObj.locationInfoBlkObj.lonVal * (Math.PI / 180), latValRad, lonValRad) * 57.29577951308232; azimVal < 0.0; azimVal += 360.0) {
                }
                while (azimVal >= 360.0) {
                    azimVal -= 360.0;
                }
                LocationDistanceInformation ldi = new LocationDistanceInformation(foundLocInfoObj.distanceValue, azimVal, foundLocInfoObj.locationInfoBlkObj.nameStr);
                ldi.setMeasurementUnits(measurementUnits);
                retListObj.add(ldi);
            }
        }
        LocationDistanceInformation[] retArrObj = new LocationDistanceInformation[retListObj.size()];
        retListObj.toArray(retArrObj);
        return retArrObj;
    }

    public static String getUnaccentedName(String nameStr) {
        char[] charArr = nameStr.toCharArray();
        int charArrLen = charArr.length;
        boolean changedFlag = false;
        for (int chIdx = 0; chIdx < charArrLen; ++chIdx) {
            for (int acIdx = 0; acIdx < ACCENT_CHARS_LEN; ++acIdx) {
                if (charArr[chIdx] != ACCENT_CHARS[acIdx]) continue;
                charArr[chIdx] = UNACCENT_CHARS[acIdx];
                changedFlag = true;
            }
        }
        if (changedFlag) {
            return new String(charArr);
        }
        return nameStr;
    }

    public static LocationInfoBlk[] loadLocationFile(String locFileName) {
        if (locFileName == null || locFileName.length() <= 0) {
            return null;
        }
        BufferedReader rdrObj = FileUtils.fileMultiOpen(locFileName);
        if (rdrObj == null) {
            return null;
        }
        HashMap<String, LocationInfoBlk> locsTableObj = new HashMap<String, LocationInfoBlk>();
        LocationInfoBlk[] retArrObj = null;
        try {
            String lineBuff;
            while ((lineBuff = rdrObj.readLine()) != null) {
                LocationInfoBlk locInfoBlkObj;
                String keyStr;
                int len = lineBuff.length();
                if (len <= 0 || lineBuff.startsWith("#") || lineBuff.startsWith("!")) continue;
                int p = 0;
                while (Character.isWhitespace(lineBuff.charAt(p)) && ++p < len) {
                }
                if (p >= len) continue;
                int sPos = p;
                while (!Character.isWhitespace(lineBuff.charAt(p))) {
                    ++p;
                }
                float lonVal = Float.parseFloat(lineBuff.substring(sPos, p));
                while (Character.isWhitespace(lineBuff.charAt(p))) {
                    ++p;
                }
                if (lineBuff.charAt(p) == ',') {
                    while (Character.isWhitespace(lineBuff.charAt(++p))) {
                    }
                }
                sPos = p;
                while (!Character.isWhitespace(lineBuff.charAt(p))) {
                    ++p;
                }
                float latVal = Float.parseFloat(lineBuff.substring(sPos, p));
                while (Character.isWhitespace(lineBuff.charAt(p))) {
                    ++p;
                }
                if (lineBuff.charAt(p) == ',') {
                    while (Character.isWhitespace(lineBuff.charAt(++p))) {
                    }
                }
                if (locsTableObj.containsKey(keyStr = (locInfoBlkObj = new LocationInfoBlk(latVal, lonVal, lineBuff.substring(p).trim())).getKeyString())) continue;
                locsTableObj.put(keyStr, locInfoBlkObj);
            }
            retArrObj = new LocationInfoBlk[locsTableObj.size()];
            locsTableObj.values().toArray(retArrObj);
        }
        catch (Exception ex) {
            retArrObj = null;
        }
        try {
            rdrObj.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return retArrObj;
    }

    public static class FoundLocationInfo
    implements Comparable {
        public final LocationInfoBlk locationInfoBlkObj;
        public double distanceValue;

        public FoundLocationInfo(LocationInfoBlk locationInfoBlkObj, double distanceValue) {
            this.locationInfoBlkObj = locationInfoBlkObj;
            this.distanceValue = distanceValue;
        }

        public int compareTo(Object obj) {
            double objDistVal = ((FoundLocationInfo)obj).distanceValue;
            if (this.distanceValue < objDistVal) {
                return -1;
            }
            if (this.distanceValue > objDistVal) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof FoundLocationInfo && ((FoundLocationInfo)obj).distanceValue == this.distanceValue;
        }

        public int hashCode() {
            return new Double(this.distanceValue).hashCode();
        }

        public String toString() {
            return (this.locationInfoBlkObj != null ? this.locationInfoBlkObj.toString() : "<null>") + " " + MeasurementUnits.getValue(this.distanceValue, -1);
        }
    }

    public static class LocationInfoBlk {
        public final float latVal;
        public final float lonVal;
        public final String nameStr;

        public LocationInfoBlk(float latVal, float lonVal, String nameStr) {
            this.latVal = latVal;
            this.lonVal = lonVal;
            this.nameStr = nameStr;
        }

        public String toString() {
            return this.latVal + " " + this.lonVal + " " + this.nameStr;
        }

        public String getKeyString() {
            return this.latVal + " " + this.lonVal + " " + LocationDistance.getUnaccentedName(this.nameStr).toLowerCase();
        }
    }
}

