/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gis;

import com.isti.util.ModIterator;
import com.isti.util.gis.IstiRegion;
import com.isti.util.gis.IstiRegionMgrIntf;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class IstiRegionMgrImpl
implements IstiRegionMgrIntf {
    protected String regionsTextValueStr = "";
    protected IstiRegion[] globalRegionObjsArray = null;
    protected Hashtable recipientRegionObjsTable = null;
    protected List allRegionObjsList = null;

    public void setMainRegionsStr(String regionsStr) {
        this.regionsTextValueStr = regionsStr != null ? regionsStr.trim() : "";
        this.generateRegionObjects();
    }

    public String getMainRegionsStr() {
        return this.regionsTextValueStr;
    }

    public IstiRegion[] getMainRegionObjs() {
        return this.globalRegionObjsArray;
    }

    public void updateAuxRegionsEntry(Object keyObj, IstiRegion[] regionsArr) {
        if (regionsArr != null && regionsArr.length > 0) {
            if (this.recipientRegionObjsTable == null) {
                this.recipientRegionObjsTable = new Hashtable();
            }
            this.recipientRegionObjsTable.put(keyObj, regionsArr);
        } else if (this.recipientRegionObjsTable == null || this.recipientRegionObjsTable.remove(keyObj) == null) {
            return;
        }
        this.generateRegionObjects();
    }

    public int getAllRegionsCount() {
        return this.allRegionObjsList != null ? this.allRegionObjsList.size() : 0;
    }

    public Vector getAllRegionStrsList() {
        ModIterator iterObj = new ModIterator(this.allRegionObjsList);
        Vector<String> regionStrsList = new Vector<String>();
        while (iterObj.hasNext()) {
            Object obj = iterObj.next();
            if (!(obj instanceof IstiRegion)) continue;
            regionStrsList.add(((IstiRegion)obj).getRegionTextValueStr());
        }
        return regionStrsList;
    }

    public List getAllRegionNamesList() {
        ModIterator iterObj = new ModIterator(this.allRegionObjsList);
        Vector<String> regionNamesList = new Vector<String>();
        while (iterObj.hasNext()) {
            Object obj = iterObj.next();
            if (!(obj instanceof IstiRegion)) continue;
            regionNamesList.add(((IstiRegion)obj).getName());
        }
        return regionNamesList;
    }

    public String checkGenerateRegionName(String baseNameStr) {
        String checkNameStr;
        List regionNamesList;
        int regionNamesCount;
        if (baseNameStr == null) {
            baseNameStr = "";
        }
        if ((regionNamesCount = (regionNamesList = this.getAllRegionNamesList()).size()) > 0) {
            boolean matchFlag;
            int suffixVal = 1;
            block0: do {
                checkNameStr = baseNameStr + suffixVal;
                matchFlag = false;
                for (int i = 0; i < regionNamesCount; ++i) {
                    Object obj = regionNamesList.get(i);
                    if (!(obj instanceof String) || !checkNameStr.equalsIgnoreCase((String)obj)) continue;
                    matchFlag = true;
                    continue block0;
                }
            } while (matchFlag && ++suffixVal <= 999);
        } else {
            checkNameStr = baseNameStr + '1';
        }
        return checkNameStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateRegionObjects() {
        this.globalRegionObjsArray = this.regionsTextValueStr != null && this.regionsTextValueStr.length() > 0 ? IstiRegion.parseRegions(this.regionsTextValueStr) : new IstiRegion[]{};
        this.allRegionObjsList = new Vector<IstiRegion>(Arrays.asList(this.globalRegionObjsArray));
        if (this.recipientRegionObjsTable != null && this.recipientRegionObjsTable.size() > 0) {
            Hashtable hashtable = this.recipientRegionObjsTable;
            synchronized (hashtable) {
                Iterator iterObj = this.recipientRegionObjsTable.entrySet().iterator();
                while (iterObj.hasNext()) {
                    Object obj = iterObj.next().getValue();
                    if (!(obj instanceof IstiRegion[])) continue;
                    IstiRegion[] regionArr = (IstiRegion[])obj;
                    for (int i = 0; i < regionArr.length; ++i) {
                        this.allRegionObjsList.add(regionArr[i]);
                    }
                }
            }
        }
    }
}

