/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gis;

import com.isti.util.CfgPropValidator;
import com.isti.util.IstiNamedValueInterface;
import com.isti.util.PropItem;
import com.isti.util.UtilFns;
import com.isti.util.gis.GisUtils;
import com.isti.util.propertyeditor.IstiNamedValueComponentPanel;
import diva.util.java2d.Polygon2D;

public class IstiRegion {
    public static final double defaultConversionFactor = 6.213711922373339E-4;
    public static final String NAME_BEGIN_CHAR = "\"";
    public static final String NAME_END_CHAR = "\"";
    public static final String COORD_BEGIN_CHAR = "(";
    public static final String COORD_END_CHAR = ")";
    public static final String COORD_SEP_CHAR = ",";
    public static final String REGION_SEP_CHAR = ";";
    public static final String OPTION_BEGIN_CHAR = "[";
    public static final String OPTION_END_CHAR = "]";
    public static final String DEF_SPECIAL_CHARS_STR = "\"\r\n\t\\=\"(),;[]";
    protected final String regionTextValueStr;
    public static final String OPID_NAME = "name";
    public static final String OPID_MAG = null;
    public static final String OPID_MINDEPTH = "mindepth";
    public static final String OPID_MAXDEPTH = "maxdepth";
    public static final String OPID_MAXAGE = "maxage";
    public static final String OPID_VERIFIED = "verified";
    public static final String OPID_AUDIBLE = "audible";
    public static final String OPID_VISUAL = "visual";
    public static final String GLOBAL_ALARM_OPTION_GROUP = "Global";
    private static final double DEF_MAGNITUDE_VAL = 3.0;
    private static final int DEF_MAXAGE_VAL = 4;
    public static final CfgPropValidator magValidator = new CfgPropValidator(new Double(0.0), new Double(9.9));
    public static final CfgPropValidator depthValidator = new CfgPropValidator(new Double(0.0), new Double(99999.0));
    public static final CfgPropValidator ageValidator = new CfgPropValidator(new Integer(0), new Integer(999999));
    private static final IstiNamedValueInterface[] _defaultOptions = new IstiNamedValueInterface[]{new PropItem("name", (Object)"", "Name of region").setValidator(new CfgPropValidator("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 _-./'@#$%^&")), new PropItem(OPID_MAG, (Object)new Double(3.0), "Minimum magnitude for alarm").setValidator(magValidator), new PropItem("mindepth", (Object)new Double(0.0), "Minimum depth for alarm (km)").setValidator(depthValidator), new PropItem("maxdepth", (Object)new Double(0.0), "Maximum depth for alarm (km)").setValidator(depthValidator), new PropItem("maxage", (Object)new Integer(4), "Maximum event age (hours)").setValidator(ageValidator), new PropItem("verified", (Object)Boolean.FALSE, "Only verified events trigger alarm"), new PropItem("audible", (Object)Boolean.TRUE, "Enable audible alarms for region").setGroupSelObj("Global"), new PropItem("visual", (Object)Boolean.TRUE, "Enable visual alarms for region").setGroupSelObj("Global")};
    private final IstiNamedValueInterface[] options = IstiRegion.createOptions();
    private IstiNamedValueInterface nameVal = this.options[0];

    public static IstiNamedValueInterface[] getDefaultOptions() {
        return _defaultOptions;
    }

    private static IstiNamedValueInterface[] createOptions() {
        IstiNamedValueInterface[] defaultOptions = IstiRegion.getDefaultOptions();
        IstiNamedValueInterface[] options = new IstiNamedValueInterface[defaultOptions.length];
        for (int i = 0; i < defaultOptions.length; ++i) {
            options[i] = (IstiNamedValueInterface)defaultOptions[i].clone();
        }
        return options;
    }

    public static IstiNamedValueComponentPanel createOptionsComponentPanel() {
        IstiNamedValueComponentPanel optionsComponentPanel = new IstiNamedValueComponentPanel();
        optionsComponentPanel.addProperties(IstiRegion.getDefaultOptions());
        return optionsComponentPanel;
    }

    public static String circleToString(double lat, double lon, double radius) {
        return IstiRegion.coordToString(lat, lon) + IstiRegion.radiusToString(radius);
    }

    public Object clone() {
        return new IstiRegion(this.regionTextValueStr).copyOptions(this);
    }

    public boolean contains(double lat, double lon) {
        return false;
    }

    public static String coordsToString(double[] llPoints) {
        int ptsLength = llPoints.length;
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < ptsLength) {
            if (i > 0) {
                s.append(COORD_SEP_CHAR.charAt(0));
            }
            s.append(IstiRegion.coordToString(llPoints[i++], llPoints[i++]));
        }
        return s.toString();
    }

    public static String coordToString(double lat, double lon) {
        return COORD_BEGIN_CHAR + IstiRegion.floatNumberToString(lat) + " " + IstiRegion.floatNumberToString(lon) + COORD_END_CHAR;
    }

    public static String floatNumberToString(double value) {
        return UtilFns.floatNumberToString(value, 3);
    }

    public String getName() {
        return this.nameVal.stringValue();
    }

    public String getRegionTextValueStr() {
        return this.regionTextValueStr;
    }

    public IstiNamedValueInterface getOption(String name) {
        IstiNamedValueInterface option = null;
        for (int optionIndex = 0; optionIndex < this.options.length; ++optionIndex) {
            option = this.options[optionIndex];
            if (name != option.getName() && (name == null || !name.equals(option.getName()))) continue;
            return option;
        }
        return null;
    }

    public Number getOptionNumberValue(String opid) {
        Object retVal = this.getOptionValue(opid);
        if (retVal instanceof Number) {
            return (Number)retVal;
        }
        return null;
    }

    public String getOptionStringValue(String opid) {
        IstiNamedValueInterface option = this.getOption(opid);
        if (option != null) {
            return IstiRegion.removeQuoteChars(option.stringValue());
        }
        return null;
    }

    public Object getOptionValue(String opid) {
        IstiNamedValueInterface option = this.getOption(opid);
        if (option != null) {
            return option.getValue();
        }
        return null;
    }

    public static IstiRegion parse(String str, boolean allowGenericFlag) {
        try {
            return new Polygon(str);
        }
        catch (InstantiationException ex) {
            try {
                return new Circle(str);
            }
            catch (InstantiationException ex2) {
                if (allowGenericFlag) {
                    try {
                        return new IstiRegion(str);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
    }

    public static IstiRegion parse(String str) {
        return IstiRegion.parse(str, false);
    }

    public static IstiRegion[] parseRegions(String str) {
        String[] subStr = UtilFns.parseSeparatedSubstrings(str, REGION_SEP_CHAR);
        int numRegions = subStr.length;
        IstiRegion[] regions = new IstiRegion[numRegions];
        for (int i = 0; i < numRegions; ++i) {
            regions[i] = IstiRegion.parse(subStr[i]);
            if (regions[i] != null) continue;
            return new IstiRegion[0];
        }
        return regions;
    }

    public static String radiusToString(double radius) {
        return " " + IstiRegion.floatNumberToString(radius * 6.213711922373339E-4);
    }

    public static LatLonPoint stringToCoord(String str) {
        try {
            int beginIndex = str.indexOf(COORD_BEGIN_CHAR);
            int endIndex = str.indexOf(COORD_END_CHAR);
            if (beginIndex < 0 || endIndex < 0 || beginIndex >= endIndex - 1) {
                return null;
            }
            String latLonStr = str.substring(beginIndex + 1, endIndex - 1);
            int latIndex = UtilFns.indexOfWhitespace(latLonStr);
            if (latIndex <= 0 || latIndex >= latLonStr.length() - 1) {
                return null;
            }
            String latStr = latLonStr.substring(0, latIndex - 1);
            String lonStr = latLonStr.substring(latIndex + 1);
            double lat = Double.parseDouble(latStr);
            double lon = Double.parseDouble(lonStr);
            LatLonPoint pt = new LatLonPoint(lat, lon);
            return pt;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static double[] stringToCoords(String str) {
        String[] subStr = UtilFns.parseSeparatedSubstrings(str, COORD_SEP_CHAR);
        int numValues = subStr.length;
        double[] llPoints = new double[numValues * 2];
        int coordIndex = 0;
        for (int i = 0; i < numValues; ++i) {
            LatLonPoint coord = IstiRegion.stringToCoord(subStr[i]);
            if (coord == null) {
                return null;
            }
            llPoints[coordIndex++] = coord.getLat();
            llPoints[coordIndex++] = coord.getLon();
        }
        return llPoints;
    }

    public static double stringToRadius(String str) {
        int beginIndex = str.indexOf(COORD_END_CHAR);
        if (beginIndex < 0) {
            return 0.0;
        }
        int endIndex = UtilFns.indexOfWhitespace(str = str.substring(beginIndex + 1).trim());
        if (endIndex >= 0) {
            str = str.substring(0, endIndex);
        }
        try {
            return Double.parseDouble(str) / 6.213711922373339E-4;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static String extractRegionName(String regionTextStr) {
        int lastQuoteIndex;
        int firstQuoteIndex;
        return regionTextStr != null && (firstQuoteIndex = regionTextStr.indexOf("\"")) >= 0 && (lastQuoteIndex = regionTextStr.lastIndexOf("\"")) > firstQuoteIndex + 1 ? regionTextStr.substring(firstQuoteIndex + 1, lastQuoteIndex) : "";
    }

    public static String replaceRegionName(String regionTextStr, String newNameStr) {
        int lastQuoteIndex;
        int firstQuoteIndex;
        if (regionTextStr == null) {
            regionTextStr = "";
        }
        if ((firstQuoteIndex = regionTextStr.indexOf("\"")) >= 0 && (lastQuoteIndex = regionTextStr.lastIndexOf("\"")) > firstQuoteIndex) {
            regionTextStr = regionTextStr.substring(lastQuoteIndex + 1);
        }
        return "\"" + newNameStr + "\"" + ' ' + regionTextStr.trim();
    }

    public final String toString() {
        StringBuffer retVal = new StringBuffer();
        String nameStr = this.getName();
        if (nameStr != null) {
            retVal.append("\"");
            retVal.append(IstiRegion.insertQuoteChars(nameStr));
            retVal.append("\"");
            retVal.append(' ');
        }
        retVal.append(this.regionTextValueStr);
        for (int optionIndex = 1; optionIndex < this.options.length; ++optionIndex) {
            if (this.options[optionIndex].isDefaultValue()) continue;
            retVal.append(" [");
            if (this.options[optionIndex].getName() != null) {
                retVal.append(IstiRegion.insertQuoteChars(this.options[optionIndex].getName()) + '=');
            }
            retVal.append(IstiRegion.insertQuoteChars(this.options[optionIndex].stringValue()) + OPTION_END_CHAR);
        }
        return retVal.toString();
    }

    protected IstiRegion(String str) {
        this.regionTextValueStr = str.trim();
        this.parseOptions(str);
    }

    protected IstiRegion copyOptions(IstiRegion region) {
        for (int optionIndex = 0; optionIndex < this.options.length; ++optionIndex) {
            this.options[optionIndex].setValue(region.options[optionIndex].getValue());
        }
        return this;
    }

    protected final void parseOptions(String str) {
        int lastQuoteIndex;
        int firstQuoteIndex = str.indexOf("\"");
        if (firstQuoteIndex >= 0 && (lastQuoteIndex = str.lastIndexOf("\"")) > firstQuoteIndex) {
            String nameStr = UtilFns.removeQuoteChars(str.substring(firstQuoteIndex + 1, lastQuoteIndex));
            this.nameVal.setValueString(nameStr);
        }
        int optionBeginIndex = str.indexOf(OPTION_BEGIN_CHAR);
        int optionEndIndex = str.lastIndexOf(OPTION_END_CHAR);
        if (optionBeginIndex < 0 || optionEndIndex < 0) {
            return;
        }
        str = str.substring(optionBeginIndex, optionEndIndex);
        String[] subStr = UtilFns.parseSeparatedSubstrings(str, OPTION_END_CHAR);
        int numOptions = subStr.length;
        for (int i = 0; i < numOptions; ++i) {
            String optionStr = subStr[i].trim();
            if (optionStr.length() <= 0 || !optionStr.startsWith(OPTION_BEGIN_CHAR)) continue;
            optionStr = optionStr.substring(1).trim();
            this.setOptionValue(optionStr);
        }
    }

    protected boolean setOptionValue(String optionStr) {
        for (int optionIndex = 0; optionIndex < this.options.length; ++optionIndex) {
            String optionVal;
            String optionName;
            IstiNamedValueInterface namedValue = this.options[optionIndex];
            String namedValueOptionName = namedValue.getName();
            int sepCharIndex = optionStr.indexOf(61);
            if (sepCharIndex >= 0) {
                optionName = optionStr.substring(0, sepCharIndex);
                optionVal = optionStr.substring(sepCharIndex + 1);
            } else {
                optionName = null;
                optionVal = optionStr;
            }
            if (optionName != namedValueOptionName && (namedValueOptionName == null || !optionStr.startsWith(namedValueOptionName))) continue;
            return namedValue.setValueString(optionVal);
        }
        return false;
    }

    public static String insertQuoteChars(String dataStr) {
        return UtilFns.insertQuoteChars(dataStr, DEF_SPECIAL_CHARS_STR);
    }

    public static String removeQuoteChars(String dataStr) {
        return UtilFns.removeQuoteChars(dataStr);
    }

    public static class Polygon
    extends IstiRegion {
        private final double[] llPoints;
        private final LatLonPolygon poly;

        public Polygon(double[] llPoints) {
            super(IstiRegion.coordsToString(llPoints));
            this.llPoints = llPoints;
            this.poly = new LatLonPolygon(llPoints);
        }

        public Object clone() {
            return new Polygon(this).copyOptions(this);
        }

        public boolean contains(double lat, double lon) {
            return this.poly.contains(lat, lon);
        }

        public double[] getLatLonPoints() {
            return this.llPoints;
        }

        protected Polygon(Polygon poly) {
            this(poly.llPoints);
        }

        protected Polygon(String str) throws InstantiationException {
            super(str);
            this.llPoints = IstiRegion.stringToCoords(str);
            if (this.llPoints == null || this.llPoints.length < 6) {
                throw new InstantiationException("Invalid string representation: " + str);
            }
            this.poly = new LatLonPolygon(this.llPoints);
        }
    }

    public static class LatLonPolygon {
        private final Polygon2D.Double poly;
        private final boolean fixedLonFlag;

        public static double[] latLonToXY(double[] llPoints) {
            int coordsLength = llPoints.length;
            double[] xyPoints = new double[coordsLength];
            for (int i = 0; i < coordsLength; i += 2) {
                xyPoints[i + 1] = llPoints[i];
                xyPoints[i] = llPoints[i + 1];
            }
            return xyPoints;
        }

        public LatLonPolygon(double[] llPoints) {
            this.poly = new Polygon2D.Double(LatLonPolygon.latLonToXY(llPoints));
            this.poly.closePath();
            boolean fixFlgVal = false;
            int nPoints = this.poly.getVertexCount();
            if (nPoints > 2) {
                double val;
                double minVal = val = this.poly.getX(0);
                double maxVal = val;
                int i = 1;
                do {
                    double d;
                    val = this.poly.getX(i);
                    if (d < minVal) {
                        minVal = val;
                        continue;
                    }
                    if (!(val > maxVal)) continue;
                    maxVal = val;
                } while (++i < nPoints);
                if (minVal < -90.0 && maxVal > 90.0) {
                    fixFlgVal = true;
                    i = 0;
                    do {
                        double d;
                        val = this.poly.getX(i);
                        if (!(d < 0.0)) continue;
                        this.poly.setX(i, val + 360.0);
                    } while (++i < nPoints);
                }
            }
            this.fixedLonFlag = fixFlgVal;
        }

        public boolean contains(double lat, double lon) {
            if (this.fixedLonFlag && lon < 0.0) {
                return this.poly.contains(lon + 360.0, lat);
            }
            return this.poly.contains(lon, lat);
        }
    }

    public static class LatLonPoint {
        private final double lat;
        private final double lon;

        public LatLonPoint(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
        }

        public LatLonPoint(String s) {
            LatLonPoint pt = IstiRegion.stringToCoord(s);
            if (pt != null) {
                this.lat = pt.lat;
                this.lon = pt.lon;
            } else {
                this.lat = 0.0;
                this.lon = 0.0;
            }
        }

        public double getLat() {
            return this.lat;
        }

        public double getLon() {
            return this.lon;
        }

        public String toString() {
            return IstiRegion.coordToString(this.lat, this.lon);
        }
    }

    public static class Circle
    extends IstiRegion {
        protected final LatLonPoint midPt;
        protected final double radius;

        public Circle(double lat, double lon, double radius) {
            super(IstiRegion.circleToString(lat, lon, radius));
            this.midPt = new LatLonPoint(lat, lon);
            this.radius = radius;
        }

        public Object clone() {
            return new Circle(this).copyOptions(this);
        }

        public boolean contains(double lat, double lon) {
            return GisUtils.sphereDist(this.midPt.getLat(), this.midPt.getLon(), lat, lon) <= this.radius;
        }

        public double getLat() {
            return this.midPt.getLat();
        }

        public double getLon() {
            return this.midPt.getLon();
        }

        public double getRadius() {
            return this.radius;
        }

        protected Circle(Circle circle) {
            this(circle.midPt.getLat(), circle.midPt.getLon(), circle.radius);
        }

        protected Circle(String str) throws InstantiationException {
            super(str);
            this.midPt = IstiRegion.stringToCoord(str);
            this.radius = IstiRegion.stringToRadius(str);
            if (this.midPt == null || this.radius <= 0.0) {
                throw new InstantiationException("Invalid string representation: " + str);
            }
        }
    }
}

