/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.database;

import com.isti.util.BaseValueTableModel;
import com.isti.util.ValueTableModel;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class SQLValuesTable
extends BaseValueTableModel
implements ValueTableModel {
    private int columnMapKeyIndex = -1;
    private String columnMapKeyName = null;

    public int readAll(ResultSet rs) throws SQLException {
        int count = 0;
        this.clearErrorMessageString();
        List valueList = this.createList();
        if (!this.columnsExist()) {
            this.createLists();
            if (!this.setColumnNames(rs.getMetaData(), valueList)) {
                return 0;
            }
        }
        int numColumns = this.getColumnCount();
        while (rs.next()) {
            this.readRow(rs, valueList, numColumns);
            ++count;
        }
        if (this.getErrorMessageFlag()) {
            return 0;
        }
        return count;
    }

    public void readRow(ResultSet rs) throws SQLException {
        this.readRow(rs, this.createList(), this.getColumnCount());
    }

    protected void readRow(ResultSet rs, List valueList, int numColumns) throws SQLException {
        valueList.clear();
        for (int columnIndex = 0; columnIndex < numColumns; ++columnIndex) {
            Object valueObj = this.getValue(rs, columnIndex);
            valueList.add(valueObj);
        }
        this.addRow(valueList);
    }

    protected Object getColumnMapKey(List columnList) {
        if (this.columnMapKeyIndex < 0 && this.columnMapKeyName != null) {
            this.columnMapKeyIndex = this.getColumnIndex(this.columnMapKeyName);
        }
        if (this.columnMapKeyIndex >= 0) {
            Object columnMapKey = columnList.get(this.columnMapKeyIndex);
            if (columnMapKey == null) {
                return null;
            }
            String columnMapKeyText = columnMapKey.toString();
            if (columnMapKeyText.length() == 0) {
                return null;
            }
            return columnMapKeyText;
        }
        return super.getColumnMapKey(columnList);
    }

    protected Object getValue(ResultSet rs, int columnIndex) throws SQLException {
        int dbColumnIndex = columnIndex + 1;
        Object valueObj = rs.getObject(dbColumnIndex);
        return valueObj;
    }

    public void reset(ResultSet rs) throws SQLException {
        if (!rs.isBeforeFirst()) {
            rs.beforeFirst();
        }
    }

    public boolean setColumnNames(ResultSetMetaData rsmd) throws SQLException {
        return this.setColumnNames(rsmd, this.createList());
    }

    public boolean setColumnNames(ResultSetMetaData rsmd, List valueList) throws SQLException {
        int numColumns = rsmd.getColumnCount();
        for (int columnIndex = 0; columnIndex < numColumns; ++columnIndex) {
            int dbColumnIndex = columnIndex + 1;
            String columnName = rsmd.getColumnName(dbColumnIndex);
            valueList.add(columnName);
            boolean readOnlyFlag = false;
            if (rsmd.isAutoIncrement(dbColumnIndex)) {
                readOnlyFlag = true;
                if (this.columnMapKeyIndex < 0 && this.columnMapKeyName == null) {
                    this.setIdColumn(columnIndex);
                }
            } else if (rsmd.isReadOnly(dbColumnIndex)) {
                readOnlyFlag = true;
            }
            if (!readOnlyFlag) continue;
            this.addReadOnlyColumn(columnName);
        }
        return this.setColumnNames(valueList);
    }

    public void setIdColumn(int columnIndex) {
        this.columnMapKeyIndex = columnIndex;
    }

    public void setIdColumn(String columnName) {
        this.columnMapKeyIndex = -1;
        this.columnMapKeyName = columnName;
        this.addReadOnlyColumn(columnName);
    }

    public void writeAll(ResultSet rs) throws SQLException {
        int numColumns = this.getColumnCount();
        boolean insertRowFlag = false;
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            if (!insertRowFlag && !rs.next()) {
                insertRowFlag = true;
                rs.moveToInsertRow();
            }
            this.writeRow(rs, numColumns, rowIndex, insertRowFlag);
        }
    }

    public void writeRow(ResultSet rs, boolean insertRowFlag) throws SQLException {
        this.writeRow(rs, this.getColumnCount(), rs.getRow(), insertRowFlag);
    }

    protected void writeRow(ResultSet rs, int numColumns, int rowIndex, boolean insertRowFlag) throws SQLException {
        for (int columnIndex = 0; columnIndex < numColumns; ++columnIndex) {
            Object valueObj = this.getValueAt(rowIndex, columnIndex);
            this.updateValue(rs, valueObj, columnIndex);
        }
        this.updateRow(rs, insertRowFlag);
    }

    protected void updateRow(ResultSet rs, boolean insertRowFlag) throws SQLException {
        if (insertRowFlag) {
            rs.insertRow();
        } else {
            rs.updateRow();
        }
    }

    protected void updateValue(ResultSet rs, Object valueObj, int columnIndex) throws SQLException {
        int dbColumnIndex = columnIndex + 1;
        if (this.isNull(valueObj)) {
            rs.updateNull(dbColumnIndex);
        } else {
            rs.updateObject(dbColumnIndex, valueObj);
        }
    }

    protected void updateValue(ResultSet rs, Object valueObj, String columnName) throws SQLException {
        if (this.isNull(valueObj)) {
            rs.updateNull(columnName);
        } else {
            rs.updateObject(columnName, valueObj);
        }
    }
}

