/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.database;

import com.isti.util.UtilFns;
import com.isti.util.database.ConnectionJDBC;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class QueryJDBC {
    private final String sql;
    private final ResultSet dbResultSet;
    private final ResultSetMetaData dbResultSetMetaData;
    private final int columnCount;
    private final String[] columnNames;
    private final Vector columnObjectsList;

    private static String[] getColumnNames(String sql) {
        String selectStr;
        String[] columnNames = null;
        String sqlUpper = sql.toUpperCase();
        int selectIndex = sqlUpper.indexOf("SELECT DISTINCT ");
        int fromIndex = sqlUpper.indexOf(" FROM ");
        if (selectIndex >= 0 && fromIndex >= 0 && (selectStr = sql.substring(selectIndex + "SELECT DISTINCT ".length(), fromIndex)).length() > 0 && !selectStr.equals("*")) {
            Vector v = UtilFns.listStringToVector(selectStr, ',', true);
            int columnCount = v.size();
            columnNames = v.toArray(new String[columnCount]);
        }
        return columnNames;
    }

    private static String[] getColumnNames(ResultSetMetaData dbResultSetMetaData) throws SQLException {
        int columnCount = dbResultSetMetaData.getColumnCount();
        String[] columnNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnNames[i] = dbResultSetMetaData.getColumnName(i + 1);
        }
        return columnNames;
    }

    private static boolean isValidColumnNames(String[] resultColumnNames, String[] columnNames) {
        if (columnNames == null) {
            return false;
        }
        if (columnNames.length != resultColumnNames.length) {
            return false;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i].indexOf(resultColumnNames[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    private static String[] getColumnNames(String sql, ResultSetMetaData dbResultSetMetaData) throws SQLException {
        String[] columnNames;
        String[] resultColumnNames = QueryJDBC.getColumnNames(dbResultSetMetaData);
        if (!QueryJDBC.isValidColumnNames(resultColumnNames, columnNames = QueryJDBC.getColumnNames(sql))) {
            columnNames = resultColumnNames;
        }
        return columnNames;
    }

    public QueryJDBC(ConnectionJDBC dbConn, String sql) throws SQLException {
        this.sql = sql;
        this.dbResultSet = dbConn.getStatement().executeQuery(sql);
        this.dbResultSetMetaData = this.dbResultSet.getMetaData();
        this.columnNames = QueryJDBC.getColumnNames(sql, this.dbResultSetMetaData);
        this.columnCount = this.columnNames.length;
        this.columnObjectsList = new Vector();
        while (this.dbResultSet.next()) {
            Thread.currentThread();
            Thread.yield();
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Hashtable columnObjects = new Hashtable();
            for (int i = 0; i < this.columnCount; ++i) {
                String columnName = this.columnNames[i];
                Object columnValue = this.dbResultSet.getObject(i + 1);
                QueryJDBC.addColumn(columnObjects, columnName, columnValue);
            }
            this.columnObjectsList.add(columnObjects);
        }
    }

    protected static boolean addColumn(Map columnObjects, String columnName, Object columnValue) {
        try {
            columnObjects.put(columnName, columnValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getResultSetMetaDataInformation() throws SQLException {
        String info = null;
        if (this.dbResultSetMetaData != null) {
            info = "(\n";
            for (int column = 1; column <= this.columnCount; ++column) {
                info = info + " " + this.dbResultSetMetaData.getColumnName(column);
                info = info + " " + this.dbResultSetMetaData.getColumnTypeName(column);
                int precision = this.dbResultSetMetaData.getPrecision(column);
                if (precision > 0) {
                    info = info + "(" + precision + ")";
                }
                if (this.dbResultSetMetaData.isNullable(column) == 0) {
                    info = info + " not null";
                }
                info = column < this.columnCount ? info + ",\n" : info + "\n)";
            }
        }
        return info;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String getColumnName(int columnIndex) {
        String columnName = null;
        if (this.columnNames != null) {
            columnName = this.columnNames[columnIndex];
        }
        return columnName;
    }

    public List getColumnObjects() {
        return this.columnObjectsList;
    }

    public Map getMap(int index) {
        Map map = null;
        if (this.columnObjectsList != null) {
            map = (Map)this.columnObjectsList.get(index);
        }
        return map;
    }

    protected String getResultInformation(Map map) {
        String text = "";
        text = text + map.get(this.getColumnName(0)).toString();
        for (int i = 1; i < this.getColumnCount(); ++i) {
            text = text + " " + map.get(this.getColumnName(i)).toString();
        }
        text = text + "\n";
        return text;
    }

    public String getResultInformation() {
        String text = "";
        if (this.columnObjectsList != null && this.getColumnCount() > 0) {
            Iterator it = ((AbstractList)this.columnObjectsList).iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                text = text + this.getResultInformation(map);
            }
        }
        return text;
    }

    public int getSize() {
        int size = 0;
        if (this.columnObjectsList != null) {
            size = this.columnObjectsList.size();
        }
        return size;
    }

    public String getSql() {
        return this.sql;
    }

    public String getString(int index) {
        String info = null;
        Map map = this.getMap(index);
        if (map != null) {
            info = this.getResultInformation(map);
        }
        return info;
    }
}

