/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.database;

import com.isti.util.gui.FilteredJTextField;
import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.MultiLineJLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class IstiConnectionInfoPanel
extends JPanel {
    protected final JLabel hostnameLabel = new JLabel("Hostname: ");
    protected final JTextField hostnameField;
    protected final JLabel portLabel = new JLabel("Port: ");
    protected final JTextField portField;
    protected final JLabel databaseLabel = new JLabel("Database: ");
    protected final JTextField databaseField;
    protected final JLabel usernameLabel = new JLabel("Username: ");
    protected final JTextField usernameField;
    protected final JLabel passwordLabel = new JLabel("Password: ");
    protected final JPasswordField passwordField = new JPasswordField();
    protected final MultiLineJLabel panelPromptTextObj;
    protected final Vector listenerList = new Vector();
    public static String LOGIN_DIALOG_DEFAULT_TITLE_STRING = "Login";
    public static String LOGIN_DIALOG_DEFAULT_OPTION_STRING = "OK";
    public static String LOGIN_DIALOG_CANCEL_OPTION_STRING = "Cancel";
    public static final int USERNAME_COLUMNS = 16;

    public IstiConnectionInfoPanel() {
        this(null, new JTextField(16));
    }

    public IstiConnectionInfoPanel(String panelPromptStr) {
        this(panelPromptStr, new JTextField(16));
    }

    public IstiConnectionInfoPanel(int columns) {
        this(null, new JTextField(columns));
    }

    public IstiConnectionInfoPanel(String panelPromptStr, int columns) {
        this(panelPromptStr, new JTextField(columns));
    }

    public IstiConnectionInfoPanel(int columns, String notAllowedChars) {
        this(null, new FilteredJTextField(null, columns, notAllowedChars, false, 0, false));
    }

    public IstiConnectionInfoPanel(String panelPromptStr, int columns, String notAllowedChars) {
        this(panelPromptStr, new FilteredJTextField(null, columns, notAllowedChars, false, 0, false));
    }

    protected IstiConnectionInfoPanel(JTextField usernameField) {
        this(null, usernameField);
    }

    protected IstiConnectionInfoPanel(String panelPromptStr, JTextField usernameField) {
        this.hostnameField = new JTextField();
        this.hostnameLabel.setLabelFor(this.hostnameField);
        this.portField = new JTextField();
        this.portField.setToolTipText("The port or empty for the default port.");
        this.portLabel.setLabelFor(this.portField);
        this.databaseField = new JTextField();
        this.databaseLabel.setLabelFor(this.databaseField);
        this.usernameField = usernameField;
        this.usernameLabel.setLabelFor(usernameField);
        this.panelPromptTextObj = new MultiLineJLabel(panelPromptStr, 25);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInitialFocus() {
        this.usernameField.requestFocus();
    }

    public String getPassword() {
        char[] charArr = this.passwordField.getPassword();
        String retStr = new String(charArr);
        Arrays.fill(charArr, '\u0000');
        return retStr;
    }

    public void setPassword(String passwordText) {
        ((JTextComponent)this.passwordField).setText(passwordText);
    }

    public String getUsername() {
        return this.usernameField.getText();
    }

    public void setUsername(String usernameText) {
        this.usernameField.setText(usernameText);
    }

    public String getHostname() {
        return this.hostnameField.getText();
    }

    public void setHostname(String hostname) {
        this.hostnameField.setText(hostname);
    }

    public void setHostnameVisible(boolean b) {
        this.hostnameLabel.setVisible(b);
        this.hostnameField.setVisible(b);
    }

    public String getPort() {
        return this.portField.getText();
    }

    public void setPort(String port) {
        this.portField.setText(port);
    }

    public void setPortVisible(boolean b) {
        this.portLabel.setVisible(b);
        this.portField.setVisible(b);
    }

    public String getDatabase() {
        return this.databaseField.getText();
    }

    public void setDatabase(String database) {
        this.databaseField.setText(database);
    }

    public void setDatabaseVisible(boolean b) {
        this.databaseLabel.setVisible(b);
        this.databaseField.setVisible(b);
    }

    public JTextField getUsernameFieldObj() {
        return this.usernameField;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        GridBagConstraints constraintsObj = new GridBagConstraints();
        constraintsObj.gridy = 0;
        constraintsObj.gridx = 0;
        constraintsObj.gridheight = 1;
        constraintsObj.weighty = 0.0;
        constraintsObj.weightx = 0.0;
        String str = this.panelPromptTextObj.getText();
        if (str != null && str.length() > 0) {
            constraintsObj.gridwidth = 2;
            constraintsObj.insets = new Insets(0, 0, 15, 0);
            this.add((Component)this.panelPromptTextObj, constraintsObj);
            constraintsObj.insets = new Insets(0, 0, 0, 0);
            ++constraintsObj.gridy;
        }
        constraintsObj.gridwidth = 1;
        constraintsObj.fill = 0;
        this.add((Component)this.hostnameLabel, constraintsObj);
        ++constraintsObj.gridx;
        constraintsObj.weighty = 1.0;
        constraintsObj.weightx = 1.0;
        constraintsObj.fill = 2;
        this.add((Component)this.hostnameField, constraintsObj);
        --constraintsObj.gridx;
        ++constraintsObj.gridy;
        constraintsObj.gridwidth = 1;
        constraintsObj.fill = 0;
        this.add((Component)this.portLabel, constraintsObj);
        ++constraintsObj.gridx;
        constraintsObj.weighty = 1.0;
        constraintsObj.weightx = 1.0;
        constraintsObj.fill = 2;
        this.add((Component)this.portField, constraintsObj);
        --constraintsObj.gridx;
        ++constraintsObj.gridy;
        constraintsObj.gridwidth = 1;
        constraintsObj.fill = 0;
        this.add((Component)this.databaseLabel, constraintsObj);
        ++constraintsObj.gridx;
        constraintsObj.weighty = 1.0;
        constraintsObj.weightx = 1.0;
        constraintsObj.fill = 2;
        this.add((Component)this.databaseField, constraintsObj);
        --constraintsObj.gridx;
        ++constraintsObj.gridy;
        constraintsObj.gridwidth = 1;
        constraintsObj.fill = 0;
        this.add((Component)this.usernameLabel, constraintsObj);
        ++constraintsObj.gridx;
        constraintsObj.weighty = 1.0;
        constraintsObj.weightx = 1.0;
        constraintsObj.fill = 2;
        this.add((Component)this.usernameField, constraintsObj);
        --constraintsObj.gridx;
        ++constraintsObj.gridy;
        constraintsObj.weighty = 0.0;
        constraintsObj.weightx = 0.0;
        constraintsObj.fill = 0;
        this.add((Component)this.passwordLabel, constraintsObj);
        ++constraintsObj.gridx;
        constraintsObj.weighty = 1.0;
        constraintsObj.weightx = 1.0;
        constraintsObj.fill = 2;
        this.add((Component)this.passwordField, constraintsObj);
        UpdateListener updateListener = new UpdateListener();
        this.usernameField.getDocument().addDocumentListener(updateListener);
        this.passwordField.getDocument().addDocumentListener(updateListener);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.toArray();
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((ActionListener)listeners[i]).actionPerformed(event);
        }
    }

    public static IstiDialogPopup createLoginDialog(Component parentComp) {
        return IstiConnectionInfoPanel.createLoginDialog(parentComp, new IstiConnectionInfoPanel(), LOGIN_DIALOG_DEFAULT_TITLE_STRING, LOGIN_DIALOG_DEFAULT_OPTION_STRING);
    }

    public static IstiDialogPopup createLoginDialog(Component parentComp, Object msgObj) {
        return IstiConnectionInfoPanel.createLoginDialog(parentComp, msgObj, LOGIN_DIALOG_DEFAULT_TITLE_STRING, LOGIN_DIALOG_DEFAULT_OPTION_STRING);
    }

    public static IstiDialogPopup createLoginDialog(Component parentComp, Object msgObj, String titleStr) {
        return IstiConnectionInfoPanel.createLoginDialog(parentComp, msgObj, titleStr, LOGIN_DIALOG_DEFAULT_OPTION_STRING);
    }

    public static IstiDialogPopup createLoginDialog(Component parentComp, Object msgObj, String titleStr, Object optionObj) {
        IstiDialogPopup popup = new IstiDialogPopup(parentComp, msgObj, titleStr, optionObj);
        return popup;
    }

    protected class UpdateListener
    implements DocumentListener {
        protected UpdateListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            IstiConnectionInfoPanel.this.fireActionPerformed(new ActionEvent(this, 0, e.getType().toString()));
        }
    }
}

