/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.database;

import com.isti.util.Math10;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;

public class DatabaseUtil {
    public static final String EMPTY_TEXT = "";
    public static final String SELECT_DISTINCT_TEXT = "SELECT DISTINCT ";
    public static final String SELECT_ALL_TEXT = "SELECT * ";
    public static final String FROM_TEXT = " FROM ";
    public static final String WHERE_TEXT_BEGIN = " WHERE (";
    public static final String WHERE_TEXT_END = ")";
    public static final String ORDER_BY_TEXT = " ORDER BY ";
    public static final String ASCII_SINGLE_PRECISION = "a0";
    public static final String ASCII_DOUBLE_PRECISION = "b0";
    public static final String ASCII_INTEGER = "c0";
    public static final String ASCII_SINGLE_PRECISION_ALT = "a#";
    public static final String ASCII_DOUBLE_PRECISION_ALT = "b#";
    public static final String ASCII_INTEGER_ALT = "c#";
    public static final String SUN_IEEE_SINGLE_PRECISION_REAL = "t4";
    public static final String SUN_IEEE_DOUBLE_PRECISION_REAL = "t8";
    public static final String SUN_IEEE_INTEGER = "s4";
    public static final String SUN_IEEE_SHORT_INTEGER = "s2";
    public static final String VAX_IEEE_SINGLE_PRECISION_REAL = "f4";
    public static final String VAX_IEEE_DOUBLE_PRECISION_REAL = "f8";
    public static final String VAX_IEEE_INTEGER = "i4";
    public static final String VAX_IEEE_SHORT_INTEGER = "i2";
    public static final String NORESS_GAIN_RANGED = "g2";
    public static final String PROPERTY_HOST_NAME = "HOST_NAME";
    public static final String PROPERTY_PORT = "PORT";
    public static final String PROPERTY_SID = "SID";
    public static final String PROPERTY_USER_NAME = "USER_NAME";
    public static final String PROPERTY_PASS_WORD = "PASS_WORD";

    protected DatabaseUtil() {
    }

    public static double invertValue(double d) {
        return d > 0.0 ? 1.0 / d : 0.0;
    }

    public static double convertToFrequency(double val, boolean periodFlag) {
        if (!periodFlag) {
            val = DatabaseUtil.invertValue(val);
        }
        return val;
    }

    public static double convertToPeriod(double val, boolean periodFlag) {
        if (periodFlag) {
            val = DatabaseUtil.invertValue(val);
        }
        return val;
    }

    public static double convertToVel(double val, double p) {
        return val + 20.0 * Math10.log10(p / (Math.PI * 2));
    }

    public static double convertToVel(double val, double p, boolean velocityFlag) {
        if (velocityFlag) {
            val = DatabaseUtil.convertToVel(val, p);
        }
        return val;
    }

    public static double getTimeInSeconds(Calendar cal) {
        return (double)cal.getTime().getTime() / 1000.0;
    }

    public static Object getObject(Map map, String columnName) {
        int prefix;
        Object val = map.get(columnName);
        if (val == null && (prefix = columnName.indexOf(".")) >= 0) {
            columnName = columnName.substring(prefix + 1);
            val = map.get(columnName);
        }
        if (val == null) {
            throw new NullPointerException();
        }
        return val;
    }

    public static String getString(Map map, String columnName) {
        Object val = DatabaseUtil.getObject(map, columnName);
        return val.toString();
    }

    public static byte getByte(Map map, String columnName) {
        Object val = DatabaseUtil.getObject(map, columnName);
        byte retVal = val instanceof Number ? ((Number)val).byteValue() : new Byte(val.toString()).byteValue();
        return retVal;
    }

    public static double getDouble(Map map, String columnName) throws NumberFormatException {
        Object val = DatabaseUtil.getObject(map, columnName);
        double retVal = val instanceof Number ? ((Number)val).doubleValue() : new Double(val.toString()).doubleValue();
        return retVal;
    }

    public static float getFloat(Map map, String columnName) {
        Object val = DatabaseUtil.getObject(map, columnName);
        float retVal = val instanceof Number ? ((Number)val).floatValue() : new Float(val.toString()).floatValue();
        return retVal;
    }

    public static int getInt(Map map, String columnName) {
        Object val = DatabaseUtil.getObject(map, columnName);
        int retVal = val instanceof Number ? ((Number)val).intValue() : new Integer(val.toString()).intValue();
        return retVal;
    }

    public static long getLong(Map map, String columnName) {
        Object val = DatabaseUtil.getObject(map, columnName);
        long retVal = val instanceof Number ? ((Number)val).longValue() : new Long(val.toString()).longValue();
        return retVal;
    }

    public static short getShort(Map map, String columnName) {
        Object val = DatabaseUtil.getObject(map, columnName);
        short retVal = val instanceof Number ? ((Number)val).shortValue() : new Short(val.toString()).shortValue();
        return retVal;
    }

    public static final void setHostName(Properties info, String hostName) {
        info.setProperty(PROPERTY_HOST_NAME, hostName);
    }

    public static final void setPort(Properties info, String port) {
        info.setProperty(PROPERTY_PORT, port);
    }

    public static final void setSid(Properties info, String sid) {
        info.setProperty(PROPERTY_SID, sid);
    }

    public static final void setUserName(Properties info, String userName) {
        info.setProperty(PROPERTY_USER_NAME, userName);
    }

    public static final void setPassWord(Properties info, String passWord) {
        info.setProperty(PROPERTY_PASS_WORD, passWord);
    }

    public static final String getHostName(Properties info) throws InstantiationException {
        String hostName = info.getProperty(PROPERTY_HOST_NAME);
        if (hostName == null || hostName.length() <= 0) {
            throw new InstantiationException("Invalid host name: " + hostName);
        }
        return hostName;
    }

    public static final int getPort(Properties info) throws InstantiationException {
        Integer portNumber;
        String port = info.getProperty(PROPERTY_PORT);
        try {
            portNumber = new Integer(port);
        }
        catch (Exception ex) {
            portNumber = null;
        }
        if (port == null || port.length() <= 0 || portNumber == null) {
            throw new InstantiationException("Invalid port: " + port);
        }
        return portNumber;
    }

    public static final String getSid(Properties info) throws InstantiationException {
        String sid = info.getProperty(PROPERTY_SID);
        if (sid == null || sid.length() <= 0) {
            throw new InstantiationException("Invalid SID: " + sid);
        }
        return sid;
    }

    public static final String getUserName(Properties info) throws InstantiationException {
        String userName = info.getProperty(PROPERTY_USER_NAME);
        if (userName == null || userName.length() <= 0) {
            throw new InstantiationException("Invalid user name: " + userName);
        }
        return userName;
    }

    public static final String getPassWord(Properties info) throws InstantiationException {
        String defaultPassWord;
        try {
            defaultPassWord = DatabaseUtil.getUserName(info);
        }
        catch (InstantiationException instEx) {
            defaultPassWord = null;
        }
        return DatabaseUtil.getPassWord(info, defaultPassWord);
    }

    public static final String getPassWord(Properties info, String defaultPassWord) throws InstantiationException {
        String passWord = info.getProperty(PROPERTY_PASS_WORD);
        if (passWord == null || passWord.length() <= 0) {
            if (defaultPassWord == null || defaultPassWord.length() <= 0) {
                throw new InstantiationException("Invalid pass word: " + passWord);
            }
            passWord = defaultPassWord;
        }
        return passWord;
    }

    public static String getColumnPrefix(String tablePrefix) {
        String text = EMPTY_TEXT;
        if (tablePrefix.length() > 0) {
            text = tablePrefix + ".";
        }
        return text;
    }

    private static String addWhereClause(String text, String newText) {
        if (newText != null) {
            if (text != null && text.length() > 0) {
                text = text + " and ";
            }
            text = text + newText;
        }
        return text;
    }

    public static String getWhereClause(String text, String columnName, String columnText) {
        return DatabaseUtil.getWhereClause(text, columnName, columnText, true);
    }

    public static String getWhereClause(String text, String columnName, String columnText, boolean wildCardFlag) {
        String newText = null;
        if ((columnText = columnText.trim()).length() > 0) {
            newText = "(" + columnName + " ";
            newText = wildCardFlag && (columnText.indexOf("%") >= 0 || columnText.indexOf("_") >= 0) ? newText + "like" : newText + "=";
            newText = newText + " '" + columnText + "')";
        }
        return DatabaseUtil.addWhereClause(text, newText);
    }

    public static String getWhereClause(String text, String columnName, int[] columnValues) {
        String newText = null;
        for (int i = 0; i < columnValues.length; ++i) {
            int columnValue = columnValues[i];
            newText = newText == null ? columnName + " in (" : newText + ",";
            newText = newText + columnValue;
        }
        if (newText != null) {
            newText = newText + WHERE_TEXT_END;
        }
        return DatabaseUtil.addWhereClause(text, newText);
    }

    public static String getWhereClause(String text, String columnName, int columnBeginValue, int columnEndValue) {
        String newText = null;
        newText = columnBeginValue <= columnEndValue ? columnName + " between " + columnBeginValue + " and " + columnEndValue : columnName + " not between " + columnEndValue + " and " + columnBeginValue;
        return DatabaseUtil.addWhereClause(text, newText);
    }

    public static String getWhereClause(String text, String[] fullColumnNames) {
        String newText = EMPTY_TEXT;
        for (int i = 0; i < fullColumnNames.length; ++i) {
            if (i > 0) {
                newText = newText + " = ";
            }
            newText = newText + fullColumnNames[i];
        }
        return DatabaseUtil.addWhereClause(text, newText);
    }

    public static String getWhereClause(String text, String columnName, String columnBeginText, String columnEndText) {
        String newText = null;
        columnBeginText = columnBeginText.trim();
        columnEndText = columnEndText.trim();
        if (columnBeginText.length() > 0 && columnEndText.length() > 0) {
            newText = "(" + columnName + " between " + columnBeginText + " and " + columnEndText + WHERE_TEXT_END;
        }
        return DatabaseUtil.addWhereClause(text, newText);
    }

    public static String getSelectClause(String text, String[] columnNames) {
        text = DatabaseUtil.getSelectClause(text, columnNames, columnNames.length);
        return text;
    }

    public static String getSelectClause(String text, String[] columnNames, int selectCount) {
        if (selectCount > 0) {
            for (int i = 0; i < selectCount; ++i) {
                if (text.length() > 0) {
                    text = text + ",";
                }
                text = text + columnNames[i];
            }
        }
        return text;
    }

    public static String getFromClause(String text, String tableName, String tablePrefix) {
        if (text.length() > 0) {
            text = text + ",";
        }
        text = text + tableName;
        if (tablePrefix.length() > 0) {
            text = text + " " + tablePrefix;
        }
        return text;
    }

    public static String getOrderByClause(String text, String[] columnNames, int orderCount) {
        if (columnNames.length > 0 && orderCount > 0) {
            for (int i = 0; i < columnNames.length && i < orderCount; ++i) {
                if (text.length() > 0) {
                    text = text + ",";
                }
                text = text + columnNames[i];
            }
        }
        return text;
    }

    public static String combineClauses(String selectText, String fromText, String whereText, String orderByText) {
        String sql = selectText.length() > 0 ? SELECT_DISTINCT_TEXT + selectText : SELECT_ALL_TEXT;
        if (fromText.length() > 0) {
            sql = sql + FROM_TEXT + fromText;
        }
        if (whereText.length() > 0) {
            sql = sql + WHERE_TEXT_BEGIN + whereText + WHERE_TEXT_END;
        }
        if (orderByText.length() > 0) {
            sql = sql + ORDER_BY_TEXT + orderByText;
        }
        return sql;
    }

    public static String getColumnText(String[] columnNames, String columnName) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnNames[i].equals(columnName)) continue;
            return columnName;
        }
        return null;
    }
}

