/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.database;

import com.isti.util.CallBackCompletion;
import com.isti.util.database.BackgroundThread;
import com.isti.util.database.QueryJDBC;
import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.IstiPasswordPanel;
import java.awt.Component;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;

public class ConnectionJDBC {
    public static String DIALOG_OPTION_STR = "OK";
    protected static final String DEFAULT_DRIVER_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String DEFAULT_PROTOCOL = "jdbc";
    public static final String DEFAULT_SUBPROTOCOL = "odbc";
    public static final String DEFAULT_SUBNAME = null;
    public static final String INFO_USER_KEY = "user";
    public static final String INFO_PASSWORD_KEY = "password";
    private final CallBackCompletion callBack;
    private Connection databaseConnection = null;
    private Statement databaseStatement = null;
    private final String url;
    private Properties dbInfo;
    private final Object executeLock = new Object();

    public static Properties saveUserPassword(Properties info, String userName, String password) {
        info = info == null ? new Properties() : (Properties)((Hashtable)info).clone();
        if (userName != null) {
            info.setProperty(INFO_USER_KEY, userName);
        }
        if (password != null) {
            info.setProperty(INFO_PASSWORD_KEY, password);
        }
        return info;
    }

    public static String getURL(String subProtocol, String subName) {
        return "jdbc:" + subProtocol + ":" + subName;
    }

    public static String getURL(String subProtocol, String subName, String hostName, int port, String sid) {
        return ConnectionJDBC.getURL(subProtocol, subName) + ":@" + hostName + ":" + port + ":" + sid;
    }

    public static void registerDriver() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        ConnectionJDBC.registerDriver(DEFAULT_DRIVER_NAME);
    }

    public static void deregisterDriver() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        ConnectionJDBC.deregisterDriver(DEFAULT_DRIVER_NAME);
    }

    public static void registerDriver(String driver) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        Class<?> driverClass = Class.forName(driver);
        Object classObj = driverClass.newInstance();
        if (classObj instanceof Driver) {
            DriverManager.registerDriver((Driver)classObj);
        }
    }

    public static void deregisterDriver(String driver) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        Class<?> driverClass = Class.forName(driver);
        Object classObj = driverClass.newInstance();
        if (classObj instanceof Driver) {
            DriverManager.deregisterDriver((Driver)classObj);
        }
    }

    public ConnectionJDBC(String url, CallBackCompletion callBack) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        this(url, null, callBack);
    }

    public ConnectionJDBC(String url, String userName, String passWord, CallBackCompletion callBack) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        this(url, ConnectionJDBC.saveUserPassword(null, userName, passWord), callBack);
    }

    public ConnectionJDBC(String url, Properties info, CallBackCompletion callBack) {
        this.url = url;
        this.dbInfo = info;
        this.callBack = callBack;
        if (callBack != null) {
            this.startBackgroundThread(null);
        }
    }

    public void initConnection(Component parentComp, IstiDialogPopup popupObj) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        String msgStr;
        Thread.yield();
        if (!Thread.currentThread().isInterrupted() && this.isClosed()) {
            if (parentComp != null) {
                this.promptForPassword(parentComp);
            }
            if (popupObj != null) {
                msgStr = "Connecting to the database";
                popupObj.setMessageStr(msgStr);
                popupObj.pack();
                popupObj.show();
            }
            this.createConnection();
            Thread.yield();
        }
        if (!Thread.currentThread().isInterrupted() && this.getConnection() != null && this.getStatement() == null) {
            if (popupObj != null) {
                msgStr = "Initializing the database";
                popupObj.setMessageStr(msgStr);
                popupObj.pack();
                popupObj.show();
            }
            this.createStatement();
            Thread.yield();
        }
    }

    public void createConnection() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        Properties info = this.getInfo();
        Connection dbConnection = info != null ? DriverManager.getConnection(this.url, info) : DriverManager.getConnection(this.url);
        this.setConnection(dbConnection);
    }

    protected void createStatement() throws SQLException {
        if (!this.isClosed()) {
            this.setStatement(this.getConnection().createStatement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Connection dbConnection;
        Statement dbStatement;
        ConnectionJDBC connectionJDBC = this;
        synchronized (connectionJDBC) {
            dbStatement = this.databaseStatement;
            this.databaseStatement = null;
            dbConnection = this.databaseConnection;
            this.databaseConnection = null;
        }
        try {
            if (dbStatement != null) {
                dbStatement.close();
            }
        }
        catch (SQLException sqlEx) {
            // empty catch block
        }
        try {
            if (dbConnection != null) {
                dbConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean isClosed() {
        boolean closedFlag = true;
        try {
            Connection dbConnection = this.getConnection();
            if (dbConnection != null && !dbConnection.isClosed()) {
                closedFlag = false;
            }
        }
        catch (SQLException sqlEx) {
            this.close();
        }
        return closedFlag;
    }

    public synchronized Connection getConnection() {
        return this.databaseConnection;
    }

    protected synchronized Properties getInfo() {
        return this.dbInfo;
    }

    public synchronized Statement getStatement() {
        return this.databaseStatement;
    }

    public synchronized void setConnection(Connection dbConnection) {
        this.databaseConnection = dbConnection;
    }

    public synchronized void setStatement(Statement dbStatement) {
        this.databaseStatement = dbStatement;
    }

    protected synchronized void setUserPassword(String userName, String password) {
        Properties info;
        this.dbInfo = info = ConnectionJDBC.saveUserPassword(this.dbInfo, userName, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final QueryJDBC executeQueryNow(String sql, Component parentComp, IstiDialogPopup popupObj) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        QueryJDBC query = null;
        Object object = this.executeLock;
        synchronized (object) {
            if (sql != null) {
                this.initConnection(parentComp, popupObj);
                Thread.yield();
                if (!Thread.currentThread().isInterrupted()) {
                    if (popupObj != null) {
                        String msgStr = "Accessing the database";
                        popupObj.setMessageStr(msgStr);
                        popupObj.pack();
                        popupObj.show();
                    }
                    if (!this.isClosed()) {
                        try {
                            query = new QueryJDBC(this, sql);
                        }
                        catch (SQLException ex) {
                            query = null;
                        }
                    }
                    if (query == null) {
                        this.close();
                        this.initConnection(parentComp, popupObj);
                        query = new QueryJDBC(this, sql);
                    }
                }
            } else {
                this.initConnection(parentComp, popupObj);
            }
        }
        return query;
    }

    public final QueryJDBC executeQuery(String sql, Component parentComp, IstiDialogPopup popupObj) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        QueryJDBC query = null;
        if (this.callBack != null) {
            this.startBackgroundThread(sql);
        } else {
            query = this.executeQueryNow(sql, parentComp, popupObj);
        }
        return query;
    }

    public QueryJDBC executeQuery(String sql) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        return this.executeQuery(sql, null, null);
    }

    protected void processCallback(Object retVal, String errorMsg) {
        if (this.callBack != null) {
            this.callBack.jobCompleted(retVal, errorMsg);
        }
    }

    protected IstiPasswordPanel createPasswordPanel() {
        Properties info = this.getInfo();
        IstiPasswordPanel passwordPanel = new IstiPasswordPanel();
        passwordPanel.setUsername(info.getProperty(INFO_USER_KEY));
        passwordPanel.setPassword(info.getProperty(INFO_PASSWORD_KEY));
        return passwordPanel;
    }

    protected IstiDialogPopup createPasswordDialog(Component parentComp, IstiPasswordPanel passwordPanel) {
        return IstiPasswordPanel.createLoginDialog(parentComp, passwordPanel);
    }

    public void promptForPassword(Component parentComp) {
        IstiPasswordPanel passwordPanel = this.createPasswordPanel();
        IstiDialogPopup passwordPopup = this.createPasswordDialog(parentComp, passwordPanel);
        passwordPopup.show();
        this.setUserPassword(passwordPanel.getUsername(), passwordPanel.getPassword());
    }

    protected void startBackgroundThread(String sql) {
        IstiDialogPopup popupObj = null;
        Component parentComp = this.callBack.getParentComponent();
        if (parentComp != null) {
            String msgStr = "UNITIALIZED";
            String titleStr = "Please wait...";
            popupObj = new IstiDialogPopup(parentComp, (Object)"UNITIALIZED", "Please wait...", 1, DIALOG_OPTION_STR, false);
        }
        new BackgroundThread(this, sql, parentComp, popupObj).start();
    }
}

