/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.database;

import com.isti.util.IstiThread;
import com.isti.util.database.ConnectionJDBC;
import com.isti.util.database.QueryJDBC;
import com.isti.util.gui.IstiDialogPopup;
import java.awt.Component;

class BackgroundThread
extends IstiThread {
    private final ConnectionJDBC dbConn;
    private final String sql;
    private final Component parentComp;
    private final IstiDialogPopup popupObj;

    public BackgroundThread(ConnectionJDBC dbConn, String sql, Component parentComp, IstiDialogPopup popupObj) {
        super("ConnectionJDBC.BackgroundThread-" + IstiThread.nextThreadNum());
        this.dbConn = dbConn;
        this.sql = sql;
        this.parentComp = parentComp;
        this.popupObj = popupObj;
    }

    public void run() {
        QueryJDBC query = null;
        String errorMessage = null;
        try {
            query = this.dbConn.executeQueryNow(this.sql, this.parentComp, this.popupObj);
        }
        catch (Exception ex) {
            errorMessage = ex.toString();
        }
        if (errorMessage != null) {
            this.dbConn.close();
        }
        if (this.popupObj != null) {
            this.popupObj.close();
        }
        this.dbConn.processCallback(query, errorMessage);
    }
}

