/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.bilinearinterp;

import com.isti.util.UtilFns;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class BilinearInterp {
    private static final String NUMERIC_CHARS = "-+.0123456789eE";
    private boolean errorFlag = false;
    private String errorMessage = null;
    private int dataRowSize = 0;
    private int dataColSize = 0;
    private double[] x1ValsArr = null;
    private double[] x2ValsArr = null;
    private double[][] yValsArr = null;
    private double minX1Value = 0.0;
    private double maxX1Value = 0.0;
    private double minX2Value = 0.0;
    private double maxX2Value = 0.0;

    public BilinearInterp(Reader readerObj) {
        Object obj;
        Enumeration e;
        boolean x2Flag;
        EntryBlock eBlock;
        double x2Val;
        double x1Val;
        if (readerObj == null) {
            this.setErrorMessage("Null parameter");
            return;
        }
        BufferedReader rdr = new BufferedReader(readerObj);
        Vector<EntryBlock> entriesVec = new Vector<EntryBlock>();
        int lineNum = 0;
        this.minX2Value = Double.MAX_VALUE;
        this.minX1Value = Double.MAX_VALUE;
        this.maxX2Value = -1.7976931348623157E308;
        this.maxX1Value = -1.7976931348623157E308;
        try {
            String lineStr;
            while ((lineStr = rdr.readLine()) != null) {
                double yVal;
                ++lineNum;
                int len = (lineStr = lineStr.trim()).length();
                if (len <= 0 || lineStr.startsWith("#") || lineStr.startsWith("//")) continue;
                int ePos = lineStr.indexOf(32);
                if (ePos <= 0) {
                    this.setErrorMessage("No space-character separators found on line " + lineNum);
                    return;
                }
                try {
                    x1Val = Double.parseDouble(lineStr.substring(0, ePos));
                }
                catch (NumberFormatException ex) {
                    this.setErrorMessage("Number format error parsing \"" + lineStr.substring(0, ePos) + "\" on line " + lineNum);
                    return;
                }
                int sPos = ePos + 1;
                ePos = lineStr.indexOf(32, sPos);
                if (ePos <= 0) {
                    this.setErrorMessage("Second space-character separator not found on line " + lineNum);
                    return;
                }
                try {
                    x2Val = Double.parseDouble(lineStr.substring(sPos, ePos));
                }
                catch (NumberFormatException ex) {
                    this.setErrorMessage("Number format error parsing \"" + lineStr.substring(sPos, ePos) + "\" on line " + lineNum);
                    return;
                }
                sPos = ePos + 1;
                if (sPos >= len) {
                    this.setErrorMessage("Third data value not found on line " + lineNum);
                    return;
                }
                try {
                    yVal = Double.parseDouble(lineStr.substring(sPos));
                }
                catch (NumberFormatException ex) {
                    this.setErrorMessage("Number format error parsing \"" + lineStr.substring(sPos) + "\" on line " + lineNum);
                    return;
                }
                if (x1Val < this.minX1Value) {
                    this.minX1Value = x1Val;
                }
                if (x1Val > this.maxX1Value) {
                    this.maxX1Value = x1Val;
                }
                if (x2Val < this.minX2Value) {
                    this.minX2Value = x2Val;
                }
                if (x2Val > this.maxX2Value) {
                    this.maxX2Value = x2Val;
                }
                entriesVec.add(new EntryBlock(x1Val, x2Val, yVal));
            }
        }
        catch (IOException ex) {
            this.setErrorMessage("I/O error reading input data:  " + ex);
            return;
        }
        int entriesVecLen = entriesVec.size();
        if (entriesVecLen < 4) {
            this.setErrorMessage("Less than 4 entries found");
            return;
        }
        try {
            eBlock = (EntryBlock)entriesVec.elementAt(0);
            x1Val = eBlock.x1Val;
            x2Val = eBlock.x2Val;
            eBlock = (EntryBlock)entriesVec.elementAt(1);
        }
        catch (Exception ex) {
            this.setErrorMessage("Error interpreting data entries");
            return;
        }
        if (x1Val < eBlock.x1Val && x2Val == eBlock.x2Val) {
            x2Flag = true;
        } else if (x2Val < eBlock.x2Val && x1Val == eBlock.x1Val) {
            x2Flag = false;
        } else {
            this.setErrorMessage("Data entries do not start in proper grid format");
            return;
        }
        this.dataRowSize = 0;
        if (x2Flag) {
            x1Val = -1.7976931348623157E308;
            e = entriesVec.elements();
            while (e.hasMoreElements()) {
                obj = e.nextElement();
                if (!(obj instanceof EntryBlock)) continue;
                eBlock = (EntryBlock)obj;
                if (eBlock.x2Val != x2Val) {
                    if (this.dataRowSize < 2) {
                        this.setErrorMessage("'Row' size in grid not large enough");
                        return;
                    }
                    break;
                }
                if (eBlock.x1Val <= x1Val) {
                    this.setErrorMessage("'x1' value (" + eBlock.x1Val + ") not increasing");
                    return;
                }
                x1Val = eBlock.x1Val;
                ++this.dataRowSize;
            }
        } else {
            x2Val = -1.7976931348623157E308;
            e = entriesVec.elements();
            while (e.hasMoreElements()) {
                obj = e.nextElement();
                if (!(obj instanceof EntryBlock)) continue;
                eBlock = (EntryBlock)obj;
                if (eBlock.x1Val != x1Val) {
                    if (this.dataRowSize < 2) {
                        this.setErrorMessage("'Row' size in grid not large enough");
                        return;
                    }
                    break;
                }
                if (eBlock.x2Val <= x2Val) {
                    this.setErrorMessage("'x2' value (" + eBlock.x2Val + ") not increasing");
                    return;
                }
                x2Val = eBlock.x2Val;
                ++this.dataRowSize;
            }
        }
        if (this.dataRowSize <= 0 || entriesVecLen % this.dataRowSize != 0) {
            this.setErrorMessage("Data entries not in 'even' grid format");
            return;
        }
        this.dataColSize = entriesVecLen / this.dataRowSize;
        if (x2Flag) {
            this.x1ValsArr = new double[this.dataRowSize];
            this.x2ValsArr = new double[this.dataColSize];
            this.yValsArr = new double[this.dataRowSize][this.dataColSize];
            e = entriesVec.elements();
            x2Val = -1.7976931348623157E308;
            for (int k = 0; k < this.dataColSize; ++k) {
                x1Val = -1.7976931348623157E308;
                for (int j = 0; j < this.dataRowSize; ++j) {
                    if (!e.hasMoreElements()) {
                        this.setErrorMessage("Reached unexpected end of input data");
                        return;
                    }
                    obj = e.nextElement();
                    if (!(obj instanceof EntryBlock)) continue;
                    eBlock = (EntryBlock)obj;
                    if (j == 0) {
                        if (eBlock.x2Val <= x2Val) {
                            this.setErrorMessage("'x2' value (" + eBlock.x2Val + ") not increasing");
                            return;
                        }
                        this.x2ValsArr[k] = x2Val = eBlock.x2Val;
                    } else if (eBlock.x2Val != x2Val) {
                        this.setErrorMessage("'x2' value (" + eBlock.x2Val + ") changes within \"row\"");
                        return;
                    }
                    if (eBlock.x1Val <= x1Val) {
                        this.setErrorMessage("'x1' value (" + eBlock.x1Val + ") not increasing");
                        return;
                    }
                    this.x1ValsArr[j] = x1Val = eBlock.x1Val;
                    this.yValsArr[j][k] = eBlock.yVal;
                }
            }
        }
    }

    private void setErrorMessage(String str) {
        this.errorMessage = str;
        this.errorFlag = true;
    }

    public boolean getErrorFlag() {
        return this.errorFlag;
    }

    public String getErrorMessage() {
        return this.errorMessage != null ? this.errorMessage : "No error";
    }

    public ResultBlock interpolateValues(double x1Val, double x2Val) {
        double u;
        double t;
        double y4;
        double y3;
        double y2;
        double y1;
        int k;
        if (this.getErrorFlag()) {
            return new ResultBlock(x1Val, x2Val, this.getErrorMessage());
        }
        if (this.x1ValsArr == null || this.x2ValsArr == null || this.yValsArr == null) {
            return new ResultBlock(x1Val, x2Val, "Null array handle(s)");
        }
        if (this.dataRowSize == 0 || this.dataColSize == 0) {
            return new ResultBlock(x1Val, x2Val, "Data row or column size is zero");
        }
        if (x1Val < this.minX1Value || x1Val > this.maxX1Value || x2Val < this.minX2Value || x2Val > this.maxX2Value) {
            return new ResultBlock(x1Val, x2Val);
        }
        int idx = Arrays.binarySearch(this.x1ValsArr, x1Val);
        if (idx == this.x1ValsArr.length - 1) {
            --idx;
        }
        int j = idx >= 0 ? idx : -(idx + 1) - 1;
        idx = Arrays.binarySearch(this.x2ValsArr, x2Val);
        if (idx == this.x2ValsArr.length - 1) {
            --idx;
        }
        int n = k = idx >= 0 ? idx : -(idx + 1) - 1;
        if (j < 0 || j >= this.x1ValsArr.length - 1 || k < 0 || k >= this.x2ValsArr.length - 1) {
            return new ResultBlock(x1Val, x2Val);
        }
        try {
            y1 = this.yValsArr[j][k];
            y2 = this.yValsArr[j + 1][k];
            y3 = this.yValsArr[j + 1][k + 1];
            y4 = this.yValsArr[j][k + 1];
            t = (x1Val - this.x1ValsArr[j]) / (this.x1ValsArr[j + 1] - this.x1ValsArr[j]);
            u = (x2Val - this.x2ValsArr[k]) / (this.x2ValsArr[k + 1] - this.x2ValsArr[k]);
        }
        catch (Exception ex) {
            return new ResultBlock(x1Val, x2Val, "Internal computation error");
        }
        double result = (1.0 - t) * (1.0 - u) * y1 + t * (1.0 - u) * y2 + t * u * y3 + (1.0 - t) * u * y4;
        return new ResultBlock(result, x1Val, x2Val, this.x1ValsArr[j], this.x2ValsArr[k], y1, this.x1ValsArr[j + 1], this.x2ValsArr[k], y2, this.x1ValsArr[j + 1], this.x2ValsArr[k + 1], y3, this.x1ValsArr[j], this.x2ValsArr[k + 1], y4);
    }

    public ResultBlock[] interpolateMultiString(String valuesStr) {
        int strLen;
        Vector<ResultBlock> resultsVec = new Vector<ResultBlock>();
        int vecSize = 0;
        String errMsgStr = null;
        if (valuesStr != null && (strLen = (valuesStr = valuesStr.trim()).length()) > 0) {
            int sPos = 0;
            while (sPos < strLen) {
                double x2Val;
                double x1Val;
                while (NUMERIC_CHARS.indexOf(valuesStr.charAt(sPos)) < 0 && ++sPos < strLen) {
                }
                if (sPos >= strLen) break;
                int ePos = sPos;
                while (NUMERIC_CHARS.indexOf(valuesStr.charAt(ePos)) >= 0 && ++ePos < strLen) {
                }
                try {
                    x1Val = Double.parseDouble(valuesStr.substring(sPos, ePos));
                }
                catch (NumberFormatException ex) {
                    errMsgStr = "Error parsing value (\"" + valuesStr.substring(sPos, ePos) + "\")";
                    break;
                }
                if (ePos >= strLen) {
                    errMsgStr = "Second value of pair not found (after \"" + valuesStr.substring(sPos, ePos) + "\")";
                    break;
                }
                sPos = ePos;
                while (NUMERIC_CHARS.indexOf(valuesStr.charAt(sPos)) < 0 && ++sPos < strLen) {
                }
                ePos = sPos;
                while (NUMERIC_CHARS.indexOf(valuesStr.charAt(ePos)) >= 0 && ++ePos < strLen) {
                }
                try {
                    x2Val = Double.parseDouble(valuesStr.substring(sPos, ePos));
                }
                catch (NumberFormatException ex) {
                    errMsgStr = "Error parsing value (\"" + valuesStr.substring(sPos, ePos) + "\")";
                    break;
                }
                sPos = ePos;
                resultsVec.add(this.interpolateValues(x1Val, x2Val));
            }
            if ((vecSize = resultsVec.size()) <= 0 && errMsgStr == null) {
                errMsgStr = "Unable to find any data values to parse";
            }
        } else {
            errMsgStr = "No data values given";
        }
        if (errMsgStr != null) {
            return new ResultBlock[]{new ResultBlock(errMsgStr)};
        }
        return resultsVec.toArray(new ResultBlock[vecSize]);
    }

    public int getDataRowSize() {
        return this.dataRowSize;
    }

    public int getDataColSize() {
        return this.dataColSize;
    }

    public double getMinX1Value() {
        return this.minX1Value;
    }

    public double getMaxX1Value() {
        return this.maxX1Value;
    }

    public double getMinX2Value() {
        return this.minX2Value;
    }

    public double getMaxX2Value() {
        return this.maxX2Value;
    }

    public static void main(String[] args) {
        FileReader rdr;
        String fName = args.length > 0 ? args[0] : "fine_depth_25.xy";
        try {
            rdr = new FileReader(fName);
        }
        catch (Exception ex) {
            System.err.println("Error opening input file \"" + fName + "\"");
            return;
        }
        System.out.println("Loading data set file...");
        BilinearInterp bInterpObj = new BilinearInterp(rdr);
        try {
            ((Reader)rdr).close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (bInterpObj.getErrorFlag()) {
            System.err.println("BilinearInterp error:  " + bInterpObj.getErrorMessage());
            return;
        }
        System.out.println("rowSize=" + bInterpObj.getDataRowSize() + ", colSize=" + bInterpObj.getDataColSize());
        System.out.println("minX1=" + bInterpObj.getMinX1Value() + ", maxX1=" + bInterpObj.getMaxX1Value());
        System.out.println("minX2=" + bInterpObj.getMinX2Value() + ", maxX2=" + bInterpObj.getMaxX2Value());
        block4: while (true) {
            System.out.println();
            System.out.print("Enter pairs of x1,x2 values (<Enter> to exit): ");
            String str = UtilFns.getUserConsoleString();
            if (str == null || str.length() <= 0) break;
            ResultBlock[] rBlockArr = bInterpObj.interpolateMultiString(str);
            int idx = 0;
            while (true) {
                if (idx >= rBlockArr.length) continue block4;
                System.out.println(rBlockArr[idx].getDisplayString());
                ++idx;
            }
            break;
        }
    }

    public class ResultBlock {
        public final double result;
        public final boolean outOfRangeFlag;
        public final boolean errorFlag;
        public final String errorMessage;
        public final double x1Val;
        public final double x2Val;
        public final double p1x1Val;
        public final double p1x2Val;
        public final double p1yVal;
        public final double p2x1Val;
        public final double p2x2Val;
        public final double p2yVal;
        public final double p3x1Val;
        public final double p3x2Val;
        public final double p3yVal;
        public final double p4x1Val;
        public final double p4x2Val;
        public final double p4yVal;

        public ResultBlock(double val, double x1Val, double x2Val, double p1x1Val, double p1x2Val, double p1yVal, double p2x1Val, double p2x2Val, double p2yVal, double p3x1Val, double p3x2Val, double p3yVal, double p4x1Val, double p4x2Val, double p4yVal) {
            this.result = val;
            this.x1Val = x1Val;
            this.x2Val = x2Val;
            this.p1x1Val = p1x1Val;
            this.p1x2Val = p1x2Val;
            this.p1yVal = p1yVal;
            this.p2x1Val = p2x1Val;
            this.p2x2Val = p2x2Val;
            this.p2yVal = p2yVal;
            this.p3x1Val = p3x1Val;
            this.p3x2Val = p3x2Val;
            this.p3yVal = p3yVal;
            this.p4x1Val = p4x1Val;
            this.p4x2Val = p4x2Val;
            this.p4yVal = p4yVal;
            this.outOfRangeFlag = false;
            this.errorFlag = false;
            this.errorMessage = null;
        }

        public ResultBlock(double x1Val, double x2Val) {
            this.result = 0.0;
            this.x1Val = x1Val;
            this.x2Val = x2Val;
            this.p4yVal = 0.0;
            this.p4x2Val = 0.0;
            this.p4x1Val = 0.0;
            this.p3yVal = 0.0;
            this.p3x2Val = 0.0;
            this.p3x1Val = 0.0;
            this.p2yVal = 0.0;
            this.p2x2Val = 0.0;
            this.p2x1Val = 0.0;
            this.p1yVal = 0.0;
            this.p1x2Val = 0.0;
            this.p1x1Val = 0.0;
            this.outOfRangeFlag = true;
            this.errorFlag = true;
            this.errorMessage = "Given value(s) out of range of the data set";
        }

        public ResultBlock(double x1Val, double x2Val, String errMsgStr) {
            this.result = 0.0;
            this.x1Val = x1Val;
            this.x2Val = x2Val;
            this.p4yVal = 0.0;
            this.p4x2Val = 0.0;
            this.p4x1Val = 0.0;
            this.p3yVal = 0.0;
            this.p3x2Val = 0.0;
            this.p3x1Val = 0.0;
            this.p2yVal = 0.0;
            this.p2x2Val = 0.0;
            this.p2x1Val = 0.0;
            this.p1yVal = 0.0;
            this.p1x2Val = 0.0;
            this.p1x1Val = 0.0;
            this.outOfRangeFlag = false;
            this.errorFlag = true;
            this.errorMessage = errMsgStr;
        }

        public ResultBlock(String errMsgStr) {
            this(0.0, 0.0, errMsgStr);
        }

        public String getDisplayString() {
            if (this.errorFlag) {
                return "x1Val=" + this.x1Val + ", x2Val=" + this.x2Val + "; Error:  " + this.errorMessage;
            }
            return "result=" + this.result + ", x1Val=" + this.x1Val + ", x2Val=" + this.x2Val + UtilFns.newline + "    p1x1Val=" + this.p1x1Val + ", p1x2Val=" + this.p1x2Val + ", p1yVal=" + this.p1yVal + UtilFns.newline + "    p2x1Val=" + this.p2x1Val + ", p2x2Val=" + this.p2x2Val + ", p2yVal=" + this.p2yVal + UtilFns.newline + "    p3x1Val=" + this.p3x1Val + ", p3x2Val=" + this.p3x2Val + ", p3yVal=" + this.p3yVal + UtilFns.newline + "    p4x1Val=" + this.p4x1Val + ", p4x2Val=" + this.p4x2Val + ", p4yVal=" + this.p4yVal;
        }
    }

    private class EntryBlock {
        public final double x1Val;
        public final double x2Val;
        public final double yVal;

        public EntryBlock(double x1Val, double x2Val, double yVal) {
            this.x1Val = x1Val;
            this.x2Val = x2Val;
            this.yVal = yVal;
        }
    }
}

