/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.LogFile;
import com.isti.util.UtilFns;
import com.isti.util.ValueTimeBlock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;

public class ValueTimeUtilFns {
    public static final String DATA_SEPARATOR = ";";
    protected static final Class[] constructorParameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ValueTimeUtilFns.class$("java.lang.String")) : class$java$lang$String};
    protected static final boolean gmtFlag = true;
    static /* synthetic */ Class class$java$lang$String;

    protected ValueTimeUtilFns() {
    }

    public static final long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static final long getCurrentTimestamp() {
        return ValueTimeUtilFns.getTimestamp(ValueTimeUtilFns.getCurrentTime());
    }

    public static final long getTime(long timestamp) {
        return timestamp * 1000L;
    }

    public static final long getTimestamp(long millis) {
        return millis / 1000L;
    }

    public static final String getTimestampText(long timestamp) {
        long millis = ValueTimeUtilFns.getTime(timestamp);
        return UtilFns.timeMillisToString(millis, true);
    }

    public static final String getTimestampText(long timestamp, boolean gmtFlag) {
        long millis = ValueTimeUtilFns.getTime(timestamp);
        return UtilFns.timeMillisToString(millis, gmtFlag);
    }

    public static final String getTimeText(long millis) {
        return UtilFns.timeMillisToString(millis, true);
    }

    public static final String getTimeText(long millis, boolean gmtFlag) {
        return UtilFns.timeMillisToString(millis, gmtFlag);
    }

    protected static final Constructor getConstructorForClass(String className) {
        try {
            Class<?> classForName = Class.forName(className);
            if (classForName != null) {
                try {
                    return classForName.getConstructor(constructorParameterTypes);
                }
                catch (Exception e) {
                    LogFile.getGlobalLogObj(true).debug("ValueTimeUtilFns.getConstructorForClass:  Cannot instantiate class '" + className + "':  " + e);
                }
            }
        }
        catch (ClassNotFoundException e) {
            LogFile.getGlobalLogObj(true).debug("ValueTimeUtilFns:  Cannot find class for '" + className + "':  " + e);
        }
        catch (Exception e) {
            LogFile.getGlobalLogObj(true).warning("Error getting class for \"" + className + "\":  " + e);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(e));
        }
        return null;
    }

    protected static final Object getComponentForClass(String className, String dataTxt) {
        if (className.length() <= 0) {
            LogFile.getGlobalLogObj(true).debug("ValueTimeUtilFns.getComponentForClass:  No class name");
            return null;
        }
        try {
            Constructor dc = ValueTimeUtilFns.getConstructorForClass(className);
            if (dc != null) {
                return dc.newInstance(dataTxt);
            }
        }
        catch (InvocationTargetException e) {
            LogFile.getGlobalLogObj(true).debug("ValueTimeUtilFns.getComponentForClass:  Cannot create object for class '" + className + "':  " + e.getCause());
        }
        catch (Exception e) {
            LogFile.getGlobalLogObj(true).debug("ValueTimeUtilFns.getComponentForClass:  Cannot instantiate class '" + className + "':  " + e);
        }
        return null;
    }

    protected static final ValueTimeBlock getValueTimeBlock(String dataStr) {
        try {
            boolean timeIndex = false;
            int dataIndex = dataStr.indexOf(DATA_SEPARATOR);
            int classIndex = dataStr.lastIndexOf(DATA_SEPARATOR);
            String timeText = dataStr.substring(0, dataIndex);
            String dataTxt = dataStr.substring(dataIndex + 1, classIndex);
            String className = dataStr.substring(classIndex + 1);
            Object compObj = ValueTimeUtilFns.getComponentForClass(className, dataTxt);
            if (compObj != null) {
                Date dateObj = UtilFns.parseStringToDate(timeText, true);
                if (dateObj != null) {
                    return new ValueTimeBlock(compObj, dateObj.getTime() / 1000L);
                }
                LogFile.getGlobalLogObj(true).debug("ValueTimeUtilFns.getValueTimeBlock:  Unable to parse time text in data string \"" + dataStr + "\"");
            }
        }
        catch (Exception ex) {
            LogFile.getGlobalLogObj(true).warning("ValueTimeUtilFns.getValueTimeBlock:  Error parsing data string \"" + dataStr + "\":  " + ex);
            LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

