/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import com.isti.util.ValueTimeUtilFns;
import java.util.Date;

public class ValueTimeBlock
extends ValueTimeUtilFns
implements Archivable {
    public Object data;
    public long timestamp;

    public ValueTimeBlock(Object data, long timestamp) {
        this.data = data;
        this.timestamp = timestamp;
    }

    public ValueTimeBlock(String dataStr) {
        this(ValueTimeUtilFns.getValueTimeBlock(dataStr));
    }

    public ValueTimeBlock(String dataStr, Archivable.Marker mkrObj) {
        this(ValueTimeUtilFns.getValueTimeBlock(dataStr));
    }

    public ValueTimeBlock(ValueTimeBlock vtb) {
        this(vtb.data, vtb.timestamp);
    }

    public boolean dataEquals(Object data) {
        if (this.data == null) {
            return data == null;
        }
        return this.data.equals(data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ValueTimeBlock)) {
            return false;
        }
        return this.equals((ValueTimeBlock)obj);
    }

    public boolean equals(ValueTimeBlock obj) {
        if (obj == null) {
            return false;
        }
        return this.timestampEquals(obj.timestamp) && this.dataEquals(obj.data);
    }

    public Date getArchiveDate() {
        return new Date(this.getArchiveTime());
    }

    public long getArchiveTime() {
        return ValueTimeUtilFns.getTime(this.timestamp);
    }

    public String getTimestampText() {
        return ValueTimeUtilFns.getTimestampText(this.timestamp);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean timestampEquals(long timestamp) {
        return this.timestamp == timestamp;
    }

    public String toArchivedForm() {
        return this.toString();
    }

    public String toString() {
        String className;
        String dataString;
        if (this.data != null) {
            dataString = this.data.toString();
            className = this.data.getClass().getName();
        } else {
            dataString = "(null)";
            className = "";
        }
        String dataStr = this.getTimestampText() + ";" + dataString + ";" + className;
        return dataStr;
    }
}

