/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimestampOutputStream
extends FilterOutputStream {
    protected static final char NEWLINE_CHAR = '\n';
    protected boolean newlineFlag = true;
    protected final DateFormat dateFormatObj = DateFormat.getDateTimeInstance();

    public TimestampOutputStream(OutputStream streamObj, String dateFormatStr) {
        super(streamObj);
        if (dateFormatStr != null && dateFormatStr.trim().length() > 0) {
            this.setDateFormatPattern(dateFormatStr);
        } else {
            this.setDateFormatPattern("MMM dd yyyy HH:mm:ss");
        }
    }

    public TimestampOutputStream(OutputStream streamObj) {
        this(streamObj, null);
    }

    public void setDateFormatPattern(String patternStr) {
        try {
            if (this.dateFormatObj instanceof SimpleDateFormat && patternStr != null) {
                ((SimpleDateFormat)this.dateFormatObj).applyPattern(patternStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDateFormatTimeZone(TimeZone timeZoneObj) {
        this.dateFormatObj.setTimeZone(timeZoneObj);
    }

    public void write(int ch) throws IOException {
        if (this.newlineFlag) {
            this.writeTimestamp();
        }
        this.out.write(ch);
        this.newlineFlag = ch == 10;
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int start, int len) throws IOException {
        int p = start;
        int sPos = start;
        block0: while (p < len) {
            if (this.newlineFlag) {
                this.writeTimestamp();
                this.newlineFlag = false;
            }
            while (p < len) {
                if (data[p++] != 10) continue;
                this.out.write(data, sPos, p - sPos);
                sPos = p;
                this.newlineFlag = true;
                continue block0;
            }
        }
        if (p > sPos) {
            this.out.write(data, sPos, p - sPos);
        }
    }

    public void writeTimestamp() throws IOException {
        this.out.write((this.dateFormatObj.format(new Date()) + ":  ").getBytes());
    }
}

