/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CircularBuffer;
import com.isti.util.TagValueTable;

public class TagValueTrkTable
extends TagValueTable {
    public static final int DEF_TRKBUFF_SIZE = 100;
    private final int trackingBufferSize;

    public TagValueTrkTable(boolean trackValsFlag, int trkBuffSize) {
        this.trackingBufferSize = trackValsFlag ? trkBuffSize : 0;
    }

    public TagValueTrkTable(boolean trackValsFlag) {
        this(trackValsFlag, 100);
    }

    public TagValueTrkTable() {
        this(true, 100);
    }

    public TagValueTable.MutableLong createMutableLong(long value) {
        return new TrackingMutableLong(value);
    }

    public boolean isValueInTrkBuffer(String tagStr, long value) {
        Object obj = this.hashTableObj.get(tagStr);
        return obj instanceof TrackingMutableLong ? ((TrackingMutableLong)obj).isValueInTrkBuffer(value) : false;
    }

    public boolean isValueInTrkBuffer(String tagStr, Long valueObj) {
        Object obj = this.hashTableObj.get(tagStr);
        return obj instanceof TrackingMutableLong ? ((TrackingMutableLong)obj).isValueInTrkBuffer(valueObj) : false;
    }

    public class TrackingMutableLong
    extends TagValueTable.MutableLong {
        private final CircularBuffer circularBufferObj;

        public TrackingMutableLong(long value) {
            super(value);
            this.circularBufferObj = TagValueTrkTable.this.trackingBufferSize > 0 ? new CircularBuffer(TagValueTrkTable.this.trackingBufferSize) : null;
            this.circularBufferObj.add(new Long(value));
        }

        public void setValue(long value) {
            super.setValue(value);
            if (this.circularBufferObj != null) {
                this.circularBufferObj.add(new Long(value));
            }
        }

        public boolean isValueInTrkBuffer(long value) {
            return this.circularBufferObj != null ? this.circularBufferObj.contains(new Long(value)) : false;
        }

        public boolean isValueInTrkBuffer(Long valueObj) {
            return this.circularBufferObj != null ? this.circularBufferObj.contains(valueObj) : false;
        }
    }
}

