/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.UtilFns;

public class SimplePropsParser {
    protected final String propertiesString;
    protected final char separatorChar;
    protected final int propsStrLen;
    protected int propsStrPos = 0;

    public SimplePropsParser(String propsStr, char sepCh) {
        if (propsStr == null) {
            throw new NullPointerException("Null parameter");
        }
        this.propertiesString = propsStr;
        this.separatorChar = sepCh;
        this.propsStrLen = this.propertiesString.length();
    }

    public SimplePropsParser(String propsStr) {
        this(propsStr, ',');
    }

    public String getValue(String nameStr) {
        if (nameStr == null || nameStr.length() <= 0) {
            return null;
        }
        int nameStrLen = nameStr.length();
        int sPos = this.propsStrPos;
        while (sPos < this.propsStrLen) {
            boolean eqFoundFlag;
            char ch;
            int p = this.propertiesString.indexOf(nameStr, sPos);
            if (p < 0 && (sPos <= 0 || (p = this.propertiesString.indexOf(nameStr)) < 0)) {
                return null;
            }
            sPos = p + nameStrLen;
            if (p > 0 && (ch = this.propertiesString.charAt(p - 1)) != '\"' && ch > ' ' && ch != this.separatorChar) continue;
            p = sPos;
            boolean quoteFlag = false;
            while (true) {
                if (p >= this.propsStrLen) {
                    return null;
                }
                ch = this.propertiesString.charAt(p);
                if (ch == '=') {
                    eqFoundFlag = true;
                    break;
                }
                if (ch != ' ' && ch != '\t') {
                    if (ch == '\"') {
                        if (quoteFlag) {
                            eqFoundFlag = false;
                            break;
                        }
                        quoteFlag = true;
                    } else {
                        eqFoundFlag = false;
                        break;
                    }
                }
                ++p;
            }
            if (!eqFoundFlag) continue;
            if (++p >= this.propsStrLen) {
                this.propsStrPos = 0;
                return "";
            }
            int cPos = UtilFns.findCharPos(this.propertiesString, this.separatorChar, p);
            if (cPos < 0) {
                cPos = this.propsStrLen;
            }
            if ((this.propsStrPos = cPos + 1) >= this.propsStrLen) {
                this.propsStrPos = 0;
            }
            return UtilFns.removeQuoteChars(this.propertiesString.substring(p, cPos).trim(), true);
        }
        return null;
    }
}

