/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ProgramSingleton {
    public static final String SINGLETON_FILE_EXT = ".psf";
    protected final File singletonFileObj;
    protected final int UPDATE_INTERVAL_MS = 30000;
    protected FileManagerThread fileManagerThreadObj = null;
    protected RandomAccessFile singletonFileAccessObj = null;

    public ProgramSingleton(String programNameStr) {
        this(new File(programNameStr + SINGLETON_FILE_EXT));
    }

    public ProgramSingleton(String parent, String programNameStr) {
        this(new File(parent, programNameStr + SINGLETON_FILE_EXT));
    }

    public ProgramSingleton(File parent, String programNameStr) {
        this(new File(parent, programNameStr + SINGLETON_FILE_EXT));
    }

    public ProgramSingleton(File singletonFileObj) {
        this.singletonFileObj = singletonFileObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        File file = this.singletonFileObj;
        synchronized (file) {
            block13: {
                if (this.singletonFileObj.exists()) {
                    try {
                        BufferedReader rdrObj = new BufferedReader(new FileReader(this.singletonFileObj));
                        String str = rdrObj.readLine();
                        try {
                            rdrObj.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (str == null) break block13;
                        try {
                            long fileTimeVal = Long.parseLong(str.trim());
                            long curTimeVal = System.currentTimeMillis();
                            if (curTimeVal > fileTimeVal && curTimeVal - fileTimeVal < 60000L) {
                                return true;
                            }
                        }
                        catch (NumberFormatException ex) {}
                    }
                    catch (FileNotFoundException ex) {
                    }
                    catch (IOException ex) {
                        return true;
                    }
                    catch (Exception ex) {
                        System.err.println("ProgramSingleton:  Error reading program-singleton file:  " + ex);
                        ex.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    public boolean initialize() {
        if (this.isRunning()) {
            return false;
        }
        if (this.fileManagerThreadObj != null) {
            this.fileManagerThreadObj.terminate();
        }
        this.fileManagerThreadObj = new FileManagerThread();
        this.fileManagerThreadObj.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.fileManagerThreadObj != null) {
            this.fileManagerThreadObj.terminate();
            this.fileManagerThreadObj = null;
        }
        File file = this.singletonFileObj;
        synchronized (file) {
            block8: {
                try {
                    if (this.singletonFileAccessObj == null) break block8;
                    try {
                        this.singletonFileAccessObj.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    this.singletonFileAccessObj = null;
                    this.singletonFileObj.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean waitForClose(int millis) {
        return this.waitForClose(millis, 1000);
    }

    public boolean waitForClose(int millis, int retry) {
        long sleepTime = retry;
        long startTime = System.currentTimeMillis();
        while (this.isRunning()) {
            if (millis > 0) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (elapsedTime >= (long)millis) {
                    return false;
                }
                long timeRemaining = (long)millis - elapsedTime;
                if (sleepTime > timeRemaining) {
                    sleepTime = timeRemaining;
                }
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        return true;
    }

    protected class FileManagerThread
    extends Thread {
        private boolean terminateFlag = false;

        public FileManagerThread() {
            super("ProgramSingleton");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            File file = ProgramSingleton.this.singletonFileObj;
            synchronized (file) {
                try {
                    File parentFileObj;
                    if (!ProgramSingleton.this.singletonFileObj.exists() && (parentFileObj = ProgramSingleton.this.singletonFileObj.getParentFile()) != null && !parentFileObj.isDirectory()) {
                        parentFileObj.mkdirs();
                    }
                    ProgramSingleton.this.singletonFileAccessObj = new RandomAccessFile(ProgramSingleton.this.singletonFileObj, "rw");
                    while (!this.terminateFlag) {
                        try {
                            ProgramSingleton.this.singletonFileAccessObj.seek(0L);
                            ProgramSingleton.this.singletonFileAccessObj.setLength(0L);
                            ProgramSingleton.this.singletonFileAccessObj.writeBytes(Long.toString(System.currentTimeMillis()));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ProgramSingleton.this.singletonFileObj.wait(30000L);
                    }
                }
                catch (Exception ex) {
                    System.err.println("ProgramSingleton:  Error writing program-singleton file:  " + ex);
                    ex.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            if (!this.terminateFlag && this.isAlive()) {
                this.terminateFlag = true;
                try {
                    File file = ProgramSingleton.this.singletonFileObj;
                    synchronized (file) {
                        ProgramSingleton.this.singletonFileObj.notifyAll();
                    }
                    this.join(100L);
                }
                catch (Exception ex) {
                    System.err.println("ProgramSingleton:  Error terminating file-manager thread:  " + ex);
                    ex.printStackTrace();
                }
            }
        }
    }
}

