/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.IstiThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class ProcessUtilFns {
    protected ProcessUtilFns() {
    }

    public static Process exec(String command) throws IOException {
        return Runtime.getRuntime().exec(command);
    }

    public static Process exec(String command, PrintStream stderrPrintStream, PrintStream stdoutPrintStream) throws IOException {
        Process process = Runtime.getRuntime().exec(command);
        ProcessOutputHandler stderrProcessOutputHandler = new ProcessOutputHandler(process.getErrorStream(), stderrPrintStream);
        ProcessOutputHandler stdoutProcessOutputHandler = new ProcessOutputHandler(process.getInputStream(), stdoutPrintStream);
        return new ProcessWithThreads(process, new Thread[]{stderrProcessOutputHandler, stdoutProcessOutputHandler});
    }

    public static Process exec(String[] commandArr, PrintStream stderrPrintStream, PrintStream stdoutPrintStream) throws IOException {
        Process process = Runtime.getRuntime().exec(commandArr);
        ProcessOutputHandler stderrProcessOutputHandler = new ProcessOutputHandler(process.getErrorStream(), stderrPrintStream);
        ProcessOutputHandler stdoutProcessOutputHandler = new ProcessOutputHandler(process.getInputStream(), stdoutPrintStream);
        return new ProcessWithThreads(process, new Thread[]{stderrProcessOutputHandler, stdoutProcessOutputHandler});
    }

    public static Integer exitValue(Process p) {
        try {
            return new Integer(p.exitValue());
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return null;
        }
    }

    public static Integer waitFor(Process p) throws InterruptedException {
        return new Integer(p.waitFor());
    }

    public static Integer waitFor(Process p, long millis) throws InterruptedException {
        if (millis == 0L) {
            return ProcessUtilFns.waitFor(p);
        }
        long sleepTime = 1000L;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                return new Integer(p.exitValue());
            }
            catch (IllegalThreadStateException ex) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (elapsedTime >= millis) {
                    p.destroy();
                    return null;
                }
                long timeRemaining = millis - elapsedTime;
                if (sleepTime > timeRemaining) {
                    sleepTime = timeRemaining;
                }
                Thread.sleep(sleepTime);
                continue;
            }
            break;
        }
    }

    private static class ProcessWithThreads
    extends Process {
        private final Process process;
        private final Thread[] threads;

        public ProcessWithThreads(Process process, Thread[] threads) {
            this.process = process;
            this.threads = threads;
            for (int i = 0; i < threads.length; ++i) {
                threads[i].start();
            }
        }

        public OutputStream getOutputStream() {
            return this.process.getOutputStream();
        }

        public InputStream getInputStream() {
            return this.process.getInputStream();
        }

        public InputStream getErrorStream() {
            return this.process.getErrorStream();
        }

        public int waitFor() throws InterruptedException {
            try {
                return this.process.waitFor();
            }
            catch (InterruptedException ex) {
                this.terminateHandlers();
                throw ex;
            }
        }

        public int exitValue() {
            return this.process.exitValue();
        }

        public void destroy() {
            this.process.destroy();
            this.terminateHandlers();
        }

        private void terminateHandlers() {
            for (int i = 0; i < this.threads.length; ++i) {
                try {
                    this.threads[i].interrupt();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static class ProcessOutputHandler
    extends IstiThread {
        private final BufferedReader br;
        private final PrintStream ps;

        public ProcessOutputHandler(InputStream is, PrintStream ps) {
            super("ProcessOutputHandler" + IstiThread.nextThreadNum());
            this.br = new BufferedReader(new InputStreamReader(is));
            this.ps = ps;
        }

        public void run() {
            try {
                String line;
                while ((line = this.br.readLine()) != null) {
                    if (this.ps == null) continue;
                    this.ps.println(line);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

