/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PatchManifest {
    protected static int STREAM_TRANSFER_BUFFER_SIZE = 2048;

    public static void main(String[] args) {
        try {
            int p;
            byte[] SEARCH_ARR = "level=\"highestAvailable\"\n\t\t\t\t".getBytes("US-ASCII");
            byte[] REPLACE_ARR = "level=\"requireAdministrator\"\n".getBytes("US-ASCII");
            byte[] btArr = PatchManifest.readFileToBuffer(args[0]);
            int btArrLen = btArr.length;
            int scanPos = 0;
            byte firstSearchBt = SEARCH_ARR[0];
            block2: while (true) {
                if (scanPos >= btArrLen) {
                    System.out.println("PatchManifest (\"" + args[0] + "\"):  Unable to find search pattern");
                    System.exit(1);
                    return;
                }
                if (btArr[scanPos] == firstSearchBt) {
                    p = 1;
                    while (scanPos + p < btArrLen) {
                        if (p >= SEARCH_ARR.length) {
                            for (int q = 0; q < REPLACE_ARR.length; ++q) {
                                btArr[scanPos + q] = REPLACE_ARR[q];
                            }
                            break block2;
                        }
                        if (btArr[scanPos + p] != SEARCH_ARR[p]) break;
                        ++p;
                    }
                }
                ++scanPos;
            }
            System.out.println("PatchManifest (\"" + args[0] + "\"):  Replacing " + p + " bytes at position " + scanPos);
            String outFileStr = args.length > 1 ? args[1] : args[0];
            PatchManifest.writeBufferToFile(outFileStr, btArr);
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static byte[] readFileToBuffer(String fileNameStr) throws FileNotFoundException, IOException {
        BufferedInputStream inStm = new BufferedInputStream(new FileInputStream(fileNameStr));
        byte[] byteArr = PatchManifest.readStreamToBuffer(inStm);
        inStm.close();
        return byteArr;
    }

    public static byte[] readStreamToBuffer(InputStream stmObj) throws IOException {
        ByteArrayOutputStream outStmObj = new ByteArrayOutputStream();
        PatchManifest.transferStream(stmObj, outStmObj);
        outStmObj.flush();
        return outStmObj.toByteArray();
    }

    public static void transferStream(InputStream inputStreamObj, OutputStream outputStreamObj) throws IOException {
        int b;
        byte[] buffer = new byte[STREAM_TRANSFER_BUFFER_SIZE];
        while ((b = inputStreamObj.read(buffer, 0, STREAM_TRANSFER_BUFFER_SIZE)) > 0) {
            outputStreamObj.write(buffer, 0, b);
        }
    }

    public static void writeBufferToFile(String fileNameStr, byte[] btArr) throws IOException {
        FileOutputStream outStm = new FileOutputStream(fileNameStr);
        ByteArrayInputStream inStmObj = new ByteArrayInputStream(btArr);
        PatchManifest.transferStream(inStmObj, outStm);
        outStm.close();
    }
}

