/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CfgPropItem;
import com.isti.util.CfgProperties;
import com.isti.util.FileUtils;
import com.isti.util.IstiThread;
import com.isti.util.UtilFns;
import java.io.File;
import java.io.IOException;

public class MsgViaFileProcessor {
    protected static final String DEF_PROCDIR_NAME = "msgProcess";
    protected static final int MAX_STORAGE_AGE_CHECK_SECS = 600;
    protected final File inputDirFileObj;
    protected final File storageDirFileObj;
    protected final File processDirFileObj;
    protected final int inputPollDelayMS;
    protected final int storageAgeSecsVal;
    protected final ProcMsgCallBack procMsgCallBackObj;
    protected MsgFileProcessingThread msgFileProcessingThreadObj = null;
    protected String procCharsetNameStr = null;

    public MsgViaFileProcessor(File inputDirFile, File storageDirFile, File processDirFile, int pollDelayMS, int storageAgeSecs, ProcMsgCallBack procMsgCallBack) throws IOException {
        if (inputDirFile != null) {
            if (!inputDirFile.isDirectory() && !inputDirFile.mkdirs()) {
                throw new IOException("Unable to create input directory \"" + inputDirFile.getAbsolutePath() + "\"");
            }
            this.inputDirFileObj = inputDirFile;
        } else {
            this.inputDirFileObj = new File(".");
        }
        if (storageDirFile != null) {
            if (!storageDirFile.isDirectory() && !storageDirFile.mkdirs()) {
                throw new IOException("Unable to create storage directory \"" + storageDirFile.getAbsolutePath() + "\"");
            }
            this.storageDirFileObj = storageDirFile;
        } else {
            this.storageDirFileObj = null;
        }
        File file = this.processDirFileObj = processDirFile != null ? processDirFile : new File(DEF_PROCDIR_NAME);
        if (!this.processDirFileObj.isDirectory() && !this.processDirFileObj.mkdirs()) {
            throw new IOException("Unable to create process directory \"" + this.processDirFileObj.getAbsolutePath() + "\"");
        }
        if (this.inputDirFileObj.equals(this.processDirFileObj)) {
            throw new IllegalArgumentException("Input and process directories are the same");
        }
        if (this.storageDirFileObj != null && this.inputDirFileObj.equals(this.storageDirFileObj)) {
            throw new IllegalArgumentException("Input and storage directories are the same");
        }
        if (this.storageDirFileObj != null && this.processDirFileObj.equals(this.storageDirFileObj)) {
            throw new IllegalArgumentException("Process and storage directories are the same");
        }
        if (!this.inputDirFileObj.canRead()) {
            throw new IOException("Unable to read from input directory \"" + inputDirFile.getAbsolutePath() + "\"");
        }
        if (this.storageDirFileObj != null && !this.storageDirFileObj.canWrite()) {
            throw new IOException("Unable to write to storage directory \"" + storageDirFile.getAbsolutePath() + "\"");
        }
        if (procMsgCallBack == null) {
            throw new NullPointerException("Null 'procMsgCallBack' parameter");
        }
        this.procMsgCallBackObj = procMsgCallBack;
        this.inputPollDelayMS = pollDelayMS;
        this.storageAgeSecsVal = this.storageDirFileObj != null ? storageAgeSecs : 0;
    }

    public MsgViaFileProcessor(String inputDirName, String storageDirName, String processDirName, int pollDelayMS, int storageAgeSecs, ProcMsgCallBack procMsgCallBack) throws IOException {
        this(inputDirName != null && inputDirName.trim().length() > 0 ? new File(inputDirName) : null, storageDirName != null && storageDirName.trim().length() > 0 ? new File(storageDirName) : null, processDirName != null && processDirName.trim().length() > 0 ? new File(processDirName) : null, pollDelayMS, storageAgeSecs, procMsgCallBack);
    }

    public MsgViaFileProcessor(ViaFileProperties viaFileProps, ProcMsgCallBack procMsgCallBack) throws IOException {
        this(viaFileProps.inputDirNameProp.stringValue(), viaFileProps.storageDirNameProp.stringValue(), viaFileProps.processDirNameProp.stringValue(), viaFileProps.inputPollDelayMSProp.intValue(), viaFileProps.storageAgeSecsProp.intValue(), procMsgCallBack);
    }

    public void startProcessing() {
        if (this.msgFileProcessingThreadObj == null) {
            this.msgFileProcessingThreadObj = new MsgFileProcessingThread();
            this.msgFileProcessingThreadObj.start();
        }
    }

    public void stopProcessing() {
        if (this.msgFileProcessingThreadObj != null) {
            this.msgFileProcessingThreadObj.terminate();
            this.msgFileProcessingThreadObj = null;
        }
    }

    public void setProcCharsetNameStr(String nameStr) {
        this.procCharsetNameStr = nameStr;
    }

    public String getProcCharsetNameStr() {
        return this.procCharsetNameStr;
    }

    public static class ViaFileProperties {
        public static final String DEF_INPUTDIR_NAME = "msgInput";
        public static final String DEF_STOREDIR_NAME = "msgSave";
        public static final int SECS_PER_DAY = 86400;
        public final CfgProperties propertiesObj;
        public final CfgPropItem inputDirNameProp;
        public final CfgPropItem storageDirNameProp;
        public final CfgPropItem processDirNameProp;
        public final CfgPropItem inputPollDelayMSProp;
        public final CfgPropItem storageAgeSecsProp;

        public ViaFileProperties(CfgProperties propsObj, Object groupSelObj) {
            this.propertiesObj = propsObj != null ? propsObj : new CfgProperties();
            this.inputDirNameProp = this.propertiesObj.add("inputDirName", DEF_INPUTDIR_NAME, null, "Input directory pathname").setGroupSelObj(groupSelObj);
            this.storageDirNameProp = this.propertiesObj.add("storageDirName", DEF_STOREDIR_NAME, null, "Storage directory pathname").setGroupSelObj(groupSelObj);
            this.processDirNameProp = this.propertiesObj.add("processDirName", MsgViaFileProcessor.DEF_PROCDIR_NAME, null, "Process directory pathname").setGroupSelObj(groupSelObj);
            this.inputPollDelayMSProp = this.propertiesObj.add("inputPollDelayMS", new Integer(1000), null, "Delay between polls (ms)").setValidator(1, 8640000).setGroupSelObj(groupSelObj);
            this.storageAgeSecsProp = this.propertiesObj.add("storageAgeSecs", new Integer(86400), null, "Max time to keep copies (secs)").setValidator(0, -1141367296).setGroupSelObj(groupSelObj);
        }

        public ViaFileProperties() {
            this(null, null);
        }

        public CfgProperties getPropertiesObj() {
            return this.propertiesObj;
        }
    }

    public static interface ProcMsgCallBack {
        public String processMsg(String var1, String var2);
    }

    protected class MsgFileProcessingThread
    extends IstiThread {
        public MsgFileProcessingThread() {
            super("MsgFileProcessingThread");
        }

        public void run() {
            block24: {
                try {
                    boolean doStorageFlag = MsgViaFileProcessor.this.storageAgeSecsVal > 0 && MsgViaFileProcessor.this.storageDirFileObj != null;
                    int storageAgeDivTen = MsgViaFileProcessor.this.storageAgeSecsVal / 10;
                    long storageAgeCheckIntervalMs = (long)(storageAgeDivTen <= 600 ? storageAgeDivTen : 600) * 1000L;
                    String resultStr = "";
                    long nextStorageAgeCheckTime = System.currentTimeMillis() + storageAgeCheckIntervalMs;
                    while (!this.isTerminated()) {
                        long timeVal;
                        File storeFileObj;
                        File currFileObj;
                        int idx;
                        UtilFns.sleep(MsgViaFileProcessor.this.inputPollDelayMS);
                        if (this.isTerminated()) break;
                        File[] filesArrObj = MsgViaFileProcessor.this.inputDirFileObj.listFiles();
                        if (filesArrObj != null) {
                            for (idx = 0; idx < filesArrObj.length; ++idx) {
                                if (!this.isTerminated()) {
                                    currFileObj = filesArrObj[idx];
                                    if (currFileObj.length() <= 0L) continue;
                                    try {
                                        storeFileObj = FileUtils.createUnusedFileNameObj(currFileObj.getName(), MsgViaFileProcessor.this.processDirFileObj, false);
                                        if (storeFileObj == null) continue;
                                        currFileObj.renameTo(storeFileObj);
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                    continue;
                                }
                                break block24;
                            }
                        }
                        if ((filesArrObj = MsgViaFileProcessor.this.processDirFileObj.listFiles()) != null) {
                            for (idx = 0; idx < filesArrObj.length; ++idx) {
                                String dataMsgStr;
                                if (this.isTerminated()) break block24;
                                currFileObj = filesArrObj[idx];
                                try {
                                    dataMsgStr = currFileObj.canRead() ? FileUtils.readFileToString(currFileObj, MsgViaFileProcessor.this.procCharsetNameStr) : null;
                                }
                                catch (Exception ex) {
                                    dataMsgStr = null;
                                }
                                if (dataMsgStr != null && (resultStr = MsgViaFileProcessor.this.procMsgCallBackObj.processMsg(currFileObj.getName(), dataMsgStr)) != null) {
                                    if (doStorageFlag && (resultStr = resultStr.trim()).length() > 0) {
                                        resultStr = "M" + resultStr + "_";
                                    }
                                } else if (doStorageFlag) {
                                    resultStr = "Error_";
                                }
                                if (resultStr != null && doStorageFlag) {
                                    try {
                                        storeFileObj = FileUtils.createUnusedFileNameObj(resultStr + currFileObj.getName(), MsgViaFileProcessor.this.storageDirFileObj, false);
                                        if (storeFileObj != null && currFileObj.renameTo(storeFileObj) && !currFileObj.exists()) {
                                            currFileObj = null;
                                        }
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                }
                                if (currFileObj == null) continue;
                                try {
                                    currFileObj.delete();
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                if (!currFileObj.exists()) continue;
                                throw new RuntimeException("Unable to delete message file \"" + currFileObj.getName() + "\", aborting processing");
                            }
                        }
                        if (!doStorageFlag || (timeVal = System.currentTimeMillis()) < nextStorageAgeCheckTime) continue;
                        try {
                            FileUtils.deleteOldFiles(MsgViaFileProcessor.this.storageDirFileObj, (long)MsgViaFileProcessor.this.storageAgeSecsVal * 1000L);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        nextStorageAgeCheckTime = timeVal + storageAgeCheckIntervalMs;
                    }
                }
                catch (Exception ex) {
                    MsgViaFileProcessor.this.procMsgCallBackObj.processMsg(null, "Error processing message files:  " + ex);
                }
            }
        }
    }
}

