/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.IstiThread;
import com.isti.util.LogFile;
import com.isti.util.UtilFns;
import java.io.PrintStream;

public class MemoryInfoLogger {
    protected final LogFile logObj;
    protected final PrintStream altOutputStream;
    protected int intervalSeconds = 60;
    protected StringBuffer stringBufferObj = new StringBuffer();
    protected LoggerRunningThread loggerRunningThreadObj = null;
    protected int logLevelVal = 0;
    protected boolean closeOnTerminateFlag = false;

    public MemoryInfoLogger(LogFile logObj, int intervalSeconds) {
        if (logObj == null) {
            throw new NullPointerException();
        }
        this.logObj = logObj;
        this.altOutputStream = null;
        this.startLoggerThread(intervalSeconds);
    }

    public MemoryInfoLogger(String logFileName, int intervalSeconds) {
        if (logFileName == null) {
            throw new NullPointerException();
        }
        this.closeOnTerminateFlag = true;
        this.logObj = new LogFile(logFileName, -999, 999);
        this.altOutputStream = null;
        this.startLoggerThread(intervalSeconds);
    }

    public MemoryInfoLogger(String logFileName, int intervalSeconds, boolean useDateInFnameFlag) {
        if (logFileName == null) {
            throw new NullPointerException();
        }
        this.closeOnTerminateFlag = true;
        this.logObj = new LogFile(logFileName, -999, 999, false, useDateInFnameFlag);
        this.altOutputStream = null;
        this.startLoggerThread(intervalSeconds);
    }

    public MemoryInfoLogger(String logFileName, int intervalSeconds, int maxLogFileAgeDays) {
        if (logFileName == null) {
            throw new NullPointerException();
        }
        this.closeOnTerminateFlag = true;
        this.logObj = new LogFile(logFileName, -999, 999, false, true);
        this.logObj.setMaxLogFileAge(maxLogFileAgeDays);
        this.altOutputStream = null;
        this.startLoggerThread(intervalSeconds);
    }

    public MemoryInfoLogger(String logFileName, int intervalSeconds, int maxLogFileAgeDays, int logFileSwitchIntervalDays) {
        if (logFileName == null) {
            throw new NullPointerException();
        }
        this.closeOnTerminateFlag = true;
        this.logObj = new LogFile(logFileName, -999, 999, false, true);
        this.logObj.setMaxLogFileAge(maxLogFileAgeDays);
        this.logObj.setLogFileSwitchIntervalDays(logFileSwitchIntervalDays);
        this.altOutputStream = null;
        this.startLoggerThread(intervalSeconds);
    }

    public MemoryInfoLogger(PrintStream stmObj, int intervalSeconds) {
        if (stmObj == null) {
            throw new NullPointerException();
        }
        this.altOutputStream = stmObj;
        this.logObj = null;
        this.startLoggerThread(intervalSeconds);
    }

    protected synchronized void startLoggerThread(int intervalSeconds) {
        this.intervalSeconds = intervalSeconds > 0 ? intervalSeconds : 1;
        this.loggerRunningThreadObj = new LoggerRunningThread("MemoryInfoLogger");
        this.loggerRunningThreadObj.start();
    }

    public synchronized void setConsoleOutputFlag(boolean flgVal) {
        if (this.logObj != null) {
            this.logObj.setConsoleLevel(flgVal ? -999 : 999);
        }
    }

    public synchronized void setLogLevelVal(int levelVal) {
        this.logLevelVal = levelVal;
    }

    public synchronized void setCloseLogOnTerminateFlag(boolean flgVal) {
        this.closeOnTerminateFlag = flgVal;
    }

    public synchronized void terminate() {
        if (this.loggerRunningThreadObj != null) {
            this.loggerRunningThreadObj.terminate();
            this.loggerRunningThreadObj = null;
        }
    }

    protected void logOutputStr(String msgStr) {
        if (this.logObj != null) {
            this.logObj.println(this.logLevelVal, msgStr);
        } else {
            this.altOutputStream.println(msgStr);
        }
    }

    protected class LoggerRunningThread
    extends IstiThread {
        public LoggerRunningThread(String threadName) {
            super(threadName);
            this.setDaemon(true);
        }

        public LoggerRunningThread() {
            this("MemoryInfoLoggerThread-" + IstiThread.nextThreadNum());
        }

        public void run() {
            while (!this.isTerminated()) {
                try {
                    Thread.sleep((long)MemoryInfoLogger.this.intervalSeconds * 1000L);
                }
                catch (InterruptedException ex) {
                    if (this.isTerminated()) break;
                }
                MemoryInfoLogger.this.logOutputStr("Memory info:  " + UtilFns.getMemoryInfoStr());
            }
            MemoryInfoLogger.this.logOutputStr("MemoryInfoLogger terminated OK");
            if (MemoryInfoLogger.this.closeOnTerminateFlag && MemoryInfoLogger.this.logObj != null) {
                MemoryInfoLogger.this.logObj.close();
            }
        }
    }
}

