/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CfgPropValidator;
import com.isti.util.MeasurementUnitsInformation;
import com.isti.util.UtilFns;
import java.util.Locale;

public class MeasurementUnits
implements MeasurementUnitsInformation {
    public static String DEFAULT_DISPLAY_NAME = "Default";
    public static String METRIC_DISPLAY_NAME = "KM";
    public static String US_DISPLAY_NAME = "Miles";
    private static final String[] displayNames = new String[]{DEFAULT_DISPLAY_NAME, METRIC_DISPLAY_NAME, US_DISPLAY_NAME};
    private int iMeasurementUnits = -1;

    public static int getIntegerValue(double d, int mu) {
        return (int)(MeasurementUnits.getValue(d, mu) + 0.5);
    }

    public int getMeasurementUnits() {
        return MeasurementUnits.getMeasurementUnits(this.iMeasurementUnits);
    }

    public static int getMeasurementUnits(int mu) {
        return MeasurementUnits.getMeasurementUnits(mu, UtilFns.getDefaultLocale());
    }

    public static int getMeasurementUnits(int mu, Locale localeObj) {
        if (mu == -1) {
            if (Locale.US.equals(localeObj)) {
                return 2;
            }
            return 0;
        }
        return mu;
    }

    public static String getMeasurementUnitsString(boolean pluralFlag, int mu) {
        String unitText = "meter";
        String pUnitText = null;
        mu = MeasurementUnits.getMeasurementUnits(mu);
        switch (mu) {
            case 0: {
                pUnitText = unitText = "km";
                break;
            }
            case 2: {
                unitText = "mile";
                break;
            }
            case 3: {
                unitText = "foot";
                pUnitText = "feet";
            }
        }
        if (!pluralFlag) {
            return unitText;
        }
        if (pUnitText == null) {
            pUnitText = unitText + "s";
        }
        return pUnitText;
    }

    public static String getMeasurementUnitsString(double d, int mu) {
        return MeasurementUnits.getMeasurementUnitsString(MeasurementUnits.getIntegerValue(d, mu), mu);
    }

    public static String getMeasurementUnitsString(int dVal, int mu) {
        return MeasurementUnits.getMeasurementUnitsString(dVal != 1, mu);
    }

    public static CfgPropValidator getCfgPropValidator() {
        return new CfgPropValidator(displayNames);
    }

    public double getValue(double d) {
        return MeasurementUnits.getValue(d, this.iMeasurementUnits);
    }

    public static double getValue(double d, int mu) {
        mu = MeasurementUnits.getMeasurementUnits(mu);
        switch (mu) {
            case 0: {
                d *= 0.001;
                break;
            }
            case 2: {
                d *= 6.213711922373339E-4;
                break;
            }
            case 3: {
                d *= 3.280839895013123;
            }
        }
        return d;
    }

    public static int parseMeasurementUnits(String dataStr) {
        if (METRIC_DISPLAY_NAME.equalsIgnoreCase(dataStr)) {
            return 0;
        }
        if (US_DISPLAY_NAME.equalsIgnoreCase(dataStr)) {
            return 2;
        }
        return -1;
    }

    public String getValueString(double d) {
        return MeasurementUnits.getValueString(d, this.iMeasurementUnits);
    }

    public static String getValueString(double d, int mu) {
        return MeasurementUnits.getValueString(MeasurementUnits.getIntegerValue(d, mu), mu);
    }

    public static String getValueString(int dVal, int mu) {
        return dVal + " " + MeasurementUnits.getMeasurementUnitsString(dVal, mu);
    }

    public boolean isMetric() {
        return MeasurementUnits.isMetric(this.iMeasurementUnits);
    }

    public static boolean isMetric(int mu) {
        mu = MeasurementUnits.getMeasurementUnits(mu);
        switch (mu) {
            case 2: 
            case 3: {
                return false;
            }
        }
        return true;
    }

    public void setMeasurementUnits(int mu) {
        this.iMeasurementUnits = mu;
    }

    public void setMeasurementUnits(String dataStr) {
        this.setMeasurementUnits(MeasurementUnits.parseMeasurementUnits(dataStr));
    }
}

