/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.ErrorMessageMgr;
import com.isti.util.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Source;
import org.apache.xerces.impl.dv.dtd.DTDDVFactoryImpl;
import org.apache.xerces.impl.dv.dtd.XML11DTDDVFactoryImpl;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.jaxp.DocumentBuilderImpl;
import org.apache.xerces.jaxp.JAXPConstants;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.jaxp.SAXParserImpl;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.XML11Configuration;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class IstiXmlUtils
extends ErrorMessageMgr {
    public static boolean useDocumentFlag = false;
    protected boolean loadFileOpenedFlag = false;
    private static final SAXParser dummySAXParser = null;
    private static final XML11Configuration dummyXml11Obj = null;
    private static final DTDDVFactoryImpl dummyDTDDVFactObj = null;
    private static final XML11DTDDVFactoryImpl dummyxDTDDVFactObj = null;
    private static final DocumentBuilderFactoryImpl dummydBFactObj = null;
    private static final DocumentBuilderImpl dummydBldrObj = null;
    private static final JAXPConstants dummyjConsObj = null;
    private static final SAXParserFactoryImpl dummysPFacObj = null;
    private static final SAXParserImpl dummysParsObj = null;
    private static final Source dummysXtsrcObj = null;
    protected Element rootElement = null;
    public static final String XML_STYLESHEET = "xml-stylesheet";
    public static final String XML_STYLESHEET_PROCESSING_INSTRUCTION = "type=\"text/xsl\" href=\"";
    public static final String XML_FILE_EXTENSION = ".xml";
    public static final SAXBuilder xmlBuilderObj = new SAXBuilder(false);
    public static final XMLOutputter xmlStrOutputterObj = new XMLOutputter();
    public static final XMLOutputter xmlFileOutputterObj = new XMLOutputter();
    public static final XMLOutputter xmlFixedStrOutputterObj = new XMLOutputter();
    public static final String UTF_8_ENCODING_FORMAT = "UTF-8";
    public static final String ISO_8859_1_ENCODING_FORMAT = "ISO-8859-1";

    public static void setDocumentStylesheet(Document documentObj, String uri) {
        ProcessingInstruction stylesheet = new ProcessingInstruction(XML_STYLESHEET, XML_STYLESHEET_PROCESSING_INSTRUCTION + uri + "\"");
        documentObj.getContent().add(0, stylesheet);
    }

    public static void setFileOmitDeclaration(boolean flgVal) {
        xmlFileOutputterObj.setOmitDeclaration(flgVal);
    }

    public static void setFileOmitEncoding(boolean flgVal) {
        xmlFileOutputterObj.setOmitEncoding(flgVal);
    }

    public static void setFileOutNewlines(boolean flgVal) {
        xmlFileOutputterObj.setNewlines(flgVal);
    }

    public static void setFileOutIndent(String indentStr) {
        xmlFileOutputterObj.setIndent(indentStr);
    }

    public static void setFileOutTextTrim(boolean flgVal) {
        xmlFileOutputterObj.setTextTrim(flgVal);
    }

    public static void setElementNamespace(Element elementObj, String prefix, String uri) {
        IstiXmlUtils.setElementNamespace(elementObj, Namespace.getNamespace((String)prefix, (String)uri));
    }

    public static void setElementNamespace(Element elementObj, Namespace namespaceObj) {
        elementObj.setNamespace(namespaceObj);
    }

    public static void setFileLineSeparator(String lineSeparator) {
        if (lineSeparator == null) {
            lineSeparator = System.getProperty("line.separator");
        }
        if (lineSeparator != null) {
            xmlFileOutputterObj.setLineSeparator(lineSeparator);
        }
    }

    public static void setFileOutExpandEmptyElements(boolean flgVal) {
        xmlFileOutputterObj.setExpandEmptyElements(flgVal);
    }

    public static void setStrOutNewlines(boolean flgVal) {
        xmlStrOutputterObj.setNewlines(flgVal);
    }

    public static void setStrOutIndent(String indentStr) {
        xmlStrOutputterObj.setIndent(indentStr);
    }

    public static void setStrOutTextTrim(boolean flgVal) {
        xmlStrOutputterObj.setTextTrim(flgVal);
    }

    public static void setStrOutExpandEmptyElements(boolean flgVal) {
        xmlStrOutputterObj.setExpandEmptyElements(flgVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoadExternalDTDFeature(boolean flgVal) {
        SAXBuilder sAXBuilder = xmlBuilderObj;
        synchronized (sAXBuilder) {
            xmlBuilderObj.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", flgVal);
        }
    }

    public static String addXmlFileExtension(String fileName) {
        if (!fileName.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            fileName = fileName + XML_FILE_EXTENSION;
        }
        return fileName;
    }

    protected Object getComponentForClass(String className) {
        block6: {
            try {
                Class<?> classForName = Class.forName(className);
                if (classForName == null) break block6;
                try {
                    return classForName.newInstance();
                }
                catch (InstantiationException e) {
                    this.enterErrorMessageString("Cannot instantiate class  " + className + ": " + e);
                }
                catch (IllegalAccessException e) {
                    this.enterErrorMessageString("Cannot instantiate class " + className + ": " + e);
                }
            }
            catch (ClassNotFoundException e) {
                this.enterErrorMessageString("Cannot get class for " + className + ": " + e);
            }
            catch (Exception e) {
                this.enterErrorMessageString("Error getting class for " + className + ": " + e);
            }
        }
        return null;
    }

    protected Element findElement(String attribute, String value) {
        return this.findElement(attribute, value, this.rootElement);
    }

    protected Element findElement(String attribute, String value, Element element) {
        if (attribute == null || value == null || element == null) {
            return null;
        }
        String attributeValue = element.getAttributeValue(attribute);
        if (attributeValue != null && attributeValue.equals(value)) {
            return element;
        }
        List childrenList = element.getChildren();
        if (childrenList == null || childrenList.size() <= 0) {
            return null;
        }
        Iterator iterObj = childrenList.iterator();
        while (iterObj.hasNext()) {
            Object obj = iterObj.next();
            if (!(obj instanceof Element)) {
                return null;
            }
            Element childElement = this.findElement(attribute, value, (Element)obj);
            if (childElement == null) continue;
            return childElement;
        }
        return null;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    private static Element getRootElement(Document docObj) {
        if (useDocumentFlag) {
            return docObj.getRootElement();
        }
        return docObj.detachRootElement();
    }

    public void setRootElement(Element elemObj) {
        this.rootElement = elemObj;
    }

    public boolean loadFile(String fileName, String rootElementName) {
        return this.loadFile(fileName, rootElementName, null);
    }

    public boolean loadFile(String fileName, String rootElementName, Properties urlRequestProps) {
        this.clearFetchedErrorMessage();
        this.loadFileOpenedFlag = false;
        BufferedReader rdrObj = FileUtils.fileMultiOpen(fileName, urlRequestProps);
        if (rdrObj == null) {
            this.setErrorMessageString("Unable to open XML data file \"" + fileName + "\"");
            return false;
        }
        this.loadFileOpenedFlag = true;
        boolean retFlag = this.loadStream(rdrObj, rootElementName, fileName);
        try {
            rdrObj.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return retFlag;
    }

    public boolean getLoadFileOpenedFlag() {
        return this.loadFileOpenedFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStream(Reader rdrObj, String rootElementName, String fileName) {
        Element element;
        this.clearFetchedErrorMessage();
        SAXBuilder sAXBuilder = xmlBuilderObj;
        synchronized (sAXBuilder) {
            try {
                Document documentObj = xmlBuilderObj.build(rdrObj);
                element = IstiXmlUtils.getRootElement(documentObj);
            }
            catch (Exception ex) {
                Throwable tObj;
                Exception throwObj;
                Throwable throwable = throwObj = ex instanceof JDOMException && (tObj = ((JDOMException)ex).getCause()) != null ? tObj : ex;
                if (fileName != null) {
                    this.setErrorMessageString("Error loading XML data from file \"" + fileName + "\":  " + throwObj);
                } else {
                    this.setErrorMessageString("Error loading XML data:  " + throwObj);
                }
                return false;
            }
        }
        if (!(rootElementName == null || element != null && element.getName().equalsIgnoreCase(rootElementName))) {
            if (fileName != null) {
                this.setErrorMessageString("Root element \"" + rootElementName + "\" not found in file \"" + fileName + "\"");
            } else {
                this.setErrorMessageString("Root element \"" + rootElementName + "\" not found in XML data");
            }
            return false;
        }
        this.rootElement = element;
        return true;
    }

    public boolean loadStream(Reader rdrObj, String rootElementName) {
        return this.loadStream(rdrObj, rootElementName, null);
    }

    public boolean loadStream(InputStream stmObj, String rootElementName, String fileName) {
        return this.loadStream(new InputStreamReader(stmObj), rootElementName, fileName);
    }

    public boolean loadStream(InputStream stmObj, String rootElementName) {
        return this.loadStream(new InputStreamReader(stmObj), rootElementName, null);
    }

    public boolean saveToFile(String fileName, Element elemObj) {
        BufferedWriter wtrObj;
        this.clearFetchedErrorMessage();
        FileUtils.createParentDirs(fileName);
        try {
            wtrObj = new BufferedWriter(new FileWriter(fileName));
        }
        catch (Exception ex) {
            this.setErrorMessageString(ex.toString());
            return false;
        }
        try {
            IstiXmlUtils.saveToStream(wtrObj, elemObj);
            wtrObj.close();
            return true;
        }
        catch (Exception ex) {
            this.setErrorMessageString(ex.toString());
            try {
                wtrObj.close();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return false;
        }
    }

    public boolean saveToFile(String fileName) {
        return this.saveToFile(fileName, this.rootElement);
    }

    public boolean getErrorFlag() {
        return this.getErrorMessageFlag();
    }

    public String getErrorMessage() {
        String str = this.getErrorMessageString();
        return str != null ? str : "No error";
    }

    public void clearErrorMessage() {
        this.clearErrorMessageString();
    }

    public Element createRootElement(String name) {
        RootElement elemObj = new RootElement(name);
        this.setRootElement(elemObj);
        return elemObj;
    }

    protected void setErrorMessage(String str) {
        this.enterErrorMessageString(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String elementToString(Element xmlMsgObj, boolean normalizeFlag) throws IOException {
        StringWriter wtrObj = new StringWriter();
        XMLOutputter xMLOutputter = xmlStrOutputterObj;
        synchronized (xMLOutputter) {
            xmlStrOutputterObj.output(xmlMsgObj, (Writer)wtrObj);
        }
        return normalizeFlag ? Text.normalizeString((String)wtrObj.toString()) : wtrObj.toString();
    }

    public static String elementToString(Element xmlMsgObj) throws IOException {
        return IstiXmlUtils.elementToString(xmlMsgObj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String elementToFixedString(Element xmlMsgObj) throws IOException {
        StringWriter wtrObj = new StringWriter();
        XMLOutputter xMLOutputter = xmlFixedStrOutputterObj;
        synchronized (xMLOutputter) {
            xmlFixedStrOutputterObj.output(xmlMsgObj, (Writer)wtrObj);
        }
        StringBuffer buff = wtrObj.getBuffer();
        IstiXmlUtils.ctrlCharsToEscapedCodes(buff);
        return buff.toString();
    }

    public static Element stringToElement(String xmlStr) throws JDOMException {
        SAXBuilder sAXBuilder = xmlBuilderObj;
        synchronized (sAXBuilder) {
            try {
                try {
                    ByteArrayInputStream inStmObj = new ByteArrayInputStream(xmlStr.getBytes(UTF_8_ENCODING_FORMAT));
                    return IstiXmlUtils.getRootElement(xmlBuilderObj.build((InputStream)inStmObj));
                }
                catch (UnsupportedEncodingException ex) {
                    return IstiXmlUtils.getRootElement(xmlBuilderObj.build((Reader)new StringReader(xmlStr)));
                }
            }
            catch (IOException ex) {
                throw new JDOMException("I/O error while reading XML string data", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToStream(Writer wtrObj, Element elemObj) throws IOException {
        XMLOutputter xMLOutputter = xmlFileOutputterObj;
        synchronized (xMLOutputter) {
            Document docObj;
            if (useDocumentFlag && (docObj = elemObj.getDocument()) != null) {
                xmlFileOutputterObj.output(docObj, wtrObj);
            } else {
                xmlFileOutputterObj.output(elemObj, wtrObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToStream(OutputStream stmObj, Element elemObj) throws IOException {
        XMLOutputter xMLOutputter = xmlFileOutputterObj;
        synchronized (xMLOutputter) {
            Document docObj;
            if (useDocumentFlag && (docObj = elemObj.getDocument()) != null) {
                xmlFileOutputterObj.output(docObj, stmObj);
            } else {
                xmlFileOutputterObj.output(elemObj, stmObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getChildDataStr(Element parentElementObj, boolean normalizeFlag, boolean fixStrFlag) {
        StringWriter wtrObj = new StringWriter();
        if (parentElementObj != null) {
            List childrenList;
            String str = parentElementObj.getText();
            if (str != null && str.length() > 0) {
                wtrObj.write(str);
                wtrObj.flush();
            }
            if ((childrenList = parentElementObj.getChildren()).size() > 0) {
                XMLOutputter outputterObj;
                XMLOutputter xMLOutputter = outputterObj = fixStrFlag ? xmlFixedStrOutputterObj : xmlStrOutputterObj;
                synchronized (xMLOutputter) {
                    Iterator iterObj = childrenList.iterator();
                    while (iterObj.hasNext()) {
                        Object obj = iterObj.next();
                        if (!(obj instanceof Element)) continue;
                        try {
                            outputterObj.output((Element)obj, (Writer)wtrObj);
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        }
        String retStr = fixStrFlag ? IstiXmlUtils.ctrlCharsToEscapedCodes(wtrObj.toString()) : wtrObj.toString();
        return normalizeFlag ? Text.normalizeString((String)retStr) : retStr;
    }

    public static String getChildDataStr(Element parentElementObj, boolean normalizeFlag) {
        return IstiXmlUtils.getChildDataStr(parentElementObj, normalizeFlag, false);
    }

    public static String getChildDataStr(Element parentElementObj) {
        return IstiXmlUtils.getChildDataStr(parentElementObj, false, false);
    }

    public static String getChildDataFixedStr(Element parentElementObj) {
        return IstiXmlUtils.getChildDataStr(parentElementObj, false, true);
    }

    public static Element getAnyNSChild(Element parentElem, String childNameStr) {
        List listObj = parentElem.getChildren();
        if (listObj != null) {
            Iterator iterObj = listObj.iterator();
            while (iterObj.hasNext()) {
                Object obj = iterObj.next();
                if (!(obj instanceof Element)) continue;
                Element elemObj = (Element)obj;
                if (childNameStr != null && !childNameStr.equals(elemObj.getName())) continue;
                return elemObj;
            }
        }
        return null;
    }

    public static String getEncodedString(String s, String encoding) {
        try {
            s = new String(s.getBytes(), encoding);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static boolean ctrlCharsToEscapedCodes(StringBuffer buff) {
        boolean modFlag = false;
        int idx = 0;
        int buffLen = buff.length();
        while (idx < buffLen) {
            char ch = buff.charAt(idx);
            if (ch < ' ' || ch > '\u007f') {
                String encStr = "&#" + Integer.toString(ch) + ';';
                buff.replace(idx, idx + 1, encStr);
                int encLen = encStr.length();
                buffLen += encLen - 1;
                idx += encLen;
                modFlag = true;
                continue;
            }
            ++idx;
        }
        return modFlag;
    }

    public static String ctrlCharsToEscapedCodes(String srcStr) {
        StringBuffer buff = new StringBuffer(srcStr);
        return IstiXmlUtils.ctrlCharsToEscapedCodes(buff) ? buff.toString() : srcStr;
    }

    public static String convertFromEscapedCodes(String srcStr, int maxEscVal) {
        int ampPos = srcStr.indexOf(38);
        if (ampPos < 0) {
            return srcStr;
        }
        StringBuffer buff = new StringBuffer(srcStr);
        int p = ampPos;
        int buffLen = buff.length();
        block2: while (++p < buffLen) {
            block9: {
                char ch = buff.charAt(p);
                if (ch == '#') {
                    while (++p < buffLen) {
                        ch = buff.charAt(p);
                        if (Character.isDigit(ch)) continue;
                        if (ch != ';' || p <= ampPos + 2) break block9;
                        try {
                            int codeVal = Integer.parseInt(buff.substring(ampPos + 2, p));
                            if (codeVal > 0 && (maxEscVal <= 0 || codeVal <= maxEscVal)) {
                                buff.setCharAt(ampPos, (char)codeVal);
                                buff.delete(ampPos + 1, p + 1);
                                buffLen -= p - ampPos;
                                p = ampPos;
                            }
                            break block9;
                        }
                        catch (Exception ex) {}
                        break block9;
                    }
                    break;
                }
                if (ch == '&') {
                    --p;
                }
            }
            while (++p < buffLen) {
                if (buff.charAt(p) != '&') continue;
                ampPos = p;
                continue block2;
            }
            break;
        }
        return buff.toString();
    }

    public static String ctrlCharsFromEscapedCodes(String srcStr) {
        return IstiXmlUtils.convertFromEscapedCodes(srcStr, 0);
    }

    static {
        xmlFileOutputterObj.setNewlines(true);
        xmlFixedStrOutputterObj.setTrimAllWhite(true);
    }

    public static class RootElement
    extends Element {
        public RootElement(String name) {
            super(name);
            Document docObj;
            if (useDocumentFlag && (docObj = this.getDocument()) == null) {
                docObj = new Document((Element)this);
                this.setDocument(docObj);
            }
        }
    }
}

