/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class IstiSound
implements LineListener,
ActionListener {
    protected final Clip clipObj;
    protected long stopPlayTimeVal = 0L;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public IstiSound(AudioInputStream audiosource) throws IOException, LineUnavailableException {
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = IstiSound.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, audiosource.getFormat());
        this.clipObj = (Clip)AudioSystem.getLine(info);
        this.clipObj.open(audiosource);
        this.clipObj.addLineListener(this);
        this.stopPlayTimeVal = 0L;
    }

    public IstiSound(File file) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(AudioSystem.getAudioInputStream(file));
    }

    public IstiSound(URL url) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(AudioSystem.getAudioInputStream(url));
    }

    public IstiSound(InputStream stmObj) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(AudioSystem.getAudioInputStream(stmObj));
    }

    public void reopen(AudioInputStream audiosource) throws IOException, LineUnavailableException {
        this.stopPlayTimeVal = 0L;
        if (this.clipObj.isOpen()) {
            this.clipObj.close();
        }
        this.clipObj.open(audiosource);
    }

    public void reopen(File file) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.reopen(AudioSystem.getAudioInputStream(file));
    }

    public void reopen(URL url) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.reopen(AudioSystem.getAudioInputStream(url));
    }

    public void reopen(InputStream stmObj) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.reopen(AudioSystem.getAudioInputStream(stmObj));
    }

    public static boolean isSoundFile(File file) {
        try {
            AudioSystem.getAudioFileFormat(file);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static boolean isSoundFile(URL url) {
        try {
            AudioSystem.getAudioFileFormat(url);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public synchronized boolean isActive() {
        return this.clipObj.isActive();
    }

    public synchronized void loop() {
        this.clipObj.loop(-1);
    }

    public synchronized void loop(int count) {
        this.clipObj.loop(count);
    }

    public synchronized void play(boolean waitFlag) {
        this.reset();
        this.start();
        if (waitFlag) {
            while (this.isActive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public synchronized void play() {
        this.play(false);
    }

    public synchronized void play(int secondsVal) {
        boolean firstTimeFlag = this.stopPlayTimeVal == 0L;
        this.stopPlayTimeVal = System.currentTimeMillis() + (long)secondsVal * 1000L;
        if (firstTimeFlag) {
            this.play(false);
        }
    }

    public synchronized void update(LineEvent lineEvent) {
        LineEvent.Type type = lineEvent.getType();
        if (type.equals(LineEvent.Type.STOP)) {
            if (System.currentTimeMillis() < this.stopPlayTimeVal) {
                this.play(false);
            } else {
                this.stopPlayTimeVal = 0L;
            }
        }
    }

    public synchronized void actionPerformed(ActionEvent e) {
        this.play(false);
    }

    public synchronized void reset() {
        this.clipObj.setFramePosition(0);
    }

    public synchronized void start() {
        this.clipObj.start();
    }

    public synchronized void stop() {
        this.stopPlayTimeVal = 0L;
        this.clipObj.stop();
    }

    public synchronized void close() {
        this.stopPlayTimeVal = 0L;
        if (this.clipObj.isActive()) {
            this.clipObj.stop();
        }
        this.clipObj.close();
    }

    public synchronized boolean isOpen() {
        return this.clipObj.isOpen();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

