/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FifoHashtable;
import com.isti.util.FileUtils;
import com.isti.util.IstiTimeObjectCache;
import com.isti.util.LogFile;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;

public class IstiMessageObjectCache
extends IstiTimeObjectCache {
    protected long lastMsgNumTracker;
    protected final String msgNumFileName;
    protected RandomAccessFile msgNumRAFileObj;
    protected FileDescriptor msgNumFDescObj;
    protected final Object msgNumFileSyncObj;
    protected long lastMsgNumSeqBreakTime;
    protected long lastMsgNumSeqBreakMsgNumLogged;

    public IstiMessageObjectCache(LogFile logObj, long tolerance) {
        this(logObj, tolerance, 0L);
    }

    public IstiMessageObjectCache(LogFile logObj, long tolerance, long removeAge) {
        this(logObj, tolerance, removeAge, null, true);
    }

    public IstiMessageObjectCache(LogFile logObj, long tolerance, long removeAge, boolean useLookupKeyFlag) {
        this(logObj, tolerance, removeAge, null, useLookupKeyFlag);
    }

    public IstiMessageObjectCache(LogFile logObj, long tolerance, long removeAge, String msgNumFileName) {
        this(logObj, tolerance, removeAge, msgNumFileName, true);
    }

    public IstiMessageObjectCache(LogFile logObj, long tolerance, long removeAge, String msgNumFileName, boolean useLookupKeyFlag) {
        block6: {
            super(logObj, tolerance, removeAge, useLookupKeyFlag);
            this.lastMsgNumTracker = 0L;
            this.msgNumRAFileObj = null;
            this.msgNumFDescObj = null;
            this.msgNumFileSyncObj = new Object();
            this.lastMsgNumSeqBreakTime = 0L;
            this.lastMsgNumSeqBreakMsgNumLogged = 0L;
            this.msgNumFileName = msgNumFileName;
            if (msgNumFileName != null) {
                if (new File(msgNumFileName).exists()) {
                    this.readMsgNumFile();
                } else if (logObj != null) {
                    logObj.info(this.getLogPrefixString() + " creating last-message number file " + msgNumFileName);
                }
                try {
                    this.msgNumRAFileObj = new RandomAccessFile(msgNumFileName, "rw");
                    this.msgNumFDescObj = this.msgNumRAFileObj.getFD();
                }
                catch (Exception ex) {
                    this.msgNumRAFileObj = null;
                    if (logObj == null) break block6;
                    logObj.warning(this.getLogPrefixString() + " error opening message-number file \"" + msgNumFileName + "\":  " + ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMsgObjEntry(MessageObjectEntry msgObj) {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            long msgNum = msgObj.getMsgNum();
            if (this.lastMsgNumTracker > 0L) {
                if (msgNum != this.lastMsgNumTracker + 1L) {
                    this.lastMsgNumSeqBreakTime = msgObj.getTimeGenerated();
                    if (this.logObj != null && msgNum != this.lastMsgNumSeqBreakMsgNumLogged) {
                        this.logObj.debug(this.getLogPrefixString() + ":  Message # sequence break detected in cache " + "data, prevMsgNum=" + this.lastMsgNumTracker + ", currentMsgNum=" + msgNum + ", currentTimeGen=" + this.lastMsgNumSeqBreakTime);
                        this.lastMsgNumSeqBreakMsgNumLogged = msgNum;
                    }
                } else {
                    this.lastMsgNumSeqBreakMsgNumLogged = 0L;
                }
            }
            this.lastMsgNumTracker = msgNum;
            if (this.msgNumRAFileObj != null) {
                this.writeMsgNumFile();
            }
            this.add(msgObj);
        }
    }

    public void addMessage(long timeGenerated, Object msgObj, String msgStr, long msgNum) {
        this.addMsgObjEntry(new BasicMessageObjectEntry(timeGenerated, msgObj, msgStr, msgNum));
    }

    public IstiTimeObjectCache.VectorWithCount getNewerMessages(long time, long msgNum, int maxCount) {
        return this.getMessages(time, msgNum, 0L, 0L, maxCount);
    }

    public IstiTimeObjectCache.VectorWithCount getNewerMessages(long time, long msgNum) {
        return this.getMessages(time, msgNum, 0L, 0L, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IstiTimeObjectCache.VectorWithCount getMessages(long beginTime, long beginMsgNum, long endTime, long endMsgNum, int maxCount) {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            return this.subListVector(beginTime, beginMsgNum, endTime, endMsgNum, maxCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IstiTimeObjectCache.VectorWithCount getMessages(long beginTime, long beginMsgNum, long endTime, long endMsgNum) {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            return this.subListVector(beginTime, beginMsgNum, endTime, endMsgNum, 0);
        }
    }

    public IstiTimeObjectCache.VectorWithCount getOlderMessages(long time, long msgNum, int maxCount) {
        return this.getMessages(0L, 0L, time, msgNum, maxCount);
    }

    public IstiTimeObjectCache.VectorWithCount getOlderMessages(long time, long msgNum) {
        return this.getMessages(0L, 0L, time, msgNum, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageObjectEntry getFirstMessage() {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            return this.objectCache.size() > 0 ? this.getMessage(0) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageObjectEntry getLastMessage() {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            int cacheSize = this.objectCache.size();
            return cacheSize > 0 ? this.getMessage(cacheSize - 1) : null;
        }
    }

    public long getLastMsgNum() {
        return this.lastMsgNumTracker;
    }

    protected String getLogPrefixString() {
        return "IstiMessageObjectCache";
    }

    protected MessageObjectEntry getMessage(int index) {
        return (MessageObjectEntry)this.objectCache.elementAt(index);
    }

    protected long getMsgTime(long msgNum) {
        for (int i = this.objectCache.size() - 1; i >= 0; --i) {
            MessageObjectEntry objectEntry = this.getMessage(i);
            long objectMsgNum = objectEntry.getMsgNum();
            if (objectMsgNum == msgNum) {
                return objectEntry.getTimeGenerated();
            }
            if (objectMsgNum < msgNum) break;
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IstiTimeObjectCache.VectorWithCount subListVector(long beginTime, long beginMsgNum, long endTime, long endMsgNum, int maxCount) {
        try {
            int lastIndex;
            int firstIndex;
            block35: {
                int i;
                block37: {
                    int cacheSize;
                    block34: {
                        block26: {
                            block36: {
                                long cacheDiffMsgNum;
                                long cacheEndMsgNum;
                                long cacheBeginMsgNum;
                                block32: {
                                    int i2;
                                    block33: {
                                        MessageObjectEntry entryObj;
                                        long timeVal;
                                        Object obj;
                                        int i3;
                                        int vecSize;
                                        IstiTimeObjectCache.VectorWithCount vec;
                                        block28: {
                                            block29: {
                                                block30: {
                                                    block25: {
                                                        block31: {
                                                            MessageObjectEntry firstCacheObj;
                                                            block27: {
                                                                cacheSize = this.objectCache.size();
                                                                if (cacheSize <= 0) return new IstiTimeObjectCache.VectorWithCount();
                                                                firstCacheObj = this.getMessage(0);
                                                                boolean useMsgNum = false;
                                                                if (firstCacheObj.getTimeGenerated() > this.lastMsgNumSeqBreakTime && (beginMsgNum > 0L && beginTime > 0L || endMsgNum > 0L && endTime > 0L)) {
                                                                    useMsgNum = true;
                                                                    if (beginTime > 0L && (beginMsgNum <= 0L || this.getMsgTime(beginMsgNum) != beginTime)) {
                                                                        useMsgNum = false;
                                                                    }
                                                                    if (endTime > 0L && (endMsgNum <= 0L || this.getMsgTime(endMsgNum) != endTime)) {
                                                                        useMsgNum = false;
                                                                    }
                                                                }
                                                                if (useMsgNum) break block27;
                                                                vec = this.getObjects(beginTime, endTime, maxCount);
                                                                vecSize = vec.size();
                                                                if (vecSize <= 0) return vec;
                                                                if (beginMsgNum <= 0L || beginTime <= 0L) break block28;
                                                                break block29;
                                                            }
                                                            cacheBeginMsgNum = firstCacheObj.getMsgNum();
                                                            cacheEndMsgNum = this.getMessage(cacheSize - 1).getMsgNum();
                                                            cacheDiffMsgNum = cacheEndMsgNum - cacheBeginMsgNum;
                                                            firstIndex = -1;
                                                            if (beginMsgNum < cacheBeginMsgNum) break block30;
                                                            if (cacheDiffMsgNum <= 0L) break block31;
                                                            i2 = (int)((double)cacheSize / (double)cacheDiffMsgNum * (double)(beginMsgNum - cacheBeginMsgNum));
                                                            if (i2 < cacheSize) {
                                                                if (this.getMessage(i2).getMsgNum() > beginMsgNum) {
                                                                    while (--i2 >= 0 && this.getMessage(i2).getMsgNum() > beginMsgNum) {
                                                                    }
                                                                    firstIndex = i2 + 1;
                                                                    break block25;
                                                                } else {
                                                                    ++i2;
                                                                }
                                                                break block25;
                                                            } else {
                                                                i2 = 0;
                                                            }
                                                            break block25;
                                                        }
                                                        i2 = 0;
                                                    }
                                                    if (firstIndex >= 0) break block32;
                                                    break block33;
                                                }
                                                firstIndex = 0;
                                                break block32;
                                            }
                                            i3 = 0;
                                            do {
                                                if (!((obj = vec.elementAt(i3)) instanceof MessageObjectEntry) || (timeVal = (entryObj = (MessageObjectEntry)obj).getTimeGenerated()) > beginTime || entryObj.getMsgNum() != beginMsgNum || timeVal != beginTime) continue;
                                                if (vec.getCount() > i3) {
                                                    vec.addToCount(-i3 - 1);
                                                }
                                                do {
                                                    vec.removeElementAt(i3);
                                                } while (--i3 >= 0);
                                                break;
                                            } while (++i3 < vecSize);
                                        }
                                        if (endMsgNum <= 0L) return vec;
                                        if (endTime <= 0L) return vec;
                                        i3 = vecSize - 1;
                                        do {
                                            if (!((obj = vec.elementAt(i3)) instanceof MessageObjectEntry) || (timeVal = (entryObj = (MessageObjectEntry)obj).getTimeGenerated()) < endTime || entryObj.getMsgNum() != endMsgNum || timeVal != endTime) continue;
                                            int cnt = vecSize - i3;
                                            if (vec.getCount() >= cnt) {
                                                vec.addToCount(-cnt);
                                            }
                                            do {
                                                vec.removeElementAt(i3);
                                            } while (--cnt > 0);
                                            return vec;
                                        } while (--i3 >= 0);
                                        return vec;
                                    }
                                    while (i2 < cacheSize) {
                                        if (this.getMessage(i2).getMsgNum() > beginMsgNum) {
                                            firstIndex = i2;
                                            break;
                                        }
                                        ++i2;
                                    }
                                }
                                lastIndex = -1;
                                if (endMsgNum <= 0L || endMsgNum > cacheEndMsgNum) break block34;
                                if (endMsgNum < cacheBeginMsgNum) break block35;
                                if (cacheDiffMsgNum <= 0L) break block36;
                                i = (int)((double)cacheSize / (double)cacheDiffMsgNum * (double)(endMsgNum - cacheBeginMsgNum));
                                if (i < cacheSize) {
                                    if (this.getMessage(i).getMsgNum() < endMsgNum) {
                                        while (++i < cacheSize && this.getMessage(i).getMsgNum() < endMsgNum) {
                                        }
                                        lastIndex = i - 1;
                                        break block26;
                                    } else {
                                        --i;
                                    }
                                    break block26;
                                } else {
                                    i = cacheSize - 1;
                                }
                                break block26;
                            }
                            i = cacheSize - 1;
                        }
                        if (lastIndex >= 0) break block35;
                        break block37;
                    }
                    lastIndex = cacheSize - 1;
                    break block35;
                }
                while (i >= 0) {
                    if (this.getMessage(i).getMsgNum() < endMsgNum) {
                        lastIndex = i;
                        break;
                    }
                    --i;
                }
            }
            if (firstIndex < 0) return new IstiTimeObjectCache.VectorWithCount();
            if (lastIndex < firstIndex) return new IstiTimeObjectCache.VectorWithCount();
            int reqCount = lastIndex - firstIndex + 1;
            if (maxCount <= 0) return new IstiTimeObjectCache.VectorWithCount(this.objectCache.getValuesVector(firstIndex, lastIndex + 1), reqCount);
            if (lastIndex - firstIndex + 1 <= maxCount) return new IstiTimeObjectCache.VectorWithCount(this.objectCache.getValuesVector(firstIndex, lastIndex + 1), reqCount);
            lastIndex = firstIndex + maxCount - 1;
            return new IstiTimeObjectCache.VectorWithCount(this.objectCache.getValuesVector(firstIndex, lastIndex + 1), reqCount);
        }
        catch (Exception ex) {
            if (this.logObj == null) return new IstiTimeObjectCache.VectorWithCount();
            this.logObj.warning(this.getLogPrefixString() + " error accessing cache:  " + ex);
        }
        return new IstiTimeObjectCache.VectorWithCount();
    }

    public long getLastMsgNumSeqBreakTime() {
        return this.lastMsgNumSeqBreakTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readMsgNumFile() {
        if (this.msgNumFileName == null) {
            return;
        }
        Object object = this.msgNumFileSyncObj;
        synchronized (object) {
            block7: {
                try {
                    String msgNumStr = FileUtils.readFileToString(this.msgNumFileName).trim();
                    long l = this.lastMsgNumTracker = msgNumStr.length() > 0 ? Long.parseLong(msgNumStr) : 0L;
                    if (this.logObj != null) {
                        this.logObj.info(this.getLogPrefixString() + " last message number was " + this.lastMsgNumTracker);
                    }
                }
                catch (Exception ex) {
                    if (this.logObj == null) break block7;
                    this.logObj.warning(this.getLogPrefixString() + " error reading last message number:  " + ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMsgNumFile() {
        Object object = this.msgNumFileSyncObj;
        synchronized (object) {
            block7: {
                if (this.msgNumRAFileObj != null) {
                    if (this.logObj != null) {
                        this.logObj.debug3(this.getLogPrefixString() + " last message number is " + this.lastMsgNumTracker);
                    }
                    try {
                        this.msgNumRAFileObj.setLength(0L);
                        this.msgNumRAFileObj.writeBytes(Long.toString(this.lastMsgNumTracker));
                        this.msgNumFDescObj.sync();
                    }
                    catch (Exception ex) {
                        if (this.logObj == null) break block7;
                        this.logObj.warning(this.getLogPrefixString() + " error writing last message number:  " + ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        Object object = this.msgNumFileSyncObj;
        synchronized (object) {
            if (this.msgNumRAFileObj != null) {
                try {
                    this.msgNumRAFileObj.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.msgNumRAFileObj = null;
            }
        }
        if (this.logObj != null) {
            this.logObj.debug(this.getLogPrefixString() + ":  Cache closed");
        }
    }

    public static class BasicMessageObjectEntry
    extends IstiTimeObjectCache.BasicTimeObjectEntry
    implements MessageObjectEntry {
        protected long msgNum;

        public BasicMessageObjectEntry(long timeGenerated, Object msgObj, String msgStr, long msgNum) {
            super(timeGenerated, msgObj, msgStr);
            this.msgNum = msgNum;
        }

        protected BasicMessageObjectEntry() {
        }

        public long getMsgNum() {
            return this.msgNum;
        }
    }

    public static interface MessageObjectEntry
    extends IstiTimeObjectCache.TimeObjectEntry {
        public long getMsgNum();
    }
}

