/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.EndianUtilFns;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamCorruptedException;

public class IstiDataInputStream
extends FilterInputStream
implements DataInput {
    private final byte[] buf;
    private boolean littleEndian;
    private final DataInputStream dis;
    private BufferedReader br;

    public IstiDataInputStream(InputStream in) throws IOException, StreamCorruptedException {
        this(in, false);
    }

    public IstiDataInputStream(InputStream in, boolean little) throws IOException, StreamCorruptedException {
        super(in);
        this.dis = new DataInputStream(in);
        this.buf = new byte[8];
        this.br = null;
        this.littleEndian = little;
    }

    public boolean isBigEndian() {
        return !this.littleEndian;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void setBigEndian(boolean big) {
        this.littleEndian = !big;
    }

    public void setLittleEndian(boolean little) {
        this.littleEndian = little;
    }

    public int read() throws IOException {
        return this.dis.read();
    }

    public int read(byte[] b) throws IOException {
        return this.dis.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.dis.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.dis.skip(n);
    }

    public int available() throws IOException {
        return this.dis.available();
    }

    public void close() throws IOException {
        this.dis.close();
    }

    public synchronized void mark(int readlimit) {
        this.dis.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.dis.reset();
    }

    public boolean markSupported() {
        return this.dis.markSupported();
    }

    public void readFully(byte[] b) throws IOException {
        this.dis.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dis.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        if (this.littleEndian) {
            this.dis.readFully(this.buf, 0, 2);
            return EndianUtilFns.getLeShort(this.buf);
        }
        return this.dis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        if (this.littleEndian) {
            this.dis.readFully(this.buf, 0, 2);
            return EndianUtilFns.getLeUnsignedShort(this.buf);
        }
        return this.dis.readUnsignedShort();
    }

    public char readChar() throws IOException {
        if (this.littleEndian) {
            this.dis.readFully(this.buf, 0, 2);
            return EndianUtilFns.getLeChar(this.buf);
        }
        return this.dis.readChar();
    }

    public int readInt() throws IOException {
        if (this.littleEndian) {
            this.dis.readFully(this.buf, 0, 4);
            return EndianUtilFns.getLeInt(this.buf);
        }
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        if (this.littleEndian) {
            this.dis.readFully(this.buf, 0, 8);
            return EndianUtilFns.getLeLong(this.buf);
        }
        return this.dis.readLong();
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        if (this.br == null) {
            this.br = new BufferedReader(new InputStreamReader(this.in));
        }
        return this.br.readLine();
    }

    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    public static final String readUTF(DataInput in) throws IOException {
        return DataInputStream.readUTF(in);
    }

    public byte[] readByteArray(int length) throws IOException {
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readByte();
        }
        return array;
    }

    public int[] readUnsignedByteArray(int length) throws IOException {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readUnsignedByte();
        }
        return array;
    }

    public short[] readShortArray(int length) throws IOException {
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readShort();
        }
        return array;
    }

    public int[] readUnsignedShortArray(int length) throws IOException {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readUnsignedShort();
        }
        return array;
    }

    public char[] readCharArray(int length) throws IOException {
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readChar();
        }
        return array;
    }

    public int[] readIntArray(int length) throws IOException {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    public long[] readLongArray(int length) throws IOException {
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public float[] readFloatArray(int length) throws IOException {
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readFloat();
        }
        return array;
    }

    public double[] readDoubleArray(int length) throws IOException {
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readDouble();
        }
        return array;
    }
}

