/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FileUtils;
import com.isti.util.IstiThread;
import com.isti.util.LogFile;
import com.isti.util.queue.NotifyThread;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class HeartbeatFile {
    private final int minIntervalMSecs = 1;
    private final Object heartbeatThreadSyncObj = new Object();
    private HeartbeatThread heartbeatThreadObj = null;
    private final Object threadListSyncObj = new Object();
    private List threadListObj = null;
    private String heartbeatFilename = null;
    private int intervalMSecs = 0;
    private LogFile logObj;

    public HeartbeatFile() {
        this.setLogObj(null);
    }

    public boolean addThread(NotifyThread threadObj) {
        return this.getThreadList().add(threadObj);
    }

    public boolean addThread(Thread threadObj) {
        return this.getThreadList().add(threadObj);
    }

    protected String getThreadName(Object obj) {
        if (obj instanceof Thread) {
            return ((Thread)obj).getName();
        }
        return obj.toString();
    }

    protected List createThreadList() {
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List getThreadList() {
        Object object = this.threadListSyncObj;
        synchronized (object) {
            if (this.threadListObj == null) {
                this.threadListObj = this.createThreadList();
            }
            return this.threadListObj;
        }
    }

    protected Iterator getThreadListIterator() {
        return this.getThreadList().iterator();
    }

    protected boolean isThreadAlive(Object obj) {
        if (obj instanceof Thread) {
            return ((Thread)obj).isAlive();
        }
        if (obj instanceof NotifyThread) {
            return ((NotifyThread)obj).isRunning();
        }
        this.logObj.warning("Heartbeat thread \"" + obj.toString() + "\" is an unsupported class:  " + obj.getClass().getName());
        return false;
    }

    public void setFilename(String heartbeatFilename) {
        this.heartbeatFilename = heartbeatFilename;
    }

    public void setIntervalMSecs(int intervalMSecs) {
        this.intervalMSecs = intervalMSecs >= 1 ? intervalMSecs : 1;
    }

    public void setLogObj(LogFile logObj) {
        this.logObj = logObj != null ? logObj : LogFile.getNullLogObj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        try {
            Object object = this.heartbeatThreadSyncObj;
            synchronized (object) {
                if (this.intervalMSecs >= 1 && this.heartbeatThreadObj == null) {
                    File heartbeatFile = new File(this.heartbeatFilename);
                    File heartbeatParentFile = heartbeatFile.getParentFile();
                    if (heartbeatParentFile != null && !heartbeatParentFile.exists() && !heartbeatParentFile.mkdirs()) {
                        this.logObj.warning("Heartbeat file directory \"" + heartbeatParentFile.getAbsolutePath() + "\" could not be created.");
                        return false;
                    }
                    this.heartbeatThreadObj = new HeartbeatThread();
                    this.heartbeatThreadObj.start();
                }
            }
        }
        catch (Exception ex) {
            this.logObj.warning("Heartbeat thread could not be started:  " + ex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.heartbeatThreadSyncObj;
        synchronized (object) {
            if (this.heartbeatThreadObj != null) {
                this.heartbeatThreadObj.terminate();
                this.heartbeatThreadObj = null;
            }
        }
    }

    private boolean updateHeartbeat() {
        boolean updateFlag = true;
        if (this.getThreadList() == null || this.getThreadList().size() <= 0) {
            this.logObj.debug2("Heartbeat thread list is empty");
        } else {
            Iterator it = this.getThreadListIterator();
            while (it.hasNext()) {
                Object obj = it.next();
                String threadName = this.getThreadName(obj);
                if (!this.isThreadAlive(obj)) {
                    updateFlag = false;
                    this.logObj.warning("Heartbeat thread \"" + threadName + "\" is not alive");
                    continue;
                }
                this.logObj.debug3("Heartbeat thread \"" + threadName + "\" is alive");
            }
        }
        if (!updateFlag) {
            return false;
        }
        try {
            String heartbeatText = Long.toString(System.currentTimeMillis());
            FileUtils.writeStringToFile(this.heartbeatFilename, heartbeatText, false);
            this.logObj.debug3("Heartbeat file (" + this.heartbeatFilename + ") updated:  " + heartbeatText);
        }
        catch (Exception ex) {
            this.logObj.warning("Heartbeat file (" + this.heartbeatFilename + ") could not be updated:  " + ex);
        }
        return true;
    }

    private class HeartbeatThread
    extends IstiThread {
        public HeartbeatThread(String threadName) {
            super(threadName);
            this.setDaemon(true);
        }

        public HeartbeatThread() {
            this("HeartbeatThread-" + IstiThread.nextThreadNum());
        }

        public void run() {
            while (!this.isTerminated()) {
                try {
                    HeartbeatFile.this.updateHeartbeat();
                    try {
                        Thread.sleep(HeartbeatFile.this.intervalMSecs);
                    }
                    catch (InterruptedException ex) {
                        if (!this.isTerminated()) continue;
                        break;
                    }
                }
                catch (Exception ex) {
                    HeartbeatFile.this.logObj.warning(this.getName() + "  :" + ex);
                }
            }
            HeartbeatFile.this.logObj.debug(this.getName() + " terminated OK");
        }
    }
}

