/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.ExtendedComparable;
import com.isti.util.UtilFns;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class FifoHashtable
implements Cloneable,
Map {
    private final HashMap hashMapObj;
    private final Vector keysVec;
    private final Vector valuesVec;
    private final Vector mapVec;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;

    public FifoHashtable(int initialCapacity, float loadFactor) {
        this(new HashMap(initialCapacity, loadFactor));
    }

    public FifoHashtable(int initialCapacity) {
        this(new HashMap(initialCapacity));
    }

    public FifoHashtable() {
        this(new HashMap());
    }

    private static int getCompareResult(Object compObj, Object obj, int sortType) {
        int compareResult = sortType != 0 && compObj instanceof ExtendedComparable ? ((ExtendedComparable)compObj).compareTo(obj, sortType) : ((Comparable)compObj).compareTo(obj);
        return compareResult;
    }

    protected FifoHashtable(HashMap hashMapObj) {
        this.hashMapObj = hashMapObj;
        this.keysVec = new Vector();
        this.valuesVec = new Vector();
        this.mapVec = new Vector();
    }

    private FifoHashtable(HashMap hMap, Vector kVec, Vector vVec, Vector mVec) {
        this.hashMapObj = hMap;
        this.keysVec = kVec;
        this.valuesVec = vVec;
        this.mapVec = mVec;
    }

    public synchronized Object put(Object key, Object value) {
        Object oldObj = this.hashMapObj.put(key, value);
        int p = this.keysVec.indexOf(key);
        if (p >= 0) {
            this.keysVec.remove(p);
            if (p < this.valuesVec.size()) {
                this.valuesVec.remove(p);
            }
            if (p < this.mapVec.size()) {
                this.mapVec.remove(p);
            }
        }
        this.keysVec.add(key);
        this.valuesVec.add(value);
        this.mapVec.add(new MapEntry(key, value));
        return oldObj;
    }

    public synchronized void putAll(Map mapObj) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public synchronized Object putSort(Object key, Object value, boolean sortDirFlag) {
        return this.putSort(key, value, sortDirFlag, 0);
    }

    public synchronized Object putSort(Object key, Object value, boolean sortDirFlag, int sortType) {
        Object oldObj = this.hashMapObj.put(key, value);
        int p = this.keysVec.indexOf(key);
        if (p < 0) {
            int tableSize = this.keysVec.size();
            if (this.valuesVec.size() < tableSize) {
                tableSize = this.valuesVec.size();
            }
            if (key instanceof Comparable) {
                for (p = 0; p < tableSize; ++p) {
                    try {
                        Object obj = this.keysVec.get(p);
                        if (obj == null) continue;
                        int compareResult = FifoHashtable.getCompareResult(key, obj, sortType);
                        if (!(sortDirFlag ? compareResult < 0 : compareResult > 0)) continue;
                        break;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            } else {
                p = tableSize;
            }
            this.keysVec.add(p, key);
            this.valuesVec.add(p, value);
            this.mapVec.add(p, new MapEntry(key, value));
        } else {
            if (p < this.valuesVec.size()) {
                this.valuesVec.set(p, value);
            }
            if (p < this.mapVec.size()) {
                this.mapVec.set(p, new MapEntry(key, value));
            }
        }
        return oldObj;
    }

    public synchronized Object putSort(Object key, Object value, boolean sortDirFlag, Comparator compObj) {
        if (compObj == null) {
            return this.putSort(key, value, sortDirFlag);
        }
        Object oldObj = this.hashMapObj.put(key, value);
        int p = this.keysVec.indexOf(key);
        if (p < 0) {
            int tableSize = this.keysVec.size();
            if (this.valuesVec.size() < tableSize) {
                tableSize = this.valuesVec.size();
            }
            if (key instanceof Comparable) {
                for (p = 0; p < tableSize; ++p) {
                    try {
                        Object obj = this.keysVec.get(p);
                        if (obj == null || !(sortDirFlag ? compObj.compare(key, obj) < 0 : compObj.compare(key, obj) > 0)) continue;
                        break;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            } else {
                p = tableSize;
            }
            this.keysVec.add(p, key);
            this.valuesVec.add(p, value);
            this.mapVec.add(p, new MapEntry(key, value));
        } else {
            if (p < this.valuesVec.size()) {
                this.valuesVec.set(p, value);
            }
            if (p < this.mapVec.size()) {
                this.mapVec.set(p, new MapEntry(key, value));
            }
        }
        return oldObj;
    }

    public synchronized void putSortAll(Map mapObj, boolean sortDirFlag) {
        this.putSortAll(mapObj, sortDirFlag, 0);
    }

    public synchronized void putSortAll(Map mapObj, boolean sortDirFlag, int sortType) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.putSort(e.getKey(), e.getValue(), sortDirFlag, sortType);
        }
    }

    public synchronized void putSortAll(Map mapObj, boolean sortDirFlag, Comparator compObj) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.putSort(e.getKey(), e.getValue(), sortDirFlag, compObj);
        }
    }

    public synchronized Object putSortByValue(Object key, Object value, boolean sortDirFlag) {
        return this.putSortByValue(key, value, sortDirFlag, 0);
    }

    public synchronized Object putSortByValue(Object key, Object value, boolean sortDirFlag, int sortType) {
        Object oldObj = this.hashMapObj.put(key, value);
        int p = this.keysVec.indexOf(key);
        if (p >= 0) {
            this.keysVec.remove(p);
            if (p < this.valuesVec.size()) {
                this.valuesVec.remove(p);
            }
            if (p < this.mapVec.size()) {
                this.mapVec.remove(p);
            }
        }
        int tableSize = this.keysVec.size();
        if (this.valuesVec.size() < tableSize) {
            tableSize = this.valuesVec.size();
        }
        if (value instanceof Comparable) {
            for (p = 0; p < tableSize; ++p) {
                try {
                    Object obj = this.valuesVec.get(p);
                    if (obj == null) continue;
                    int compareResult = FifoHashtable.getCompareResult(value, obj, sortType);
                    if (!(sortDirFlag ? compareResult < 0 : compareResult > 0)) continue;
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        } else {
            p = tableSize;
        }
        this.keysVec.add(p, key);
        this.valuesVec.add(p, value);
        this.mapVec.add(p, new MapEntry(key, value));
        return oldObj;
    }

    public synchronized Object putSortByValue(Object key, Object value, boolean sortDirFlag, Comparator compObj) {
        if (compObj == null) {
            return this.putSortByValue(key, value, sortDirFlag);
        }
        Object oldObj = this.hashMapObj.put(key, value);
        int p = this.keysVec.indexOf(key);
        if (p >= 0) {
            this.keysVec.remove(p);
            if (p < this.valuesVec.size()) {
                this.valuesVec.remove(p);
            }
            if (p < this.mapVec.size()) {
                this.mapVec.remove(p);
            }
        }
        int tableSize = this.keysVec.size();
        if (this.valuesVec.size() < tableSize) {
            tableSize = this.valuesVec.size();
        }
        if (value instanceof Comparable) {
            for (p = 0; p < tableSize; ++p) {
                try {
                    Object obj = this.valuesVec.get(p);
                    if (obj == null || !(sortDirFlag ? compObj.compare(value, obj) < 0 : compObj.compare(value, obj) > 0)) continue;
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        } else {
            p = tableSize;
        }
        this.keysVec.add(p, key);
        this.valuesVec.add(p, value);
        this.mapVec.add(p, new MapEntry(key, value));
        return oldObj;
    }

    public synchronized void putSortByValueAll(Map mapObj, boolean sortDirFlag) {
        this.putSortByValueAll(mapObj, sortDirFlag, 0);
    }

    public synchronized void putSortByValueAll(Map mapObj, boolean sortDirFlag, int sortType) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.putSortByValue(e.getKey(), e.getValue(), sortDirFlag, sortType);
        }
    }

    public synchronized void putSortByValueAll(Map mapObj, boolean sortDirFlag, Comparator compObj) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.putSortByValue(e.getKey(), e.getValue(), sortDirFlag, compObj);
        }
    }

    public synchronized Object get(Object key) {
        return this.hashMapObj.get(key);
    }

    public synchronized String getStringValue(Object key, String defaultStr) {
        Object obj = this.hashMapObj.get(key);
        return obj instanceof String ? (String)obj : defaultStr;
    }

    public synchronized String getStringValue(Object key) {
        return this.getStringValue(key, null);
    }

    public synchronized Object remove(Object key) {
        Object oldObj = this.hashMapObj.remove(key);
        int p = this.keysVec.indexOf(key);
        if (p >= 0) {
            this.keysVec.remove(p);
            if (p < this.valuesVec.size()) {
                this.valuesVec.remove(p);
            }
            if (p < this.mapVec.size()) {
                this.mapVec.remove(p);
            }
        }
        return oldObj;
    }

    public synchronized Object removeValue(Object obj) {
        Object oldKeyObj;
        int p = this.valuesVec.indexOf(obj);
        if (p < 0) {
            return null;
        }
        if (p < this.keysVec.size()) {
            Object e = this.keysVec.get(p);
            oldKeyObj = e;
            this.hashMapObj.remove(e);
            this.keysVec.remove(p);
        } else {
            oldKeyObj = null;
        }
        this.valuesVec.remove(p);
        this.mapVec.remove(p);
        return oldKeyObj;
    }

    public synchronized boolean removeAllKeys(Collection collObj) {
        boolean retFlag = false;
        Iterator iterObj = collObj.iterator();
        while (iterObj.hasNext()) {
            int idx = this.keysVec.indexOf(iterObj.next());
            if (idx < 0) continue;
            this.removeElementAt(idx);
            retFlag = true;
        }
        return retFlag;
    }

    public synchronized boolean removeAllValues(Collection collObj) {
        boolean retFlag = false;
        Iterator iterObj = collObj.iterator();
        while (iterObj.hasNext()) {
            int idx = this.valuesVec.indexOf(iterObj.next());
            if (idx < 0) continue;
            this.removeElementAt(idx);
            retFlag = true;
        }
        return retFlag;
    }

    public synchronized boolean containsKey(Object key) {
        return this.hashMapObj.containsKey(key);
    }

    public synchronized boolean containsValue(Object value) {
        return this.hashMapObj.containsValue(value);
    }

    public synchronized boolean contains(Object value) {
        return this.hashMapObj.containsValue(value);
    }

    public synchronized boolean isEmpty() {
        return this.hashMapObj.isEmpty();
    }

    public synchronized int size() {
        return this.hashMapObj.size();
    }

    public synchronized void clear() {
        this.hashMapObj.clear();
        this.keysVec.clear();
        this.valuesVec.clear();
        this.mapVec.clear();
    }

    public synchronized boolean equals(Object o) {
        return this.hashMapObj.equals(o);
    }

    public synchronized int hashCode() {
        return this.hashMapObj.hashCode();
    }

    public synchronized Vector getKeysVector() {
        return (Vector)this.keysVec.clone();
    }

    public synchronized Vector getKeysVector(int fromIndex, int toIndex) {
        return new Vector(this.keysVec.subList(fromIndex, toIndex));
    }

    public synchronized Vector getValuesVector() {
        return (Vector)this.valuesVec.clone();
    }

    public synchronized Vector getValuesVector(int fromIndex, int toIndex) {
        return new Vector(this.valuesVec.subList(fromIndex, toIndex));
    }

    public synchronized HashMap getHashMap() {
        return (HashMap)this.hashMapObj.clone();
    }

    public synchronized Enumeration keys() {
        return ((Vector)this.keysVec.clone()).elements();
    }

    public synchronized Enumeration elements() {
        return ((Vector)this.valuesVec.clone()).elements();
    }

    public synchronized int indexOf(Object obj) {
        return this.valuesVec.indexOf(obj);
    }

    public synchronized int indexOf(Object obj, int idx) {
        return this.valuesVec.indexOf(obj, idx);
    }

    public synchronized int lastIndexOf(Object obj) {
        return this.valuesVec.lastIndexOf(obj);
    }

    public synchronized int lastIndexOf(Object obj, int idx) {
        return this.valuesVec.lastIndexOf(obj, idx);
    }

    public synchronized int indexOfKey(Object obj) {
        return this.keysVec.indexOf(obj);
    }

    public synchronized int indexOfKey(Object obj, int idx) {
        return this.keysVec.indexOf(obj, idx);
    }

    public synchronized int lastIndexOfKey(Object obj) {
        return this.keysVec.lastIndexOf(obj);
    }

    public synchronized int lastIndexOfKey(Object obj, int idx) {
        return this.keysVec.lastIndexOf(obj, idx);
    }

    public synchronized Object elementAt(int idx) {
        return this.valuesVec.get(idx);
    }

    public synchronized Object keyAt(int idx) {
        return this.keysVec.get(idx);
    }

    public synchronized void setElementAt(Object obj, int idx) {
        Object keyObj = this.keyAt(idx);
        this.valuesVec.set(idx, obj);
        this.mapVec.set(idx, new MapEntry(keyObj, obj));
        this.hashMapObj.put(keyObj, obj);
    }

    public synchronized Object removeElementAt(int idx) {
        Object keyObj = this.keyAt(idx);
        this.keysVec.remove(idx);
        this.valuesVec.remove(idx);
        this.mapVec.remove(idx);
        return this.hashMapObj.remove(keyObj);
    }

    public synchronized boolean swapEntries(Object key1Obj, Object key2Obj) {
        try {
            int pos2;
            int pos1 = this.keysVec.indexOf(key1Obj);
            if (pos1 < 0 || (pos2 = this.keysVec.indexOf(key2Obj)) < 0) {
                return false;
            }
            this.keysVec.set(pos1, key2Obj);
            this.keysVec.set(pos2, key1Obj);
            Object obj = this.valuesVec.get(pos1);
            this.valuesVec.set(pos1, this.valuesVec.get(pos2));
            this.valuesVec.set(pos2, obj);
            Object mapEntry = this.mapVec.get(pos1);
            this.mapVec.set(pos1, this.mapVec.get(pos2));
            this.mapVec.set(pos2, mapEntry);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    public synchronized FifoHashtable getSubsetTable(List keysListObj) {
        FifoHashtable retTableObj = new FifoHashtable();
        Iterator iterObj = keysListObj.iterator();
        while (iterObj.hasNext()) {
            int idx = this.indexOfKey(iterObj.next());
            if (idx < 0) continue;
            retTableObj.put(this.keyAt(idx), this.elementAt(idx));
        }
        return retTableObj;
    }

    public synchronized String toQuotedStrings(String sepStr, boolean quoteCharsFlag, boolean dontQuoteKeysFlag, boolean dontQuoteValuesFlag) {
        String SPCHARS = "\"\r\n\t\\";
        String KQC = dontQuoteKeysFlag ? "" : "\"";
        String VQC = dontQuoteValuesFlag ? "" : "\"";
        StringBuffer retBuff = new StringBuffer();
        Iterator iterObj = ((AbstractList)this.keysVec).iterator();
        if (iterObj.hasNext()) {
            if (quoteCharsFlag) {
                while (true) {
                    Object obj;
                    if ((obj = iterObj.next()) != null) {
                        retBuff.append(KQC + UtilFns.insertQuoteChars(obj.toString(), "\"\r\n\t\\") + KQC + "=");
                        obj = this.hashMapObj.get(obj);
                        if (obj != null) {
                            retBuff.append(VQC + UtilFns.insertQuoteChars(obj.toString(), "\"\r\n\t\\") + VQC);
                        } else {
                            retBuff.append("(null)");
                        }
                    }
                    if (iterObj.hasNext()) {
                        retBuff.append(sepStr);
                        continue;
                    }
                    break;
                }
            } else {
                while (true) {
                    Object obj;
                    if ((obj = iterObj.next()) != null) {
                        retBuff.append(KQC + obj.toString() + KQC + "=");
                        obj = this.hashMapObj.get(obj);
                        if (obj != null) {
                            retBuff.append(VQC + obj.toString() + VQC);
                        } else {
                            retBuff.append("(null)");
                        }
                    }
                    if (!iterObj.hasNext()) break;
                    retBuff.append(sepStr);
                }
            }
        }
        return retBuff.toString();
    }

    public String toQuotedStrings(char sepChar, boolean quoteCharsFlag, boolean dontQuoteKeysFlag, boolean dontQuoteValuesFlag) {
        return this.toQuotedStrings(new String(new char[]{sepChar}), quoteCharsFlag, dontQuoteKeysFlag, dontQuoteValuesFlag);
    }

    public String toQuotedStrings(String sepStr, boolean quoteCharsFlag, boolean dontQuoteKeysFlag) {
        return this.toQuotedStrings(sepStr, quoteCharsFlag, dontQuoteKeysFlag, false);
    }

    public String toQuotedStrings(char sepChar, boolean quoteCharsFlag, boolean dontQuoteKeysFlag) {
        return this.toQuotedStrings(sepChar, quoteCharsFlag, dontQuoteKeysFlag, false);
    }

    public String toQuotedStrings(char sepChar, boolean quoteCharsFlag) {
        return this.toQuotedStrings(sepChar, quoteCharsFlag, false, false);
    }

    public String toQuotedStrings(String sepStr, boolean quoteCharsFlag) {
        return this.toQuotedStrings(sepStr, quoteCharsFlag, false, false);
    }

    public String toQuotedStrings() {
        return this.toQuotedStrings(",", true, false, false);
    }

    public static FifoHashtable quotedStringsToTable(FifoHashtable inTable, String str, char sepChar, boolean strictFlag) {
        int ePos;
        FifoHashtable retTable = inTable != null ? inTable : new FifoHashtable();
        int strLen = str.length();
        int sPos = 0;
        do {
            int q;
            int subLen;
            if ((ePos = UtilFns.findCharPos(str, sepChar, sPos)) < sPos) {
                ePos = strLen;
            }
            String subStr = str.substring(sPos, ePos);
            if (strictFlag) {
                subLen = subStr.length();
                if (subLen <= 0) break;
                if (subLen < 2 || (q = UtilFns.findCharPos(subStr, '=')) < 2 || q >= subLen - 1) {
                    return null;
                }
                if (subStr.charAt(0) != '\"' || subStr.charAt(q - 1) != '\"' || subStr.charAt(q + 1) != '\"' || subStr.charAt(subLen - 1) != '\"') {
                    return null;
                }
            } else {
                subLen = (subStr = subStr.trim()).length();
                if (subLen <= 0) break;
                if (subLen < 2 || (q = UtilFns.findCharPos(subStr, '=')) < 2 || q >= subLen - 1) {
                    return null;
                }
            }
            retTable.put(UtilFns.removeQuoteChars(subStr.substring(0, q), true), UtilFns.removeQuoteChars(subStr.substring(q + 1, subLen), true));
        } while ((sPos = ePos + 1) < strLen);
        return retTable;
    }

    public static FifoHashtable quotedStringsToTable(FifoHashtable inTable, String str, char sepChar) {
        return FifoHashtable.quotedStringsToTable(inTable, str, sepChar, true);
    }

    public static FifoHashtable quotedStringsToTable(FifoHashtable inTable, String str) {
        return FifoHashtable.quotedStringsToTable(inTable, str, ',', true);
    }

    public static FifoHashtable quotedStringsToTable(String str, char sepChar, boolean strictFlag) {
        return FifoHashtable.quotedStringsToTable(null, str, sepChar, strictFlag);
    }

    public static FifoHashtable quotedStringsToTable(String str, char sepChar) {
        return FifoHashtable.quotedStringsToTable(null, str, sepChar, true);
    }

    public static FifoHashtable quotedStringsToTable(String str) {
        return FifoHashtable.quotedStringsToTable(null, str, ',', true);
    }

    public synchronized Object clone() {
        return new FifoHashtable((HashMap)this.hashMapObj.clone(), (Vector)this.keysVec.clone(), (Vector)this.valuesVec.clone(), (Vector)this.mapVec.clone());
    }

    public synchronized String toString() {
        String nullString = "(null)";
        StringBuffer buff = new StringBuffer();
        Iterator iterObj = ((AbstractList)this.keysVec).iterator();
        buff.append("{");
        if (iterObj.hasNext()) {
            while (true) {
                Object obj;
                if ((obj = iterObj.next()) != null) {
                    buff.append(obj.toString());
                } else {
                    buff.append("(null)");
                }
                buff.append("=");
                obj = this.hashMapObj.get(obj);
                if (obj != null) {
                    buff.append(obj.toString());
                } else {
                    buff.append("(null)");
                }
                if (!iterObj.hasNext()) break;
                buff.append(", ");
            }
        }
        buff.append("}");
        return buff.toString();
    }

    public synchronized Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(){
                        private final Iterator iterObj;
                        {
                            this.iterObj = ((AbstractList)FifoHashtable.this.keysVec).iterator();
                        }

                        public boolean hasNext() {
                            return this.iterObj.hasNext();
                        }

                        public Object next() {
                            return this.iterObj.next();
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public int size() {
                    return FifoHashtable.this.keysVec.size();
                }

                public boolean contains(Object o) {
                    return FifoHashtable.this.keysVec.contains(o);
                }
            };
        }
        return this.keySet;
    }

    public synchronized Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return new Iterator(){
                        private final Iterator iterObj;
                        {
                            this.iterObj = ((AbstractList)FifoHashtable.this.valuesVec).iterator();
                        }

                        public boolean hasNext() {
                            return this.iterObj.hasNext();
                        }

                        public Object next() {
                            return this.iterObj.next();
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public int size() {
                    return FifoHashtable.this.valuesVec.size();
                }

                public boolean contains(Object o) {
                    return FifoHashtable.this.valuesVec.contains(o);
                }
            };
        }
        return this.values;
    }

    public synchronized Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(){
                        private final Iterator iterObj;
                        {
                            this.iterObj = ((AbstractList)FifoHashtable.this.mapVec).iterator();
                        }

                        public boolean hasNext() {
                            return this.iterObj.hasNext();
                        }

                        public Object next() {
                            return this.iterObj.next();
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public boolean contains(Object o) {
                    return FifoHashtable.this.mapVec.contains(o);
                }

                public int size() {
                    return FifoHashtable.this.mapVec.size();
                }
            };
        }
        return this.entrySet;
    }

    public static class MapEntry
    implements Map.Entry {
        protected final Object key;
        protected final Object value;

        public MapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

