/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import com.isti.util.ArchiveManager;
import com.isti.util.IstiNotifyThread;
import com.isti.util.IstiThread;
import com.isti.util.UtilFns;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

public class ExtendedArchiveManager
extends ArchiveManager {
    protected final Vector archiveItemQueueVec = new Vector();
    protected final boolean strictArchiveDateFlag;
    protected static final Object archiveItemWTSyncObj = new Object();
    protected static ArchiveItemWorkerThread archiveItemWTObj = null;
    protected static final Object purgeWTSyncObj = new Object();
    protected static PurgeWorkerThread purgeWTObj = null;
    private boolean archiveItemQueueEnabled = false;
    private long archivePurgeAgeMilliSecs = 0L;
    private long archivePollTime = 0L;

    public ExtendedArchiveManager(Class classObj, String archiveRootDirName, String archiveFileNameStr, boolean strictArchiveDateFlag) throws NoSuchMethodException {
        super(classObj, archiveRootDirName, archiveFileNameStr);
        this.strictArchiveDateFlag = strictArchiveDateFlag;
        this.setLogPrefixString("ExtendedArchiveManager");
    }

    public ExtendedArchiveManager(Class classObj, String archiveRootDirName, String archiveFileNameStr) throws NoSuchMethodException {
        this(classObj, archiveRootDirName, archiveFileNameStr, true);
    }

    public ExtendedArchiveManager(Class classObj, String archiveFileNameStr) throws NoSuchMethodException {
        this(classObj, null, archiveFileNameStr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean archiveItem(Archivable item) throws IOException {
        Object object;
        if (!this.archiveItemQueueEnabled) {
            return super.archiveItem(item, this.strictArchiveDateFlag);
        }
        if (this.archiveClosedFlag) {
            return false;
        }
        if (this.strictArchiveDateFlag) {
            object = this.archiveAccessSyncObj;
            synchronized (object) {
                if (!this.checkItemArchiveDate(item)) {
                    return false;
                }
            }
        }
        object = this.archiveItemQueueVec;
        synchronized (object) {
            this.archiveItemQueueVec.add(item);
        }
        this.signalWorkerThread(archiveItemWTObj);
        return true;
    }

    public void closeArchive() {
        this.removeFromWorkerThread(archiveItemWTObj);
        this.removeFromWorkerThread(purgeWTObj);
        super.closeArchive();
    }

    public long getArchivePurgeAge() {
        return this.archivePurgeAgeMilliSecs;
    }

    public long getArchivePollTime() {
        return this.archivePollTime;
    }

    public boolean isArchiveItemQueueEnabled() {
        return this.archiveItemQueueEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArchiveItemQueueEnabled(boolean b) {
        if (this.archiveClosedFlag) {
            return;
        }
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.archiveItemQueueEnabled = b;
        }
        if (this.archiveItemQueueEnabled) {
            object = archiveItemWTSyncObj;
            synchronized (object) {
                if (archiveItemWTObj == null) {
                    archiveItemWTObj = new ArchiveItemWorkerThread(this.archivePollTime);
                }
            }
            this.addToWorkerThread(archiveItemWTObj);
        } else {
            this.removeFromWorkerThread(archiveItemWTObj);
        }
    }

    public void setArchivePollTime(long archivePollTime) {
        this.archivePollTime = archivePollTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArchivePurgeAge(long age) {
        if (this.archiveClosedFlag) {
            return;
        }
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.archivePurgeAgeMilliSecs = age;
        }
        if (this.archivePurgeAgeMilliSecs > 0L) {
            object = purgeWTSyncObj;
            synchronized (object) {
                if (purgeWTObj == null) {
                    purgeWTObj = new PurgeWorkerThread();
                }
            }
            this.addToWorkerThread(purgeWTObj);
        } else {
            this.removeFromWorkerThread(purgeWTObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminateWorkerThreads() {
        Object object = archiveItemWTSyncObj;
        synchronized (object) {
            if (archiveItemWTObj != null) {
                archiveItemWTObj.terminate();
            }
        }
        object = purgeWTSyncObj;
        synchronized (object) {
            if (purgeWTObj != null) {
                purgeWTObj.terminate();
            }
        }
    }

    protected void addToWorkerThread(AbstractWorkerThread wt) {
        if (wt != null) {
            wt.addArchiveManager(this);
        }
    }

    protected void archiveQueuedItem(Archivable item) throws IOException {
        super.archiveItem(item, false);
    }

    protected void signalWorkerThread(AbstractWorkerThread wt) {
        if (this.archivePollTime == 0L && wt != null) {
            wt.notifyThread();
        }
    }

    protected boolean purgeArchive(long currentTime) {
        if (this.archivePurgeAgeMilliSecs > 0L) {
            Date cutoffDate = new Date(currentTime - this.archivePurgeAgeMilliSecs);
            return this.purgeArchive(cutoffDate);
        }
        return false;
    }

    protected void removeFromWorkerThread(AbstractWorkerThread wt) {
        if (wt != null) {
            wt.removeArchiveManager(this);
        }
    }

    protected static class PurgeWorkerThread
    extends AbstractWorkerThread {
        protected static final long DEF_PURGE_SLEEPTIME = 60000L;

        public PurgeWorkerThread() {
            super("ExtendedArchiveManager.PurgeWorkerThread-" + IstiThread.nextThreadNum(), 60000L);
        }

        public void processArchiveManager(ExtendedArchiveManager am) {
            if (am.getArchivePurgeAge() > 0L) {
                long currentTime = System.currentTimeMillis();
                am.purgeArchive(currentTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            Object object = purgeWTSyncObj;
            synchronized (object) {
                purgeWTObj = null;
            }
            super.terminate();
        }
    }

    protected static class ArchiveItemWorkerThread
    extends AbstractWorkerThread {
        public ArchiveItemWorkerThread(long sleepTime) {
            super("ExtendedArchiveManager.ArchiveItemWorkerThread" + IstiThread.nextThreadNum(), sleepTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processArchiveManager(ExtendedArchiveManager am) {
            while (!this.isTerminated()) {
                if (am == null || am.archiveItemQueueVec.size() <= 0) {
                    return;
                }
                try {
                    am.archiveQueuedItem((Archivable)am.archiveItemQueueVec.firstElement());
                    Vector vector = am.archiveItemQueueVec;
                    synchronized (vector) {
                        am.archiveItemQueueVec.remove(0);
                    }
                }
                catch (IOException ex) {
                    if (am.getLogFile() != null) {
                        am.getLogFile().warning(am.getLogPrefixString() + ":  I/O error archiving item:  " + ex);
                        am.getLogFile().debug(UtilFns.getStackTraceString(ex));
                    }
                    return;
                }
                catch (Exception ex) {
                    if (am.getLogFile() != null) {
                        am.getLogFile().warning(am.getLogPrefixString() + ":  Error archiving item:  " + ex);
                        am.getLogFile().debug(UtilFns.getStackTraceString(ex));
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            Object object = archiveItemWTSyncObj;
            synchronized (object) {
                archiveItemWTObj = null;
            }
            super.terminate();
        }
    }

    protected static abstract class AbstractWorkerThread
    extends IstiNotifyThread {
        protected static final long DEF_WORKER_SLEEPTIME = 50000000000000L;
        protected final long sleepTime;
        protected Vector archiveManagerVector = new Vector();

        public AbstractWorkerThread(String name, long sleepTime) {
            super(name);
            this.sleepTime = sleepTime <= 0L ? 50000000000000L : sleepTime;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addArchiveManager(ExtendedArchiveManager am) {
            Vector vector = this.archiveManagerVector;
            synchronized (vector) {
                if (!this.archiveManagerVector.contains(am)) {
                    this.archiveManagerVector.add(am);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExtendedArchiveManager getArchiveManager(int index) {
            try {
                Vector vector = this.archiveManagerVector;
                synchronized (vector) {
                    return (ExtendedArchiveManager)this.archiveManagerVector.get(index);
                }
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumArchiveManagers() {
            Vector vector = this.archiveManagerVector;
            synchronized (vector) {
                return this.archiveManagerVector.size();
            }
        }

        public abstract void processArchiveManager(ExtendedArchiveManager var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeArchiveManager(ExtendedArchiveManager am) {
            int numArchiveManagers;
            Vector vector = this.archiveManagerVector;
            synchronized (vector) {
                this.archiveManagerVector.remove(am);
                numArchiveManagers = this.archiveManagerVector.size();
            }
            if (numArchiveManagers <= 0) {
                this.terminate();
            }
        }

        public void run() {
            block0: while (!this.isTerminated()) {
                this.waitForNotify(this.sleepTime);
                if (this.isTerminated()) {
                    return;
                }
                int numArchiveManagers = this.getNumArchiveManagers();
                for (int i = 0; i < numArchiveManagers; ++i) {
                    if (this.isTerminated()) {
                        return;
                    }
                    ExtendedArchiveManager am = this.getArchiveManager(i);
                    if (am == null) continue block0;
                    if (this.isTerminated()) {
                        return;
                    }
                    this.processArchiveManager(am);
                }
            }
        }
    }
}

