/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

public class CircularBuffer {
    protected Object[] bufferObjsArray;
    protected int allocBufferSize;
    protected int bufferPosition = 0;
    protected long totalItemsCounter = 0L;

    public CircularBuffer(int bufferSize) {
        this.setBufferSize(bufferSize);
    }

    public final void setBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size not positive");
        }
        this.allocBufferSize = bufferSize;
        this.bufferObjsArray = new Object[this.allocBufferSize];
    }

    public void add(Object obj) {
        this.bufferObjsArray[this.bufferPosition] = obj;
        if (++this.bufferPosition >= this.allocBufferSize) {
            this.bufferPosition = 0;
        }
        ++this.totalItemsCounter;
    }

    public Object[] getBufferItems() {
        Object[] retArr;
        if (this.totalItemsCounter <= (long)this.allocBufferSize) {
            int bufSize = (int)this.totalItemsCounter;
            retArr = new Object[bufSize];
            System.arraycopy(this.bufferObjsArray, 0, retArr, 0, bufSize);
        } else {
            retArr = new Object[this.allocBufferSize];
            int pos = this.bufferPosition;
            int retIdx = 0;
            while (true) {
                retArr[retIdx] = this.bufferObjsArray[pos];
                if (++retIdx >= this.allocBufferSize) break;
                if (++pos < this.allocBufferSize) continue;
                pos = 0;
            }
        }
        return retArr;
    }

    public String[] getStrBufferItems() {
        String[] retArr;
        if (this.totalItemsCounter <= (long)this.allocBufferSize) {
            int bufSize = (int)this.totalItemsCounter;
            retArr = new String[bufSize];
            for (int idx = 0; idx < bufSize; ++idx) {
                retArr[idx] = this.bufferObjsArray[idx].toString();
            }
        } else {
            retArr = new String[this.allocBufferSize];
            int pos = this.bufferPosition;
            int retIdx = 0;
            while (true) {
                retArr[retIdx] = this.bufferObjsArray[pos].toString();
                if (++retIdx >= this.allocBufferSize) break;
                if (++pos < this.allocBufferSize) continue;
                pos = 0;
            }
        }
        return retArr;
    }

    public String getBufferItemsAsString(String sepStr) {
        if (sepStr == null) {
            sepStr = "";
        }
        String[] strArr = this.getStrBufferItems();
        StringBuffer buff = new StringBuffer();
        if (strArr.length > 0) {
            int idx = 0;
            while (true) {
                buff.append(strArr[idx]);
                if (++idx >= strArr.length) break;
                buff.append(sepStr);
            }
        }
        return buff.toString();
    }

    public long getTotalItemsCount() {
        return this.totalItemsCounter;
    }

    public boolean contains(Object obj) {
        int chkSize;
        int n = chkSize = (long)this.allocBufferSize < this.totalItemsCounter ? this.allocBufferSize : (int)this.totalItemsCounter;
        if (obj != null) {
            for (int pos = 0; pos < chkSize; ++pos) {
                if (!obj.equals(this.bufferObjsArray[pos])) continue;
                return true;
            }
        } else {
            for (int pos = 0; pos < chkSize; ++pos) {
                if (this.bufferObjsArray[pos] != null) continue;
                return true;
            }
        }
        return false;
    }
}

