/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.util.Arrays;
import java.util.Vector;

public class CfgPropValidator {
    public final Comparable minValueCompObj;
    public final Comparable maxValueCompObj;
    public final Object[] validValuesArr;
    public final Vector validValuesVec;
    public final String allowedChars;

    public CfgPropValidator(Comparable minValueCompObj, Comparable maxValueCompObj) {
        this.minValueCompObj = minValueCompObj;
        this.maxValueCompObj = maxValueCompObj;
        this.validValuesArr = null;
        this.validValuesVec = null;
        this.allowedChars = null;
    }

    public CfgPropValidator(Object[] objArr) {
        Vector<Object> vec;
        this.validValuesArr = objArr;
        if (objArr != null) {
            try {
                vec = new Vector<Object>(Arrays.asList(objArr));
            }
            catch (Exception ex) {
                vec = new Vector();
            }
        } else {
            vec = new Vector();
        }
        this.validValuesVec = vec;
        this.maxValueCompObj = null;
        this.minValueCompObj = null;
        this.allowedChars = null;
    }

    public CfgPropValidator(String allowedChars) {
        this.maxValueCompObj = null;
        this.minValueCompObj = null;
        this.validValuesArr = null;
        this.validValuesVec = null;
        this.allowedChars = allowedChars;
    }

    public boolean validateValue(Object valueObj) {
        if (this.validValuesVec != null) {
            return this.validValuesVec.indexOf(valueObj) >= 0;
        }
        if (valueObj == null) {
            return false;
        }
        if (this.allowedChars != null) {
            String str = valueObj.toString();
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (this.allowedChars.indexOf(ch) >= 0) continue;
                return false;
            }
        }
        try {
            if (this.minValueCompObj != null && this.minValueCompObj.compareTo(valueObj) > 0) {
                return false;
            }
            if (this.maxValueCompObj != null && this.maxValueCompObj.compareTo(valueObj) < 0) {
                return false;
            }
        }
        catch (ClassCastException ex) {
            return false;
        }
        return true;
    }

    public boolean isMinimumNonNegative() {
        return this.minValueCompObj instanceof Number && ((Number)((Object)this.minValueCompObj)).doubleValue() >= 0.0;
    }
}

