/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.ILaunchBrowser;
import com.isti.util.UtilFns;
import java.net.URI;

public class BasicLaunchBrowser
implements ILaunchBrowser {
    private static String osName = null;
    public static final String[] WEB_BROWSERS = new String[]{"google-chrome", "firefox", "mozilla", "netscape"};
    private final String[] browsers;
    private final boolean useDesktopFlag;
    private String errorMessage = null;
    private String[] cmdarray = null;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$lang$String;

    public BasicLaunchBrowser() {
        this(WEB_BROWSERS, BasicLaunchBrowser.isDesktopAvailable());
    }

    public BasicLaunchBrowser(String[] browsers, boolean useDesktopFlag) {
        this.browsers = browsers;
        this.useDesktopFlag = useDesktopFlag;
    }

    public static void browse(String urlStr) throws Exception {
        Class<?> d = Class.forName("java.awt.Desktop");
        d.getDeclaredMethod("browse", class$java$net$URI == null ? (class$java$net$URI = BasicLaunchBrowser.class$("java.net.URI")) : class$java$net$URI).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(urlStr));
    }

    public String getErrorMessage() {
        return this.errorMessage != null ? this.errorMessage : "No error";
    }

    public static boolean isDesktopAvailable() {
        return BasicLaunchBrowser.isDesktopAvailable(UtilFns.getJavaVersion());
    }

    public static boolean isDesktopAvailable(String javaVersionString) {
        if (!javaVersionString.equals("(Unknown)")) {
            return UtilFns.compareVersionStrings(javaVersionString, "1.6") > 0;
        }
        return false;
    }

    public boolean showURL(String urlStr) {
        return this.showURL(urlStr, null);
    }

    public boolean showURL(String urlStr, String titleStr) {
        if (this.useDesktopFlag) {
            try {
                BasicLaunchBrowser.browse(urlStr);
                return true;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.errorMessage = null;
        if (osName == null) {
            osName = System.getProperty("os.name");
        }
        try {
            if (this.cmdarray != null) {
                this.errorMessage = this.launch(urlStr);
            } else if (osName.startsWith("Mac OS")) {
                Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", class$java$lang$String == null ? (class$java$lang$String = BasicLaunchBrowser.class$("java.lang.String")) : class$java$lang$String).invoke(null, urlStr);
            } else if (osName.startsWith("Windows")) {
                this.cmdarray = new String[]{"rundll32", "url.dll,FileProtocolHandler", urlStr};
                this.errorMessage = this.launch();
            } else {
                for (int i = 0; i < this.browsers.length; ++i) {
                    String browser = this.browsers[i];
                    if (Runtime.getRuntime().exec(new String[]{"which", browser}).getInputStream().read() == -1) continue;
                    this.cmdarray = new String[]{browser, urlStr};
                    this.errorMessage = this.launch();
                    break;
                }
                if (this.cmdarray == null) {
                    this.errorMessage = "Could not find a browser: " + UtilFns.toString(this.browsers);
                }
            }
        }
        catch (Exception ex) {
            this.errorMessage = "Error attempting to launch web browser\n" + ex.toString();
        }
        return this.errorMessage == null;
    }

    protected String launch() {
        try {
            Runtime.getRuntime().exec(this.cmdarray);
        }
        catch (Exception ex) {
            return "Runtime.exec(" + UtilFns.toString(this.cmdarray) + ") exception:  " + ex;
        }
        return null;
    }

    protected String launch(String urlStr) {
        this.cmdarray[this.cmdarray.length - 1] = urlStr;
        return this.launch();
    }

    public static void main(String[] args) {
        String s;
        String javaVersionString = UtilFns.getJavaVersion();
        boolean useDesktopFlag = BasicLaunchBrowser.isDesktopAvailable(javaVersionString);
        System.out.println((useDesktopFlag ? "" : "not ") + "using desktop (" + javaVersionString + ")");
        BasicLaunchBrowser ilb = new BasicLaunchBrowser(WEB_BROWSERS, useDesktopFlag);
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String urlStr = args[i];
                System.out.println("showing \"" + urlStr + "\" ...");
                if (ilb.showURL(urlStr)) continue;
                System.err.println("error showing URL: " + urlStr);
                break;
            }
        } else {
            String urlStr = "http://www.google.com";
            System.out.println("showing \"" + urlStr + "\" ...");
            if (!ilb.showURL(urlStr)) {
                System.err.println("error showing URL: " + urlStr);
            }
        }
        if ((s = UtilFns.toString(ilb.cmdarray)) != "null") {
            System.out.print(s + ": ");
        }
        System.out.println(ilb.getErrorMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

