/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.cmdline.args.AbstractOutputTypeArgs;
import java.io.File;
import picocli.CommandLine;

public class GraphicOutputTypeArgs
extends AbstractOutputTypeArgs {
    @CommandLine.ArgGroup(heading="Output Type:%n")
    GraphicsOutputType outputType = new GraphicsOutputType();
    public String psFile = null;
    @CommandLine.Option(names={"--mapwidth"}, description={"plot width in units from --mapwidthunit."})
    public Float mapwidth = Float.valueOf(6.0f);
    @CommandLine.Option(names={"--mapwidthunit"}, defaultValue="i", description={"plot width unit, i for inch, c for cm or p for px."})
    public String mapWidthUnit = "i";

    public GraphicOutputTypeArgs(String defaultFormat, String filebase) {
        super(filebase);
        this.setOutputFormat(defaultFormat);
    }

    public String getGmtOutFileBase(String toolName) {
        if (this.psFile != null) {
            return this.psFile;
        }
        String base = this.getOutFileBase();
        if (base.equals("-") || base.equals("stdout")) {
            base = toolName;
        } else if (base.contains(File.separator)) {
            File tosplit = new File(base);
            base = tosplit.getName();
        }
        if (base.endsWith(".gmt")) {
            base = base.substring(0, base.length() - 4);
        }
        return base;
    }

    public void setPsFile(String psFile) {
        this.psFile = psFile;
    }

    public Float getMapwidth() {
        return this.mapwidth;
    }

    public void setMapwidth(Float mapwidth) {
        this.mapwidth = mapwidth;
    }

    public String getMapWidthUnit() {
        return this.mapWidthUnit;
    }

    public void setMapWidthUnit(String mapWidthUnit) {
        this.mapWidthUnit = mapWidthUnit;
    }

    public String mapWidthGMT() {
        return this.mapwidth + this.mapWidthUnit;
    }

    public boolean isText() {
        return this.outputType._isText;
    }

    public boolean isSVG() {
        return this.outputType._isSVG;
    }

    public boolean isHTML() {
        return this.outputType._isHTML;
    }

    public boolean isGMT() {
        return this.outputType._isGMT;
    }

    public boolean isJSON() {
        return this.outputType._isJSON;
    }

    @Override
    public void setOutputFormat(String oType) {
        this.outputType._isText = false;
        this.outputType._isJSON = false;
        this.outputType._isGMT = false;
        this.outputType._isSVG = false;
        this.outputType._isHTML = false;
        if (oType.equalsIgnoreCase("text")) {
            this.outputType._isText = true;
        } else if (oType.equalsIgnoreCase("json")) {
            this.outputType._isJSON = true;
        } else if (oType.equalsIgnoreCase("gmt")) {
            this.outputType._isGMT = true;
            if (this.mapwidth == null) {
                this.mapwidth = Float.valueOf(6.0f);
            }
        } else if (oType.equalsIgnoreCase("svg") || oType.equalsIgnoreCase("html")) {
            if (oType.equalsIgnoreCase("svg")) {
                this.outputType._isSVG = true;
            } else {
                this.outputType._isHTML = true;
            }
            if (this.mapwidth == null) {
                this.mapwidth = Float.valueOf(1000.0f);
            }
        } else {
            throw new IllegalArgumentException("output type " + oType + " not recognized.");
        }
    }

    @Override
    public String getOutputFormat() {
        if (this.isGMT()) {
            return "gmt";
        }
        if (this.isSVG()) {
            return "svg";
        }
        if (this.isHTML()) {
            return "html";
        }
        if (this.isJSON()) {
            return "json";
        }
        return "text";
    }

    @Override
    public String getOutFileExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        String ext = "text";
        if (this.isSVG()) {
            ext = "svg";
        } else if (this.isHTML()) {
            ext = "html";
        } else if (this.isJSON()) {
            ext = "json";
        } else if (this.isGMT()) {
            ext = "gmt";
        }
        return ext;
    }

    public float getPixelWidth() {
        return GraphicOutputTypeArgs.getPixelWidth(this.mapwidth.floatValue(), this.mapWidthUnit);
    }

    public static float getPixelWidth(float mapwidth, String mapWidthUnit) {
        if (mapWidthUnit.equals("i")) {
            return 96.0f * mapwidth;
        }
        if (mapWidthUnit.equals("c")) {
            return 37.795277f * mapwidth;
        }
        if (mapWidthUnit.equals("p") || mapwidth > 100.0f) {
            return mapwidth;
        }
        return 1000.0f;
    }

    static class GraphicsOutputType {
        @CommandLine.Option(names={"--text"}, required=true, description={"outputs as Text"})
        boolean _isText = false;
        @CommandLine.Option(names={"--json"}, required=true, description={"outputs as JSON"})
        boolean _isJSON = false;
        @CommandLine.Option(names={"--gmt"}, required=true, description={"outputs as GMT"})
        boolean _isGMT = false;
        @CommandLine.Option(names={"--svg"}, required=true, description={"outputs as SVG"})
        boolean _isSVG = false;
        @CommandLine.Option(names={"--html"}, required=true, description={"outputs as SVG in HTML"})
        boolean _isHTML = false;

        GraphicsOutputType() {
        }
    }
}

