/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.DepthAxisType;
import edu.sc.seis.TauP.DistanceAxisType;
import edu.sc.seis.TauP.LinearInterpolation;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SvgEarth;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.cmdline.args.DistDepthRange;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPathSegment {
    List<TimeDist> path;
    boolean isPWave;
    String segmentName;
    SeismicPhase phase;
    TimeDist prevEnd;
    int segmentIndex;
    int totalNumSegments;
    String pathCssClass = "path";

    public AbstractPathSegment(List<TimeDist> path, boolean isPWave, String segmentName, TimeDist prevEnd, int segmentIndex, int totalNumSegments, SeismicPhase phase) {
        this.path = path;
        this.isPWave = isPWave;
        this.segmentName = segmentName;
        this.prevEnd = prevEnd;
        this.segmentIndex = segmentIndex;
        this.totalNumSegments = totalNumSegments;
        this.phase = phase;
    }

    public static ArrivalPathSegment linearInterpPath(ArrivalPathSegment segPath, double maxPathInc, double maxPathTime) {
        TimeDist prevEnd = null;
        ArrayList<TimeDist> out = new ArrayList<TimeDist>();
        double calcTime = 0.0;
        double calcDist = 0.0;
        for (TimeDist td : segPath.path) {
            double calcDepth;
            if (prevEnd != null && prevEnd.getP() != 0.0 && Math.abs(prevEnd.getDistDeg() - td.getDistDeg()) > maxPathInc) {
                int maxInterpNum = (int)Math.ceil(Math.abs(td.getDistDeg() - prevEnd.getDistDeg()) / maxPathInc);
                for (int interpNum = 1; interpNum < maxInterpNum && calcTime < maxPathTime && !((calcTime += (td.getTime() - prevEnd.getTime()) / (double)maxInterpNum) > maxPathTime); ++interpNum) {
                    calcDepth = prevEnd.getDepth() + (double)interpNum * (td.getDepth() - prevEnd.getDepth()) / (double)maxInterpNum;
                    out.add(new TimeDist(prevEnd.getP(), calcTime, (calcDist += (td.getDistDeg() - prevEnd.getDistDeg()) / (double)maxInterpNum) * (Math.PI / 180), calcDepth));
                }
            }
            calcTime = td.getTime();
            calcDepth = td.getDepth();
            calcDist = td.getDistDeg();
            if (calcTime > maxPathTime) {
                if (prevEnd == null || !(prevEnd.getTime() < maxPathTime)) break;
                calcDist = LinearInterpolation.linearInterp(prevEnd.getTime(), prevEnd.getDistDeg(), td.getTime(), td.getDistDeg(), maxPathTime);
                calcDepth = LinearInterpolation.linearInterp(prevEnd.getTime(), prevEnd.getDepth(), td.getTime(), td.getDepth(), maxPathTime);
                calcTime = maxPathTime;
            }
            out.add(new TimeDist(td.getP(), calcTime, calcDist * (Math.PI / 180), calcDepth));
            prevEnd = td;
        }
        return new ArrivalPathSegment(out, segPath.isPWave, segPath.segmentName, segPath.prevEnd, segPath.arrival, segPath.phaseSegment, segPath.segmentIndex, segPath.totalNumSegments);
    }

    public static List<TimeDist> trimDuplicates(List<TimeDist> tdList) {
        if (tdList.size() < 3) {
            return tdList;
        }
        TimeDist prev = null;
        ArrayList<TimeDist> out = new ArrayList<TimeDist>();
        for (TimeDist td : tdList) {
            if (!td.equals(prev)) {
                out.add(td);
            }
            prev = td;
        }
        return out;
    }

    public TimeDist getPathEnd() {
        if (!this.path.isEmpty()) {
            return this.path.get(this.path.size() - 1);
        }
        return this.prevEnd;
    }

    public TimeDist getPathStart() {
        if (!this.path.isEmpty()) {
            return this.path.get(0);
        }
        return this.prevEnd;
    }

    public List<TimeDist> negativeDistance() {
        ArrayList<TimeDist> out = new ArrayList<TimeDist>();
        for (TimeDist td : this.path) {
            out.add(new TimeDist(td.getP(), td.getTime(), -1.0 * td.getDistRadian(), td.getDepth()));
        }
        return out;
    }

    public List<TimeDist> getPath() {
        return this.path;
    }

    public SeismicPhase getPhase() {
        return this.phase;
    }

    public boolean isPWave() {
        return this.isPWave;
    }

    public String getWavetypeStr() {
        return this.isPWave ? "pwave" : "swave";
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public TimeDist getPathPoint(int i) {
        return this.path.get(i);
    }

    public abstract String description();

    public JsonObject asJsonObject() {
        return this.asJsonObject(null);
    }

    public JsonObject asJsonObject(Arrival arrival) {
        JsonObject a = new JsonObject();
        a.addProperty("name", this.segmentName);
        a.addProperty("wavetype", this.isPWave ? "pwave" : "swave");
        JsonArray points = new JsonArray();
        a.add("segment", (JsonElement)points);
        for (TimeDist td : this.path) {
            JsonArray tdItems = new JsonArray();
            points.add((JsonElement)tdItems);
            tdItems.add((Number)Float.valueOf((float)td.getDistDeg()));
            tdItems.add((Number)Float.valueOf((float)td.getDepth()));
            tdItems.add((Number)Float.valueOf((float)td.getTime()));
            if (arrival == null || !arrival.isLatLonable()) continue;
            double[] latlon = arrival.getLatLonable().calcLatLon(td.getDistDeg(), arrival.getDistDeg());
            tdItems.add((Number)Float.valueOf((float)latlon[0]));
            tdItems.add((Number)Float.valueOf((float)latlon[1]));
        }
        return a;
    }

    public String getCssClasses() {
        return this.pathCssClass + " " + SvgUtil.classForPhase(this.getPhase().getName()) + (this.isPWave ? " pwave" : " swave");
    }

    public void writeSVGCartesian(PrintWriter pw) {
        this.writeSVGCartesian(pw, 0.0);
    }

    public void writeSVGCartesian(PrintWriter pw, double minPolylineSize) {
        double radiusOfEarth = this.getPhase().getTauModel().getRadiusOfEarth();
        pw.println("    <g>");
        pw.println("      <desc>" + this.description() + "</desc>");
        boolean isDegenerate = this.path.size() <= 2;
        double[] prevXY = SvgEarth.xyForDistRadius(this.path.get(0).getDistDeg(), radiusOfEarth - this.path.get(0).getDepth());
        if (minPolylineSize > 0.0) {
            for (TimeDist td : this.path) {
                double[] xy = SvgEarth.xyForDistRadius(td.getDistDeg(), radiusOfEarth - td.getDepth());
                if (Math.abs(xy[0] - prevXY[0]) > minPolylineSize || Math.abs(xy[1] - prevXY[1]) > minPolylineSize) {
                    isDegenerate = false;
                    break;
                }
                isDegenerate = true;
            }
        }
        if (isDegenerate) {
            TimeDist td = this.path.get(0);
            double[] xy = SvgEarth.xyForDistRadius(td.getDistDeg(), radiusOfEarth - td.getDepth());
            pw.println("      <circle class=\"" + this.getCssClasses() + "\" cx=\"" + xy[0] + "\" cy=\"" + xy[1] + "\" r=\"" + minPolylineSize + "\"/>");
        } else {
            pw.println("      <polyline class=\"" + this.getCssClasses() + "\" points=\"");
            String prevLine = "";
            for (TimeDist td : this.path) {
                String line = SvgEarth.formatDistRadiusAsXY(td.getDistDeg(), radiusOfEarth - td.getDepth());
                if (!line.equals(prevLine)) {
                    pw.println(line);
                }
                prevLine = line;
            }
            pw.println("\" />");
        }
        pw.println("    </g>");
    }

    public String gmtTextLine(TimeDist td, DistDepthRange distDepthRange, String xFormat, String yFormat, boolean withTime, DistanceAxisType distanceAxisType, DepthAxisType depthAxisType) {
        return this.gmtTextLine(td, distDepthRange, xFormat, yFormat, withTime, false, distanceAxisType, depthAxisType);
    }

    public String gmtTextLine(TimeDist td, DistDepthRange distDepthRange, String xFormat, String yFormat, boolean withTime, boolean withLatLon, DistanceAxisType distanceAxisType, DepthAxisType depthAxisType) {
        double yVal;
        double xVal;
        double R = this.getPhase().getTauModel().getRadiusOfEarth();
        switch (distanceAxisType) {
            case radian: {
                xVal = td.getDistRadian();
                break;
            }
            case kilometer: {
                xVal = R * td.getDistRadian();
                break;
            }
            default: {
                xVal = td.getDistDeg();
            }
        }
        switch (depthAxisType) {
            case depth: {
                yVal = td.getDepth();
                break;
            }
            default: {
                yVal = R - td.getDepth();
            }
        }
        String line = String.format(xFormat, xVal) + "  " + String.format(yFormat, yVal);
        if (withTime) {
            line = line + " " + Outputs.formatTime(td.getTime());
        }
        return line;
    }

    public void writeGMTText(PrintWriter pw, DistDepthRange distDepthRange, String xFormat, String yFormat, boolean withTime, boolean withLatLon) {
        DistanceAxisType distanceAxisType = distDepthRange.distAxisType != null ? distDepthRange.distAxisType : DistanceAxisType.degree;
        DepthAxisType depthAxisType = distDepthRange.depthAxisType != null ? distDepthRange.depthAxisType : DepthAxisType.radius;
        pw.println("> " + this.description());
        double R = this.getPhase().getTauModel().getRadiusOfEarth();
        String prevLine = "";
        for (TimeDist td : this.path) {
            String line = this.gmtTextLine(td, distDepthRange, xFormat, yFormat, withTime, withLatLon, distanceAxisType, depthAxisType);
            if (!line.equals(prevLine)) {
                pw.println(line);
            }
            prevLine = line;
        }
    }
}

