/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import edu.sc.seis.seisFile.fdsnws.quakeml.WaveformStreamID;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StationMagnitude {
    public static final String ELEMENT_NAME = "stationMagnitude";
    private String originId;
    private RealQuantity mag;
    private String type;
    private String methodID;
    private WaveformStreamID waveformID;
    private String amplitudeID;
    private String publicId;
    CreationInfo creationInfo;
    List<Comment> commentList = new ArrayList<Comment>();

    public StationMagnitude(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        this.publicId = StaxUtil.pullAttribute(startE, "publicID");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("originID")) {
                    this.originId = StaxUtil.pullText(reader, "originID");
                    continue;
                }
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("amplitudeID")) {
                    this.amplitudeID = StaxUtil.pullText(reader, "amplitudeID");
                    continue;
                }
                if (elName.equals("type")) {
                    this.type = StaxUtil.pullText(reader, "type");
                    continue;
                }
                if (elName.equals("mag")) {
                    this.mag = new RealQuantity(reader, "mag");
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                if (elName.equals("methodID")) {
                    this.methodID = StaxUtil.pullText(reader, "methodID");
                    continue;
                }
                if (elName.equals("waveformID")) {
                    this.waveformID = new WaveformStreamID(reader, "waveformID");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getAmplitudeID() {
        return this.amplitudeID;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public RealQuantity getMag() {
        return this.mag;
    }

    public String getMethodID() {
        return this.methodID;
    }

    public String getOriginId() {
        return this.originId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getType() {
        return this.type;
    }

    public WaveformStreamID getWaveformID() {
        return this.waveformID;
    }

    public void setAmplitudeID(String amplitudeID) {
        this.amplitudeID = amplitudeID;
    }

    public void setCommentList(List<Comment> commentList) {
        this.commentList = commentList;
    }

    public void setCreationInfo(CreationInfo creationInfo) {
        this.creationInfo = creationInfo;
    }

    public void setMag(RealQuantity mag) {
        this.mag = mag;
    }

    public void setMethodID(String methodID) {
        this.methodID = methodID;
    }

    public void setOriginId(String originId) {
        this.originId = originId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setWaveformID(WaveformStreamID waveformID) {
        this.waveformID = waveformID;
    }
}

