/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import edu.sc.seis.TauP.NamedVelocityDiscon;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import java.lang.reflect.Type;

public class VelocityModelSerializer
implements JsonSerializer<VelocityModel> {
    public JsonElement serialize(VelocityModel vmod, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("modelName", vmod.getModelName());
        json.addProperty("radiusOfEarth", (Number)vmod.getRadiusOfEarth());
        JsonArray ndArr = new JsonArray(vmod.getNamedDiscons().size());
        json.add("nameddisons", (JsonElement)ndArr);
        for (NamedVelocityDiscon nd : vmod.getNamedDiscons()) {
            ndArr.add((JsonElement)nd.asJSON());
        }
        json.addProperty("minRadius", (Number)vmod.getMinRadius());
        json.addProperty("maxRadius", (Number)vmod.getMaxRadius());
        json.addProperty("spherical", Boolean.valueOf(vmod.getSpherical()));
        JsonArray layers = new JsonArray();
        json.add("layers", (JsonElement)layers);
        for (VelocityLayer vl : vmod.getLayers()) {
            layers.add(context.serialize((Object)vl));
        }
        return json;
    }
}

