/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.AbstractPathSegment;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TimeDist;
import java.util.List;

public class WavefrontPathSegment
extends AbstractPathSegment {
    double timeVal;

    public WavefrontPathSegment(List<TimeDist> path, boolean isPWave, String segmentName, TimeDist prevEnd, int segmentIndex, int totalNumSegments, SeismicPhase phase, double timeVal) {
        super(path, isPWave, segmentName, prevEnd, segmentIndex, totalNumSegments, phase);
        this.timeVal = timeVal;
        this.pathCssClass = "wavefront";
    }

    public static WavefrontPathSegment degenerateSegment(TimeDist pathPoint, boolean isPWave, String segmentName, TimeDist prevEnd, int segmentIndex, int totalNumSegments, SeismicPhase phase, double timeVal) {
        List<TimeDist> path = List.of(pathPoint);
        return new WavefrontPathSegment(path, isPWave, segmentName, prevEnd, segmentIndex, totalNumSegments, phase, timeVal);
    }

    @Override
    public String description() {
        return "seg " + this.segmentIndex + "/" + this.totalNumSegments + " " + this.segmentName + " of " + this.phase.getName() + " at " + Outputs.formatTimeNoPad(this.timeVal);
    }

    @Override
    public String getCssClasses() {
        return super.getCssClasses() + " " + SvgUtil.formatTimeForCss(this.timeVal);
    }

    public WavefrontPathSegment asNegativeDistance() {
        return new WavefrontPathSegment(this.negativeDistance(), this.isPWave, this.segmentName, this.prevEnd, this.segmentIndex, this.totalNumSegments, this.phase, this.timeVal);
    }

    public double getTimeVal() {
        return this.timeVal;
    }
}

