/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LinearInterpolation;
import edu.sc.seis.TauP.VelocityModelMaterial;
import java.io.Serializable;

public class VelocityLayer
implements Cloneable,
Serializable {
    private int myLayerNumber;
    private double topDepth;
    private double botDepth;
    private double topPVelocity;
    private double botPVelocity;
    private double topSVelocity;
    private double botSVelocity;
    private double topDensity;
    private double botDensity;
    private double topQp;
    private double botQp;
    private double topQs;
    private double botQs;
    public static double DEFAULT_DENSITY = 2.6;
    public static double DEFAULT_QP = 1000.0;
    public static double DEFAULT_QS = 500.0;

    public VelocityLayer(int myLayerNumber, double topDepth, double botDepth, double topPVelocity, double botPVelocity, double topSVelocity, double botSVelocity) {
        this(myLayerNumber, topDepth, botDepth, topPVelocity, botPVelocity, topSVelocity, botSVelocity, DEFAULT_DENSITY, DEFAULT_DENSITY);
    }

    public VelocityLayer(int myLayerNumber, double topDepth, double botDepth, double topPVelocity, double botPVelocity, double topSVelocity, double botSVelocity, double topDensity, double bottomDensity) {
        this(myLayerNumber, topDepth, botDepth, topPVelocity, botPVelocity, topSVelocity, botSVelocity, topDensity, bottomDensity, DEFAULT_QP, DEFAULT_QP, DEFAULT_QS, DEFAULT_QS);
    }

    public VelocityLayer(int myLayerNumber, double topDepth, double botDepth, double topPVelocity, double botPVelocity, double topSVelocity, double botSVelocity, double topDensity, double botDensity, double topQp, double botQp, double topQs, double botQs) {
        if (topPVelocity <= 0.0) {
            throw new IllegalArgumentException("topPVelocity must be positive: " + topPVelocity + " in layer " + myLayerNumber + " topDepth " + topDepth + " topS" + topSVelocity + " botDepth " + botDepth + " botP " + botPVelocity + " botS" + botSVelocity);
        }
        if (botPVelocity <= 0.0) {
            throw new IllegalArgumentException("botPVelocity must be positive: " + botPVelocity);
        }
        if (topSVelocity < 0.0) {
            throw new IllegalArgumentException("topSVelocity must be nonnegative: " + topSVelocity);
        }
        if (botSVelocity < 0.0) {
            throw new IllegalArgumentException("botSVelocity must be nonnegative: " + botSVelocity);
        }
        this.myLayerNumber = myLayerNumber;
        this.topDepth = topDepth;
        this.botDepth = botDepth;
        this.topPVelocity = topPVelocity;
        this.botPVelocity = botPVelocity;
        this.topSVelocity = topSVelocity;
        this.botSVelocity = botSVelocity;
        this.topDensity = topDensity;
        this.botDensity = botDensity;
        this.topQp = topQp;
        this.botQp = botQp;
        this.topQs = topQs;
        this.botQs = botQs;
    }

    public Object clone() {
        try {
            VelocityLayer newObject = (VelocityLayer)super.clone();
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public VelocityLayer cloneRenumber(int layerNum) {
        try {
            VelocityLayer newObject = (VelocityLayer)super.clone();
            newObject.myLayerNumber = layerNum;
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public double evaluateAtBottom(VelocityModelMaterial materialProperty) {
        double answer;
        switch (materialProperty) {
            case P_VELOCITY: {
                answer = this.getBotPVelocity();
                break;
            }
            case S_VELOCITY: {
                answer = this.getBotSVelocity();
                break;
            }
            case DENSITY: {
                answer = this.getBotDensity();
                break;
            }
            case Q_P: {
                answer = this.getBotQp();
                break;
            }
            case Q_S: {
                answer = this.getBotQs();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mat prop: " + String.valueOf((Object)materialProperty));
            }
        }
        return answer;
    }

    public double evaluateAtTop(VelocityModelMaterial materialProperty) {
        double answer;
        switch (materialProperty) {
            case P_VELOCITY: {
                answer = this.getTopPVelocity();
                break;
            }
            case S_VELOCITY: {
                answer = this.getTopSVelocity();
                break;
            }
            case DENSITY: {
                answer = this.getTopDensity();
                break;
            }
            case Q_P: {
                answer = this.getTopQp();
                break;
            }
            case Q_S: {
                answer = this.getTopQs();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mat prop: " + String.valueOf((Object)materialProperty));
            }
        }
        return answer;
    }

    public double evaluateAt(double depth, VelocityModelMaterial materialProperty) {
        double topY;
        double botY;
        switch (materialProperty) {
            case P_VELOCITY: {
                botY = this.getBotPVelocity();
                topY = this.getTopPVelocity();
                break;
            }
            case S_VELOCITY: {
                botY = this.getBotSVelocity();
                topY = this.getTopSVelocity();
                break;
            }
            case DENSITY: {
                botY = this.getBotDensity();
                topY = this.getTopDensity();
                break;
            }
            case Q_P: {
                botY = this.getBotQp();
                topY = this.getTopQp();
                break;
            }
            case Q_S: {
                botY = this.getBotQs();
                topY = this.getTopQs();
                break;
            }
            default: {
                throw new IllegalArgumentException("I don't understand this material property: " + String.valueOf((Object)materialProperty));
            }
        }
        return LinearInterpolation.linearInterp(this.getBotDepth(), botY, this.getTopDepth(), topY, depth);
    }

    public String toString() {
        String description = this.myLayerNumber + " " + this.getTopDepth() + " " + this.getBotDepth();
        description = description + " P " + this.getTopPVelocity() + " " + this.getBotPVelocity();
        description = description + " S " + this.getTopSVelocity() + " " + this.getBotSVelocity();
        description = description + " Density " + this.getTopDensity() + " " + this.getBotDensity();
        return description;
    }

    public int getLayerNum() {
        return this.myLayerNumber;
    }

    public void setTopDepth(double topDepth) {
        this.topDepth = topDepth;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public void setBotDepth(double botDepth) {
        this.botDepth = botDepth;
    }

    public double getBotDepth() {
        return this.botDepth;
    }

    public void setTopPVelocity(double topPVelocity) {
        this.topPVelocity = topPVelocity;
    }

    public double getTopPVelocity() {
        return this.topPVelocity;
    }

    public void setBotPVelocity(double botPVelocity) {
        this.botPVelocity = botPVelocity;
    }

    public double getBotPVelocity() {
        return this.botPVelocity;
    }

    public void setTopSVelocity(double topSVelocity) {
        this.topSVelocity = topSVelocity;
    }

    public double getTopSVelocity() {
        return this.topSVelocity;
    }

    public boolean isFluid() {
        return this.getTopSVelocity() == 0.0;
    }

    public void setBotSVelocity(double botSVelocity) {
        this.botSVelocity = botSVelocity;
    }

    public double getBotSVelocity() {
        return this.botSVelocity;
    }

    public void setTopDensity(double topDensity) {
        this.topDensity = topDensity;
    }

    public double getTopDensity() {
        return this.topDensity;
    }

    public void setBotDensity(double botDensity) {
        this.botDensity = botDensity;
    }

    public double getBotDensity() {
        return this.botDensity;
    }

    public boolean densityIsDefault() {
        return this.topDensity == DEFAULT_DENSITY && this.botDensity == DEFAULT_DENSITY;
    }

    public void setTopQp(double topQp) {
        this.topQp = topQp;
    }

    public double getTopQp() {
        return this.topQp;
    }

    public void setBotQp(double botQp) {
        this.botQp = botQp;
    }

    public double getBotQp() {
        return this.botQp;
    }

    public boolean QpIsDefault() {
        return this.topQp == DEFAULT_QP && this.botQp == DEFAULT_QP;
    }

    public boolean QIsDefault() {
        return this.QpIsDefault() && this.QsIsDefault();
    }

    public void setTopQs(double topQs) {
        this.topQs = topQs;
    }

    public double getTopQs() {
        return this.topQs;
    }

    public void setBotQs(double botQs) {
        this.botQs = botQs;
    }

    public double getBotQs() {
        return this.botQs;
    }

    public boolean QsIsDefault() {
        return this.topQs == DEFAULT_QS && this.botQs == DEFAULT_QS;
    }

    public double getThickness() {
        return this.getBotDepth() - this.getTopDepth();
    }

    public double calcTopQpFromQs() {
        return VelocityLayer.calcQpFromQs(this.getTopQs(), this.getTopPVelocity(), this.getTopSVelocity());
    }

    public double calcBotQpFromQs() {
        return VelocityLayer.calcQpFromQs(this.getBotQs(), this.getBotPVelocity(), this.getBotSVelocity());
    }

    public static double calcQpFromQs(double Qs, double vp, double vs) {
        return 0.75 * (vp * vp / (vs * vs)) * Qs;
    }
}

