/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhaseSymbols {
    public static final char P = 'P';
    public static final char S = 'S';
    public static final char K = 'K';
    public static final char I = 'I';
    public static final char J = 'J';
    public static final char p = 'p';
    public static final char s = 's';
    public static final char k = 'k';
    public static final char y = 'y';
    public static final char j = 'j';
    public static final char m = 'm';
    public static final char c = 'c';
    public static final char i = 'i';
    public static final char NAMED_DISCON_START = '_';
    public static final char NAMED_DISCON_END = '_';
    public static final char TOPSIDE_REFLECTION = 'v';
    public static final char TOPSIDE_CRITICAL_REFLECTION = 'V';
    public static final char UNDERSIDE_REFLECTION = '^';
    public static final String HEAD_CODE = "n";
    public static final String DIFF = "diff";
    public static final String DIFFDOWN = "diffdn";
    public static final char g = 'g';
    public static final char b = 'b';
    public static final String KMPS_CODE = "kmps";
    public static final char SCATTER_CODE = 'o';
    public static final char BACKSCATTER_CODE = 'O';
    public static final String EX_DOWN_CODE = "ed";
    public static final String END_CODE = "END";
    public static final String START_CODE = "START";

    public static boolean isCompressionalWaveSymbol(String name) {
        return PhaseSymbols.isCompressionalWaveSymbol(name, 0);
    }

    public static boolean isCompressionalWaveSymbol(String name, int offset) {
        char c = name.charAt(offset);
        return c == 'P' || c == 'p' || c == 'K' || c == 'k' || c == 'I' || c == 'y';
    }

    public static boolean isTransverseWaveSymbol(String name) {
        return PhaseSymbols.isTransverseWaveSymbol(name, 0);
    }

    public static boolean isTransverseWaveSymbol(String name, int offset) {
        char c = name.charAt(offset);
        return c == 'S' || c == 's' || c == 'J' || c == 'j';
    }

    public static boolean isDowngoingSymbol(String name) {
        return PhaseSymbols.isDowngoingSymbol(name, 0);
    }

    public static boolean isDowngoingSymbol(String name, int offset) {
        char c = name.charAt(offset);
        return c == 'P' || c == 'S' || c == 'K' || c == 'I' || c == 'J';
    }

    public static boolean isExclusiveDowngoingSymbol(String name) {
        return PhaseSymbols.isExclusiveDowngoingSymbol(name, 0);
    }

    public static boolean isExclusiveDowngoingSymbol(String name, int offset) {
        return PhaseSymbols.isDowngoingSymbol(name, offset) && name.startsWith(EX_DOWN_CODE, offset + 1);
    }

    public static boolean isUpgoingSymbol(String name) {
        return PhaseSymbols.isUpgoingSymbol(name, 0);
    }

    public static boolean isUpgoingSymbol(String name, int offset) {
        char c = name.charAt(offset);
        return c == 'p' || c == 's' || c == 'k' || c == 'y' || c == 'j';
    }

    public static boolean isReflectSymbol(String name) {
        return PhaseSymbols.isReflectSymbol(name, 0);
    }

    public static boolean isReflectSymbol(String name, int offset) {
        return PhaseSymbols.isTopsideReflectSymbol(name, offset) || PhaseSymbols.isUndersideReflectSymbol(name, offset);
    }

    public static boolean isTopsideReflectSymbol(String name, int offset) {
        char c = name.charAt(offset);
        return c == 'v' || c == 'V' || c == 'i' || c == 'c';
    }

    public static boolean isCriticalReflectSymbol(String name) {
        return PhaseSymbols.isReflectSymbol(name, 0) && name.charAt(0) == 'V';
    }

    public static boolean isUndersideReflectSymbol(String name, int offset) {
        return name.charAt(offset) == '^';
    }

    public static boolean isScatterSymbol(String name) {
        return PhaseSymbols.isScatterSymbol(name, 0);
    }

    public static boolean isScatterSymbol(String name, int offset) {
        char c = name.charAt(offset);
        return c == 'o' || c == 'O';
    }

    public static boolean isCrustMantleLeg(String name) {
        return PhaseSymbols.isCrustMantleLeg(name, 0);
    }

    public static boolean isCrustMantleLeg(String name, int offset) {
        char c = name.charAt(offset);
        return c == 'P' || c == 'S' || c == 'p' || c == 's';
    }

    public static boolean isOuterCoreLeg(String name) {
        return PhaseSymbols.isOuterCoreLeg(name, 0);
    }

    public static boolean isOuterCoreLeg(String name, int offset) {
        char c = name.charAt(offset);
        return c == 'K' || c == 'k';
    }

    public static boolean isInnerCoreLeg(String name) {
        return PhaseSymbols.isInnerCoreLeg(name, 0);
    }

    public static boolean isInnerCoreLeg(String name, int offset) {
        char c = name.charAt(offset);
        return c == 'I' || c == 'y' || c == 'J' || c == 'j';
    }

    public static boolean isDiffracted(String name) {
        return PhaseSymbols.isDiffracted(name, 0);
    }

    public static boolean isDiffracted(String name, int offset) {
        Pattern phaseRegEx = Pattern.compile("^(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)(?<hd>(?:diffdn)|(?:diff)|n))");
        Matcher m = phaseRegEx.matcher(name.substring(offset));
        if (m.find()) {
            return DIFF.equals(m.group("hd"));
        }
        return false;
    }

    public static boolean isUpDiffracted(String name, int offset) {
        Pattern phaseRegEx = Pattern.compile("^(([pskyj]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)(?<hd>(?:diff)))");
        Matcher m = phaseRegEx.matcher(name.substring(offset));
        if (m.find()) {
            return DIFF.equals(m.group("hd"));
        }
        return false;
    }

    public static boolean isDiffractedDown(String name) {
        return PhaseSymbols.isDiffractedDown(name, 0);
    }

    public static boolean isDiffractedDown(String name, int offset) {
        Pattern phaseRegEx = Pattern.compile("^(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)(?<hd>(?:diffdn)|(?:diff)|n))");
        Matcher m = phaseRegEx.matcher(name.substring(offset));
        if (m.find()) {
            return DIFFDOWN.equals(m.group("hd"));
        }
        return false;
    }

    public static boolean isHead(String name) {
        return PhaseSymbols.isHead(name, 0);
    }

    public static boolean isHead(String name, int offset) {
        Pattern phaseRegEx = Pattern.compile("^(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)(?<hd>(?:diffdn)|(?:diff)|n))");
        Matcher m = phaseRegEx.matcher(name.substring(offset));
        if (m.find()) {
            return HEAD_CODE.equals(m.group("hd"));
        }
        return false;
    }

    public static boolean isSurfaceWave(String name) {
        return PhaseSymbols.isSurfaceWave(name, 0);
    }

    public static boolean isSurfaceWave(String name, int offset) {
        int idx = offset;
        char c = name.charAt(idx);
        while (Character.isDigit(c) || c == '.') {
            c = name.charAt(++idx);
        }
        return name.startsWith(KMPS_CODE, idx);
    }

    public static boolean isBoundary(String name) {
        return PhaseSymbols.isBoundary(name, 0);
    }

    public static boolean isBoundary(String name, int offset) {
        char ch = name.charAt(offset);
        return Character.isDigit(ch) || ch == '.' || ch == 'm' || ch == 'c' || ch == 'i' || ch == '_';
    }

    public static boolean isCustomBoundarySymbol(String name, int offset) {
        return Objects.equals(Character.valueOf('_'), Character.valueOf(name.charAt(offset)));
    }

    public static boolean is(String leg, char symbol) {
        return leg.charAt(0) == symbol && leg.length() == 1;
    }

    public static boolean is(String leg, String symbol) {
        return Objects.equals(leg, symbol);
    }

    public static boolean startsWith(String leg, char symbol) {
        return leg.charAt(0) == symbol;
    }

    public static boolean startsWith(String leg, String symbol) {
        return leg.startsWith(symbol);
    }
}

